/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.model.ModulesCategory;
import org.eclipse.team.internal.ccvs.ui.repo.RepositorySorter;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CVSWorkingSetPage
extends CVSWizardPage
implements IWorkingSetPage {
    private IWorkingSet workingSet;
    private String workingSetName = "";
    private Set checkedFolders;
    private Map modulesCategoryCache = new HashMap();
    private boolean editing = false;
    private Text nameField;
    private CheckboxTreeViewer tree;
    private ICheckStateListener checkStateListener;

    public CVSWorkingSetPage(String pageName, String title, ImageDescriptor titleImage, String description) {
        super(pageName, title, titleImage, description);
        this.checkedFolders = new HashSet();
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.cvs.ui.working_set_folder_selection_page_context");
        CVSWizardPage.createLabel(composite, Policy.bind("CVSWorkingSetFolderSelectionPage.name"));
        this.nameField = CVSWizardPage.createTextField(composite);
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                CVSWorkingSetPage.this.workingSetName = CVSWorkingSetPage.this.nameField.getText();
                CVSWorkingSetPage.this.updateWidgetEnablements();
            }
        });
        this.createWrappingLabel(composite, Policy.bind("CVSWorkingSetFolderSelectionPage.treeLabel"), 0, 2);
        this.tree = this.createFolderSelectionTree(composite, 2);
        this.checkStateListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CVSWorkingSetPage.this.handleChecked(event.getElement(), event.getChecked());
            }
        };
        this.tree.addCheckStateListener(this.checkStateListener);
        this.tree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                CVSWorkingSetPage.this.handleExpansion(event.getElement());
            }
        });
        CVSWizardPage.createLabel(composite, "");
        Button refresh = new Button(composite, 8);
        refresh.setText(Policy.bind("CVSWorkingSetFolderSelectionPage.refresh"));
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        data.horizontalSpan = 1;
        refresh.setLayoutData((Object)data);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVSWorkingSetPage.this.refreshTree();
            }
        });
        this.initializeValues();
        this.updateWidgetEnablements();
        this.nameField.setFocus();
        Dialog.applyDialogFont((Control)parent);
    }

    public void handleExpansion(Object element) {
        if (element instanceof ICVSRepositoryLocation) {
            ICVSRepositoryLocation location = (ICVSRepositoryLocation)element;
            this.tree.setGrayed((Object)this.getModuleCategory(location), true);
        }
        this.updateCheckState(element);
    }

    public void handleChecked(Object object, boolean checked) {
        if (object instanceof ICVSRepositoryLocation) {
            ICVSRepositoryLocation location = (ICVSRepositoryLocation)object;
            if (checked) {
                this.repositoryLocationChecked(location);
            } else {
                this.repositoryLocationUnchecked(location);
            }
        } else if (object instanceof ModulesCategory) {
            ModulesCategory category = (ModulesCategory)object;
            if (checked) {
                this.modulesCategoryChecked(category);
            } else {
                this.modulesCategoryUnchecked(category);
            }
        } else if (object instanceof ICVSRemoteFolder) {
            ICVSRemoteFolder folder = (ICVSRemoteFolder)object;
            if (checked) {
                this.folderChecked(folder);
            } else {
                this.folderUnchecked(folder);
            }
        }
        this.updateWidgetEnablements();
    }

    public ModulesCategory getModuleCategory(ICVSRepositoryLocation location) {
        ModulesCategory category = (ModulesCategory)this.modulesCategoryCache.get(location.getLocation());
        if (category == null) {
            category = new ModulesCategory(location);
            this.modulesCategoryCache.put(location.getLocation(), category);
            category.setRunnableContext((IRunnableContext)this.getContainer());
        }
        return category;
    }

    private void folderUnchecked(ICVSRemoteFolder folder) {
        this.checkedFolders.remove(folder);
    }

    private void folderChecked(ICVSRemoteFolder folder) {
        this.checkedFolders.add(folder);
    }

    private void repositoryLocationChecked(ICVSRepositoryLocation location) {
        Object[] elements = this.tree.getCheckedElements();
        boolean stayChecked = false;
        int i = 0;
        while (i < elements.length) {
            ICVSRemoteFolder folder;
            Object object = elements[i];
            if (object instanceof ICVSRemoteFolder && (folder = (ICVSRemoteFolder)object).getRepository().equals(location)) {
                stayChecked = true;
            }
            ++i;
        }
        if (!stayChecked) {
            this.tree.setChecked((Object)location, false);
        }
    }

    private void repositoryLocationUnchecked(ICVSRepositoryLocation location) {
        Iterator iter = this.checkedFolders.iterator();
        while (iter.hasNext()) {
            ICVSRemoteFolder folder = (ICVSRemoteFolder)iter.next();
            if (!folder.getRepository().equals(location)) continue;
            this.tree.setChecked((Object)folder, false);
            iter.remove();
        }
    }

    private void modulesCategoryChecked(ModulesCategory category) {
        ICVSRepositoryLocation location = category.getRepository();
        Object[] elements = this.tree.getCheckedElements();
        boolean stayChecked = false;
        int i = 0;
        while (i < elements.length) {
            ICVSRemoteFolder folder;
            Object object = elements[i];
            if (object instanceof ICVSRemoteFolder && (folder = (ICVSRemoteFolder)object).getRepository().equals(location) && folder.isDefinedModule()) {
                stayChecked = true;
            }
            ++i;
        }
        if (!stayChecked) {
            this.tree.setChecked((Object)category, false);
        }
    }

    private void modulesCategoryUnchecked(ModulesCategory category) {
        ICVSRepositoryLocation location = category.getRepository();
        Iterator iter = this.checkedFolders.iterator();
        while (iter.hasNext()) {
            ICVSRemoteFolder folder = (ICVSRemoteFolder)iter.next();
            if (!folder.getRepository().equals(location) || !folder.isDefinedModule()) continue;
            this.tree.setChecked((Object)folder, false);
            iter.remove();
        }
    }

    public void refreshTree() {
        this.tree.refresh();
    }

    private void initializeValues() {
        this.nameField.setText(this.workingSetName);
        this.tree.setGrayedElements((Object[])this.getRepositoryManager().getKnownRepositoryLocations());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateWidgetEnablements() {
        this.tree.removeCheckStateListener(this.checkStateListener);
        try {
            this.updateCheckState(null);
            if (this.workingSetName.length() == 0) {
                this.setPageComplete(false);
                this.setErrorMessage(null);
            } else if (!this.isValidName(this.workingSetName)) {
                this.setPageComplete(false);
                this.setErrorMessage(Policy.bind("CVSWorkingSetFolderSelectionPage.invalidWorkingSetName", this.workingSetName));
            } else if (this.isDuplicateName(this.workingSetName)) {
                this.setPageComplete(false);
                this.setErrorMessage(Policy.bind("CVSWorkingSetFolderSelectionPage.duplicateWorkingSetName", this.workingSetName));
            } else if (this.checkedFolders.isEmpty()) {
                this.setErrorMessage(Policy.bind("CVSWorkingSetFolderSelectionPage.mustSelectFolder"));
                this.setPageComplete(false);
            } else {
                this.setPageComplete(true);
                this.setErrorMessage(null);
            }
            Object var1_3 = null;
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.tree.addCheckStateListener(this.checkStateListener);
            throw throwable;
        }
        this.tree.addCheckStateListener(this.checkStateListener);
    }

    private void updateCheckState(Object expanded) {
        ICVSRepositoryLocation[] locations = this.getRepositoryManager().getKnownRepositoryLocations();
        HashSet<ICVSRepositoryLocation> checkedLocations = new HashSet<ICVSRepositoryLocation>();
        HashSet<ModulesCategory> checkedCategories = new HashSet<ModulesCategory>();
        ArrayList<Object> expandedParents = new ArrayList<Object>();
        expandedParents.addAll(Arrays.asList(this.tree.getExpandedElements()));
        if (expanded != null) {
            expandedParents.add(expanded);
        }
        Iterator iter = this.checkedFolders.iterator();
        while (iter.hasNext()) {
            ICVSRemoteFolder folder = (ICVSRemoteFolder)iter.next();
            checkedLocations.add(folder.getRepository());
            if (folder.isDefinedModule()) {
                ModulesCategory category = this.getModuleCategory(folder.getRepository());
                checkedCategories.add(this.getModuleCategory(folder.getRepository()));
                if (!expandedParents.contains(category)) continue;
                this.tree.setChecked((Object)folder, true);
                continue;
            }
            if (!expandedParents.contains(folder.getRepository())) continue;
            this.tree.setChecked((Object)folder, true);
        }
        int i = 0;
        while (i < locations.length) {
            ICVSRepositoryLocation location = locations[i];
            this.tree.setChecked((Object)location, checkedLocations.contains(location));
            ++i;
        }
        Iterator iter2 = this.modulesCategoryCache.values().iterator();
        while (iter2.hasNext()) {
            ModulesCategory element = (ModulesCategory)iter2.next();
            if (!expandedParents.contains(element.getRepository())) continue;
            this.tree.setChecked((Object)element, checkedCategories.contains(element));
        }
    }

    private boolean isValidName(String workingSetName) {
        if (workingSetName.length() == 0) {
            return false;
        }
        if (workingSetName.startsWith(" ")) {
            return false;
        }
        if (workingSetName.endsWith(" ")) {
            return false;
        }
        int i = 0;
        while (i < workingSetName.length()) {
            char c = workingSetName.charAt(i);
            if (!Character.isLetterOrDigit(c) && !Character.isSpaceChar(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isDuplicateName(String workingSetName) {
        String originalWorkingSetName = this.workingSet.getName();
        if (originalWorkingSetName != null && workingSetName.equals(originalWorkingSetName)) {
            return false;
        }
        IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
        int i = 0;
        while (i < workingSets.length) {
            if (workingSetName.equals(workingSets[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected CheckboxTreeViewer createFolderSelectionTree(Composite composite, int span) {
        CheckboxTreeViewer tree = new CheckboxTreeViewer(composite, 2816);
        tree.setUseHashlookup(true);
        tree.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof CVSWorkingSetPage) {
                    return CVSWorkingSetPage.this.getRepositoryManager().getKnownRepositoryLocations();
                }
                if (parentElement instanceof ICVSRepositoryLocation) {
                    ICVSRepositoryLocation location = (ICVSRepositoryLocation)parentElement;
                    ArrayList<ModulesCategory> result = new ArrayList<ModulesCategory>();
                    result.add(CVSWorkingSetPage.this.getModuleCategory(location));
                    result.addAll(Arrays.asList(CVSWorkingSetPage.this.getChildren((ICVSRepositoryLocation)parentElement)));
                    return result.toArray(new Object[result.size()]);
                }
                if (parentElement instanceof ModulesCategory) {
                    ModulesCategory modules = (ModulesCategory)parentElement;
                    return modules.getChildren(modules);
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof ICVSRemoteFolder) {
                    return ((ICVSRemoteFolder)element).getRepository();
                }
                return null;
            }

            public boolean hasChildren(Object parentElement) {
                return parentElement instanceof CVSWorkingSetPage || parentElement instanceof ICVSRepositoryLocation || parentElement instanceof ModulesCategory;
            }
        });
        tree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        tree.setSorter((ViewerSorter)new RepositorySorter());
        tree.setInput((Object)this);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        data.horizontalSpan = span;
        tree.getControl().setLayoutData((Object)data);
        return tree;
    }

    public ICVSRemoteResource[] getChildren(final ICVSRepositoryLocation location) {
        final ICVSRemoteResource[][] result = new ICVSRemoteResource[1][0];
        result[0] = null;
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        result[0] = location.members(CVSTag.DEFAULT, false, monitor);
                    }
                    catch (CVSException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(this.getContainer().getShell(), null, null, e, 1);
        }
        catch (InterruptedException interruptedException) {}
        return result[0];
    }

    public ICVSRepositoryLocation[] getRepositoryLocationsWithCheckedChildren() {
        HashSet<ICVSRepositoryLocation> locations = new HashSet<ICVSRepositoryLocation>();
        Iterator iter = this.checkedFolders.iterator();
        while (iter.hasNext()) {
            ICVSRemoteFolder element = (ICVSRemoteFolder)iter.next();
            locations.add(element.getRepository());
        }
        return locations.toArray(new ICVSRepositoryLocation[locations.size()]);
    }

    public String getWorkingSetName() {
        return this.workingSetName;
    }

    public ICVSRemoteFolder[] getSelectedFolders() {
        return this.checkedFolders.toArray(new ICVSRemoteFolder[this.checkedFolders.size()]);
    }

    public void finish() {
    }

    public IWorkingSet getSelection() {
        return this.workingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        this.workingSet = workingSet;
        this.workingSetName = workingSet.getName();
    }
}

