/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class CVSWorkingSet {
    IWorkingSet workingSet;
    IProject[] includedProjects;
    IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            IWorkingSet changedSet = this.getChangedSet(event);
            if (changedSet == null || !changedSet.equals(CVSWorkingSet.this.workingSet)) {
                return;
            }
            String property = event.getProperty();
            if (property.equals("workingSetContentChange")) {
                CVSWorkingSet.this.includedProjects = null;
            } else if (property.equals("workingSetRemove")) {
                CVSWorkingSet.this.workingSet = null;
                CVSWorkingSet.this.includedProjects = null;
            }
        }

        private IWorkingSet getChangedSet(PropertyChangeEvent event) {
            Object old = event.getOldValue();
            if (old instanceof IWorkingSet) {
                return (IWorkingSet)old;
            }
            Object newSet = event.getNewValue();
            if (newSet instanceof IWorkingSet) {
                return (IWorkingSet)newSet;
            }
            return null;
        }
    };
    static /* synthetic */ Class class$0;

    public CVSWorkingSet(IWorkingSet workingSet) {
        this.workingSet = workingSet;
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.listener);
    }

    public void dispose() {
        PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.listener);
    }

    private void initializeProjects() {
        if (this.workingSet == null) {
            this.includedProjects = null;
            return;
        }
        IAdaptable[] adaptables = this.workingSet.getElements();
        HashSet<IProject> projects = new HashSet<IProject>();
        int i = 0;
        while (i < adaptables.length) {
            Object adapted;
            IAdaptable adaptable = adaptables[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapted = adaptable.getAdapter((Class)clazz)) != null) {
                IProject project = ((IResource)adapted).getProject();
                projects.add(project);
            }
            ++i;
        }
        this.includedProjects = projects.toArray(new IProject[projects.size()]);
    }

    public boolean select(ICVSRemoteResource remoteResource) {
        if (this.workingSet == null) {
            return true;
        }
        if (this.includedProjects == null) {
            this.initializeProjects();
        }
        int i = 0;
        while (i < this.includedProjects.length) {
            IProject project = this.includedProjects[i];
            if (project.getName().equals(remoteResource.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

