/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IConnectionMethod;
import org.eclipse.team.internal.ccvs.core.IUserInfo;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.team.internal.ui.dialogs.DetailsDialogWithProjects;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class CVSRepositoryPropertiesPage
extends PropertyPage {
    ICVSRepositoryLocation location;
    Text userText;
    Text passwordText;
    Combo methodType;
    Label hostLabel;
    Label pathLabel;
    Label portLabel;
    boolean passwordChanged;
    boolean connectionInfoChanged;
    IUserInfo info;
    private Button useLocationAsLabel;
    private Button useCustomLabel;
    private Text labelText;
    private Button useDefaultReadWriteLocations;
    private Button useCustomReadWriteLocations;
    private Combo readLocation;
    private Combo writeLocation;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        this.initialize();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        Composite labelGroup = new Composite(composite, 0);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        labelGroup.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        labelGroup.setLayout((Layout)layout);
        Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                CVSRepositoryPropertiesPage.this.updateWidgetEnablements();
            }
        };
        this.useLocationAsLabel = this.createRadioButton(labelGroup, Policy.bind("CVSRepositoryPropertiesPage.useLocationAsLabel"), 3);
        this.useCustomLabel = this.createRadioButton(labelGroup, Policy.bind("CVSRepositoryPropertiesPage.useCustomLabel"), 1);
        this.useCustomLabel.addListener(13, labelListener);
        this.labelText = this.createTextField(labelGroup);
        this.labelText.addListener(24, labelListener);
        this.createLabel(composite, "", 3);
        this.createLabel(composite, Policy.bind("CVSPropertiesPage.connectionType"), 1);
        this.methodType = this.createCombo(composite);
        this.createLabel(composite, Policy.bind("CVSPropertiesPage.user"), 1);
        this.userText = this.createTextField(composite);
        this.createLabel(composite, Policy.bind("CVSPropertiesPage.password"), 1);
        this.passwordText = this.createPasswordField(composite);
        this.createLabel(composite, Policy.bind("CVSPropertiesPage.host"), 1);
        this.hostLabel = this.createLabel(composite, "", 2);
        this.createLabel(composite, Policy.bind("CVSPropertiesPage.port"), 1);
        this.portLabel = this.createLabel(composite, "", 2);
        this.createLabel(composite, Policy.bind("CVSPropertiesPage.path"), 1);
        this.pathLabel = this.createLabel(composite, "", 2);
        this.createLabel(composite, "", 3);
        this.createLabel(composite, "", 3);
        this.createReadWriteAccessComposite(composite);
        this.initializeValues();
        this.updateWidgetEnablements();
        this.passwordText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                CVSRepositoryPropertiesPage.this.passwordChanged = true;
            }
        });
        this.userText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                CVSRepositoryPropertiesPage.this.connectionInfoChanged = true;
                CVSRepositoryPropertiesPage.this.updateWidgetEnablements();
            }
        });
        this.methodType.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                CVSRepositoryPropertiesPage.this.connectionInfoChanged = true;
            }
        });
        this.useDefaultReadWriteLocations.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVSRepositoryPropertiesPage.this.updateWidgetEnablements();
            }
        });
        this.useCustomReadWriteLocations.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVSRepositoryPropertiesPage.this.updateWidgetEnablements();
            }
        });
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.team.cvs.ui.repository_location_property_page_context");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void createReadWriteAccessComposite(Composite composite) {
        Composite radioGroup = this.createRadioGroupComposite(composite);
        this.useDefaultReadWriteLocations = this.createRadioButton(radioGroup, "Use this location's connection information for all connections", 3);
        this.useCustomReadWriteLocations = this.createRadioButton(radioGroup, "Use the following locations for read and write access", 3);
        this.createLabel(composite, "Read:", 1);
        this.readLocation = this.createCombo(composite);
        this.createLabel(composite, "Write:", 1);
        this.writeLocation = this.createCombo(composite);
    }

    private Composite createRadioGroupComposite(Composite composite) {
        Composite radioGroup = new Composite(composite, 0);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        radioGroup.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        radioGroup.setLayout((Layout)layout);
        return radioGroup;
    }

    protected Combo createCombo(Composite parent) {
        Combo combo = new Combo(parent, 8);
        GridData data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 2;
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Text createTextField(Composite parent) {
        Text text = new Text(parent, 2052);
        return this.layoutTextField(text);
    }

    protected Text createPasswordField(Composite parent) {
        Text text = new Text(parent, 0x400804);
        return this.layoutTextField(text);
    }

    protected Text layoutTextField(Text text) {
        GridData data = new GridData(768);
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        data.widthHint = 200;
        data.horizontalSpan = 2;
        text.setLayoutData((Object)data);
        return text;
    }

    protected Button createRadioButton(Composite parent, String label, int span) {
        Button button = new Button(parent, 16);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = span;
        button.setLayoutData((Object)data);
        return button;
    }

    private void initialize() {
        this.location = null;
        IAdaptable element = this.getElement();
        if (element instanceof ICVSRepositoryLocation) {
            this.location = (ICVSRepositoryLocation)element;
        } else {
            Object adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = element.getAdapter((Class)clazz)) instanceof ICVSRepositoryLocation) {
                this.location = (ICVSRepositoryLocation)adapter;
            }
        }
    }

    private void initializeValues() {
        this.passwordChanged = false;
        IConnectionMethod[] methods = CVSRepositoryLocation.getPluggedInConnectionMethods();
        int i = 0;
        while (i < methods.length) {
            this.methodType.add(methods[i].getName());
            ++i;
        }
        String method = this.location.getMethod().getName();
        this.methodType.select(this.methodType.indexOf(method));
        this.info = this.location.getUserInfo(true);
        this.userText.setText(this.info.getUsername());
        this.passwordText.setText("*********");
        this.hostLabel.setText(this.location.getHost());
        int port = this.location.getPort();
        if (port == 0) {
            this.portLabel.setText(Policy.bind("CVSPropertiesPage.defaultPort"));
        } else {
            this.portLabel.setText("" + port);
        }
        this.pathLabel.setText(this.location.getRootDirectory());
        String label = null;
        RepositoryRoot root = CVSUIPlugin.getPlugin().getRepositoryManager().getRepositoryRootFor(this.location);
        label = root.getName();
        this.useLocationAsLabel.setSelection(label == null);
        this.useCustomLabel.setSelection(!this.useLocationAsLabel.getSelection());
        if (label == null) {
            label = this.location.getLocation();
        }
        this.labelText.setText(label);
        String currentReadLocation = ((CVSRepositoryLocation)root.getRoot()).getReadLocation();
        String currentWriteLocation = ((CVSRepositoryLocation)root.getRoot()).getWriteLocation();
        try {
            if (currentReadLocation != null) {
                CVSProviderPlugin.getPlugin().getRepository(currentReadLocation);
            }
            if (currentWriteLocation != null) {
                CVSProviderPlugin.getPlugin().getRepository(currentWriteLocation);
            }
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        ICVSRepositoryLocation[] locations = CVSProviderPlugin.getPlugin().getKnownRepositories();
        int i2 = 0;
        while (i2 < locations.length) {
            ICVSRepositoryLocation location = locations[i2];
            this.readLocation.add(location.getLocation());
            this.writeLocation.add(location.getLocation());
            ++i2;
        }
        this.readLocation.setText(currentReadLocation == null ? root.getRoot().getLocation() : currentReadLocation);
        this.writeLocation.setText(currentWriteLocation == null ? root.getRoot().getLocation() : currentWriteLocation);
        if (currentReadLocation == null && currentWriteLocation == null) {
            this.useDefaultReadWriteLocations.setSelection(true);
            this.useCustomReadWriteLocations.setSelection(false);
        } else {
            this.useDefaultReadWriteLocations.setSelection(false);
            this.useCustomReadWriteLocations.setSelection(true);
        }
    }

    private boolean performConnectionInfoChanges() {
        if (!this.passwordChanged && !this.connectionInfoChanged) {
            return true;
        }
        try {
            if (this.passwordChanged && !this.connectionInfoChanged) {
                CVSRepositoryLocation oldLocation = (CVSRepositoryLocation)this.location;
                oldLocation.setPassword(this.getNewPassword());
                oldLocation.updateCache();
                this.passwordChanged = false;
                return true;
            }
            final boolean[] result = new boolean[1];
            new ProgressMonitorDialog(this.getShell()).run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CVSRepositoryLocation newLocation;
                        block15: {
                            block14: {
                                newLocation = CVSRepositoryLocation.fromString((String)CVSRepositoryPropertiesPage.this.location.getLocation());
                                newLocation.setMethod(CVSRepositoryPropertiesPage.this.methodType.getText());
                                CVSRepositoryPropertiesPage.this.info.setUsername(CVSRepositoryPropertiesPage.this.userText.getText());
                                if (CVSRepositoryPropertiesPage.this.passwordChanged) {
                                    CVSRepositoryPropertiesPage.this.info.setPassword(CVSRepositoryPropertiesPage.this.getNewPassword());
                                }
                                newLocation.setUserInfo(CVSRepositoryPropertiesPage.this.info);
                                try {
                                    block13: {
                                        ArrayList<IProject> projects = new ArrayList<IProject>();
                                        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                                        int i = 0;
                                        while (true) {
                                            CVSTeamProvider cvsProvider;
                                            if (i >= allProjects.length) {
                                                if (projects.size() <= 0) break block13;
                                                DetailsDialogWithProjects dialog = new DetailsDialogWithProjects(CVSRepositoryPropertiesPage.this.getShell(), Policy.bind("CVSRepositoryPropertiesPage.Confirm_Project_Sharing_Changes_1"), Policy.bind("CVSRepositoryPropertiesPage.There_are_projects_in_the_workspace_shared_with_this_repository_2"), Policy.bind("CVSRepositoryPropertiesPage.sharedProject", CVSRepositoryPropertiesPage.this.location.toString()), projects.toArray(new IProject[projects.size()]), true, "dialog_warning_image");
                                                int r = dialog.open();
                                                if (r == 0) break;
                                                result[0] = false;
                                                Object var13_11 = null;
                                                break block14;
                                            }
                                            RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)allProjects[i], (String)CVSProviderPlugin.getTypeId());
                                            if (teamProvider != null && (cvsProvider = (CVSTeamProvider)teamProvider).getCVSWorkspaceRoot().getRemoteLocation().equals(CVSRepositoryPropertiesPage.this.location)) {
                                                projects.add(allProjects[i]);
                                            }
                                            ++i;
                                        }
                                        monitor.beginTask(null, 1000 * projects.size());
                                        try {
                                            Iterator it = projects.iterator();
                                            while (it.hasNext()) {
                                                IProject project = (IProject)it.next();
                                                RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId());
                                                CVSTeamProvider cvsProvider = (CVSTeamProvider)teamProvider;
                                                cvsProvider.setRemoteRoot((ICVSRepositoryLocation)newLocation, Policy.subMonitorFor(monitor, 1000));
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var11_18 = null;
                                            monitor.done();
                                            throw throwable;
                                        }
                                        {
                                            Object var11_19 = null;
                                        }
                                        monitor.done();
                                    }
                                    CVSUIPlugin.getPlugin().getRepositoryManager().replaceRepositoryLocation(CVSRepositoryPropertiesPage.this.location, newLocation);
                                    break block15;
                                }
                                catch (Throwable throwable) {
                                    Object var13_12 = null;
                                    newLocation = (CVSRepositoryLocation)CVSProviderPlugin.getPlugin().getRepository(newLocation.getLocation());
                                    newLocation.updateCache();
                                    throw throwable;
                                }
                            }
                            newLocation = (CVSRepositoryLocation)CVSProviderPlugin.getPlugin().getRepository(newLocation.getLocation());
                            newLocation.updateCache();
                            return;
                        }
                        Object var13_13 = null;
                        newLocation = (CVSRepositoryLocation)CVSProviderPlugin.getPlugin().getRepository(newLocation.getLocation());
                        newLocation.updateCache();
                        CVSRepositoryPropertiesPage.this.location = newLocation;
                        CVSRepositoryPropertiesPage.this.connectionInfoChanged = false;
                        CVSRepositoryPropertiesPage.this.passwordChanged = false;
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                    result[0] = true;
                }
            });
            return result[0];
        }
        catch (InvocationTargetException e) {
            this.handle(e);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CVSException e) {
            this.handle(e);
        }
        return false;
    }

    private void performNonConnectionInfoChanges() {
        this.recordNewLabel((CVSRepositoryLocation)this.location);
        this.recordReadWriteLocations((CVSRepositoryLocation)this.location);
    }

    public boolean performOk() {
        if (this.performConnectionInfoChanges()) {
            this.performNonConnectionInfoChanges();
            return true;
        }
        return false;
    }

    protected void handle(Throwable e) {
        CVSUIPlugin.openError(this.getShell(), null, null, e);
    }

    protected void updateWidgetEnablements() {
        if (this.useLocationAsLabel.getSelection()) {
            this.labelText.setEnabled(false);
        } else {
            this.labelText.setEnabled(true);
        }
        if (this.useDefaultReadWriteLocations.getSelection()) {
            this.readLocation.setEnabled(false);
            this.writeLocation.setEnabled(false);
        } else {
            this.readLocation.setEnabled(true);
            this.writeLocation.setEnabled(true);
        }
        this.validateFields();
    }

    private void validateFields() {
        if (this.labelText.isEnabled() && this.labelText.getText().length() == 0) {
            this.setValid(false);
            return;
        }
        String user = this.userText.getText();
        if (user.indexOf(64) != -1 || user.indexOf(58) != -1) {
            this.setErrorMessage(Policy.bind("ConfigurationWizardMainPage.invalidUserName"));
            this.setValid(false);
            return;
        }
        this.setErrorMessage(null);
        this.setValid(true);
    }

    private void recordNewLabel(CVSRepositoryLocation location) {
        String oldLabel;
        String newLabel = this.getNewLabel(location);
        if (newLabel == null ? (oldLabel = this.getOldLabel(location)) == null || oldLabel.equals(location.getLocation()) : newLabel.equals(this.getOldLabel(location))) {
            return;
        }
        try {
            CVSUIPlugin.getPlugin().getRepositoryManager().setLabel(location, newLabel);
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    private String getOldLabel(CVSRepositoryLocation location) {
        return CVSUIPlugin.getPlugin().getRepositoryManager().getRepositoryRootFor((ICVSRepositoryLocation)location).getName();
    }

    private String getNewLabel(CVSRepositoryLocation location) {
        String label = null;
        if (this.useCustomLabel.getSelection() && (label = this.labelText.getText()).equals(location.getLocation())) {
            label = null;
        }
        return label;
    }

    String getNewPassword() {
        return this.passwordText.getText();
    }

    private void recordReadWriteLocations(CVSRepositoryLocation location) {
        location.setReadLocation(this.useDefaultReadWriteLocations.getSelection() ? null : this.readLocation.getText());
        location.setWriteLocation(this.useDefaultReadWriteLocations.getSelection() ? null : this.writeLocation.getText());
    }
}

