/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.RTag;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.TagAction;
import org.eclipse.team.internal.ccvs.ui.operations.ITagOperation;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteOperation;

public class TagInRepositoryOperation
extends RemoteOperation
implements ITagOperation {
    private Set localOptions = new HashSet();
    private CVSTag tag;

    public TagInRepositoryOperation(Shell shell, ICVSRemoteResource[] remoteResource) {
        super(shell, remoteResource);
    }

    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        ICVSRemoteResource[] resources = this.getRemoteResources();
        monitor.beginTask(null, 1000 * resources.length);
        int i = 0;
        while (i < resources.length) {
            IStatus status = resources[i].tag(this.getTag(), this.getLocalOptions(), (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            this.collectStatus(status);
            ++i;
        }
        if (!this.errorsOccurred()) {
            try {
                TagAction.broadcastTagChange(this.getCVSResources(), this.getTag());
            }
            catch (InvocationTargetException e) {
                throw CVSException.wrapException((Exception)e);
            }
        }
    }

    protected String getErrorMessage(IStatus[] problems, int operationCount) {
        if (operationCount == 1) {
            return Policy.bind("TagInRepositoryAction.tagProblemsMessage");
        }
        return Policy.bind("TagInRepositoryAction.tagProblemsMessageMultiple", Integer.toString(operationCount - problems.length), Integer.toString(problems.length));
    }

    private Command.LocalOption[] getLocalOptions() {
        return this.localOptions.toArray(new Command.LocalOption[this.localOptions.size()]);
    }

    public CVSTag getTag() {
        return this.tag;
    }

    public void setTag(CVSTag tag) {
        this.tag = tag;
    }

    public void addLocalOption(Command.LocalOption option) {
        this.localOptions.add(option);
    }

    public void moveTag() {
        this.addLocalOption(RTag.FORCE_REASSIGNMENT);
        this.addLocalOption(RTag.CLEAR_FROM_REMOVED);
    }

    public void recurse() {
        this.addLocalOption(Command.DO_NOT_RECURSE);
    }

    protected String getTaskName() {
        return Policy.bind("TagFromRepository.taskName");
    }
}

