/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;

public class ShareProjectOperation
extends CVSOperation {
    private ICVSRepositoryLocation location;
    private IProject project;
    private String moduleName;

    public ShareProjectOperation(Shell shell, ICVSRepositoryLocation location, IProject project, String moduleName) {
        super(shell);
        this.moduleName = moduleName;
        this.project = project;
        this.location = location;
    }

    protected void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        boolean alreadyExists = CVSProviderPlugin.getPlugin().isKnownRepository(this.location.getLocation());
        try {
            this.createRemoteFolder(monitor);
            this.mapProjectToRemoteFolder(monitor);
        }
        catch (CVSException e) {
            if (!alreadyExists) {
                CVSProviderPlugin.getPlugin().disposeRepository(this.location);
            }
            throw e;
        }
        if (!alreadyExists) {
            CVSProviderPlugin.getPlugin().addRepository(this.location);
        }
    }

    private void mapProjectToRemoteFolder(IProgressMonitor monitor) throws CVSException {
        try {
            final ICVSFolder folder = (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)this.project);
            final TeamException[] exception = new TeamException[1];
            final String modName = this.moduleName;
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        folder.setFolderSyncInfo(new FolderSyncInfo(modName, ShareProjectOperation.this.location.getLocation(), null, false));
                        RepositoryProvider.map((IProject)ShareProjectOperation.this.project, (String)CVSProviderPlugin.getTypeId());
                    }
                    catch (TeamException e) {
                        exception[0] = e;
                    }
                }
            }, (ISchedulingRule)this.project, 0, monitor);
            if (exception[0] != null) {
                throw exception[0];
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException((CoreException)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createRemoteFolder(IProgressMonitor monitor) throws CVSException {
        String projectName = this.project.getName();
        if (this.moduleName == null) {
            this.moduleName = projectName;
        }
        RemoteFolderTree root = new RemoteFolderTree(null, this.location, Path.EMPTY.toString(), null);
        Path path = new Path(this.moduleName);
        try {
            try {
                monitor.beginTask(this.getTaskName(), 100 * path.segmentCount());
                this.ensureTreeExists(root, (IPath)path, monitor);
            }
            catch (TeamException e) {
                throw CVSException.wrapException((CoreException)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
    }

    private RemoteFolderTree createChild(RemoteFolderTree parent, String name, IProgressMonitor monitor) throws CVSException, TeamException {
        RemoteFolderTree child = new RemoteFolderTree((RemoteFolder)parent, name, this.location, new Path(parent.getRepositoryRelativePath()).append(name).toString(), null);
        parent.setChildren(new ICVSRemoteResource[]{child});
        if (child.exists(Policy.subMonitorFor(monitor, 50))) {
            return (RemoteFolderTree)parent.getFolder(name);
        }
        this.createFolder(child, Policy.subMonitorFor(monitor, 50));
        return child;
    }

    private void ensureTreeExists(RemoteFolderTree folder, IPath path, IProgressMonitor monitor) throws TeamException {
        if (path.isEmpty()) {
            return;
        }
        String name = path.segment(0);
        RemoteFolderTree child = this.createChild(folder, name, monitor);
        this.ensureTreeExists(child, path.removeFirstSegments(1), monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createFolder(RemoteFolderTree folder, IProgressMonitor monitor) throws TeamException {
        Session s = new Session(this.location, folder.getParent());
        s.open(monitor, true);
        try {
            IStatus status = Command.ADD.execute(s, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, new String[]{folder.getName()}, null, monitor);
            if (status.getCode() == -10) throw new CVSServerException(status);
            if (!status.isOK()) {
                throw new CVSServerException(status);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            s.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        s.close();
    }

    protected String getTaskName() {
        return null;
    }
}

