/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.resources.CVSRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutToRemoteFolderOperation;

public class ReconcileProjectOperation
extends CVSOperation {
    private IProject project;
    private ICVSRemoteFolder folder;

    public ReconcileProjectOperation(Shell shell, IProject project, ICVSRemoteFolder folder) {
        super(shell);
        this.folder = folder;
        this.project = project;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        try {
            try {
                monitor.beginTask(null, 300);
                ICVSRemoteFolder remote = CheckoutToRemoteFolderOperation.checkoutRemoteFolder(this.getShell(), this.folder, Policy.subMonitorFor(monitor, 100));
                this.makeFoldersInSync(this.project, remote, Policy.subMonitorFor(monitor, 100));
                CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().setRemote(this.project, (IRemoteResource)remote, Policy.subMonitorFor(monitor, 100));
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        CVSUIPlugin.showInSyncView(ReconcileProjectOperation.this.getShell(), null, null, 0);
                    }
                });
            }
            catch (InvocationTargetException e) {
                throw CVSException.wrapException((Exception)e);
            }
            catch (TeamException e) {
                throw CVSException.wrapException((CoreException)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_7 = null;
        }
        monitor.done();
    }

    public IRemoteSyncElement makeFoldersInSync(final IProject project, ICVSRemoteFolder remote, IProgressMonitor progress) throws TeamException {
        final CVSRemoteSyncElement tree = new CVSRemoteSyncElement(true, (IResource)project, null, (IRemoteResource)remote);
        CVSWorkspaceRoot.getCVSFolderFor((IContainer)project).run(new ICVSRunnable(){

            public void run(IProgressMonitor monitor) throws CVSException {
                monitor.beginTask(null, 100);
                try {
                    tree.makeFoldersInSync(Policy.subMonitorFor(monitor, 100));
                    RepositoryProvider.map((IProject)project, (String)CVSProviderPlugin.getTypeId());
                }
                catch (TeamException e) {
                    throw CVSException.wrapException((CoreException)((Object)e));
                }
                monitor.done();
            }
        }, progress);
        return tree;
    }

    protected String getTaskName() {
        return "Reconciling project {0} with remote folder {1}" + this.project.getName() + this.folder.getRepositoryRelativePath();
    }
}

