/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;

public class HasProjectMetaFileOperation
extends CVSOperation {
    private ICVSRemoteFolder remoteFolder;
    private boolean metaFileExists;

    public static boolean hasMetaFile(Shell shell, ICVSRemoteFolder remoteFolder) throws CVSException, InterruptedException {
        HasProjectMetaFileOperation op = new HasProjectMetaFileOperation(shell, remoteFolder);
        op.run();
        return op.metaFileExists();
    }

    public HasProjectMetaFileOperation(Shell shell, ICVSRemoteFolder remoteFolder) {
        super(shell);
        this.remoteFolder = remoteFolder;
    }

    private boolean hasMetaFile(ICVSRemoteFolder folder, IProgressMonitor monitor) throws CVSException {
        folder = (ICVSRemoteFolder)folder.forTag(this.remoteFolder.getTag());
        try {
            folder.members(monitor);
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
        try {
            folder.getFile(".project");
            return true;
        }
        catch (TeamException teamException) {
            return false;
        }
    }

    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        this.metaFileExists = this.hasMetaFile(this.remoteFolder, monitor);
    }

    public boolean metaFileExists() {
        return this.metaFileExists;
    }

    protected String getTaskName() {
        return Policy.bind("HasProjectMetaFile.taskName");
    }

    public boolean canRunAsJob() {
        return false;
    }
}

