/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Checkout;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.client.UpdatedHandler;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderSandbox;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutOperation;

public class CheckoutToRemoteFolderOperation
extends CheckoutOperation {
    RemoteFolderSandbox sandbox;

    public static ICVSRemoteFolder checkoutRemoteFolder(Shell shell, ICVSRemoteFolder folder, IProgressMonitor monitor) throws CVSException, InvocationTargetException, InterruptedException {
        CheckoutToRemoteFolderOperation op = new CheckoutToRemoteFolderOperation(shell, folder);
        op.run(monitor);
        return op.getResultingFolder();
    }

    public CheckoutToRemoteFolderOperation(Shell shell, ICVSRemoteFolder remoteFolder) {
        super(shell, new ICVSRemoteFolder[]{remoteFolder});
    }

    protected IStatus checkout(ICVSRemoteFolder folder, IProgressMonitor monitor) throws CVSException {
        IPath sandboxPath = new Path(folder.getRepositoryRelativePath()).removeLastSegments(1);
        String pathString = sandboxPath.isEmpty() ? "" : sandboxPath.toString();
        this.sandbox = new RemoteFolderSandbox(null, folder.getRepository(), pathString, folder.getTag());
        return this.checkout(folder, (ICVSFolder)this.sandbox, monitor);
    }

    protected String getTaskName() {
        return "Downloading folder {0}" + this.getRemoteFolders()[0].getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus checkout(ICVSRemoteFolder resource, ICVSFolder sandbox, IProgressMonitor pm) throws CVSException {
        IStatus iStatus;
        Session session;
        block7: {
            IStatus iStatus2;
            block6: {
                ICVSRepositoryLocation repository = resource.getRepository();
                session = new Session(repository, sandbox);
                pm.beginTask(null, 100);
                Policy.checkCanceled(pm);
                session.open(Policy.subMonitorFor(pm, 5), false);
                try {
                    try {
                        ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
                        CVSTag tag = resource.getTag();
                        if (tag == null) {
                            tag = CVSTag.DEFAULT;
                        }
                        localOptions.add(Update.makeTagOption((CVSTag)tag));
                        IStatus status = new SandboxCheckout().execute(session, Command.NO_GLOBAL_OPTIONS, localOptions.toArray(new Command.LocalOption[localOptions.size()]), new String[]{resource.getName()}, null, Policy.subMonitorFor(pm, 90));
                        if (status.getCode() == -10) {
                            iStatus2 = status;
                            Object var9_13 = null;
                            break block6;
                        }
                        iStatus = CVSOperation.OK;
                        break block7;
                    }
                    catch (CVSException e) {
                        IStatus iStatus3 = e.getStatus();
                        Object var9_15 = null;
                        session.close();
                        pm.done();
                        return iStatus3;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_16 = null;
                    session.close();
                    pm.done();
                    throw throwable;
                }
            }
            session.close();
            pm.done();
            return iStatus2;
        }
        Object var9_14 = null;
        session.close();
        pm.done();
        return iStatus;
    }

    public ICVSRemoteFolder getResultingFolder() throws CVSException {
        return (ICVSRemoteFolder)this.sandbox.getFolder(this.getRemoteFolders()[0].getName());
    }

    public class CreatedResponseHandler
    extends UpdatedHandler {
        public CreatedResponseHandler() {
            super(4);
        }

        protected void receiveTargetFile(Session session, ICVSFile mFile, String entryLine, Date modTime, boolean binary, boolean readOnly, IProgressMonitor monitor) throws CVSException {
            if (mFile instanceof RemoteFile) {
                ((RemoteFile)mFile).aboutToReceiveContents(entryLine.getBytes());
                super.receiveTargetFile(session, mFile, entryLine, modTime, binary, readOnly, monitor);
                ((RemoteFile)mFile).doneReceivingContents();
            } else {
                super.receiveTargetFile(session, mFile, entryLine, modTime, binary, readOnly, monitor);
            }
        }
    }

    public class SandboxCheckout
    extends Checkout {
        protected IStatus commandFinished(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor, IStatus status) throws CVSException {
            return status;
        }

        protected IStatus doExecute(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, String[] arguments, ICommandOutputListener listener, IProgressMonitor monitor) throws CVSException {
            IStatus iStatus;
            CreatedResponseHandler newCreated = new CreatedResponseHandler();
            ResponseHandler oldCreated = session.getResponseHandler(newCreated.getResponseID());
            session.registerResponseHandler((ResponseHandler)newCreated);
            try {
                iStatus = super.doExecute(session, globalOptions, localOptions, arguments, listener, monitor);
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                session.registerResponseHandler(oldCreated);
                throw throwable;
            }
            session.registerResponseHandler(oldCreated);
            return iStatus;
        }
    }
}

