/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.client.Checkout;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Request;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutOperation;

public abstract class CheckoutProjectOperation
extends CheckoutOperation {
    private String targetLocation;

    public CheckoutProjectOperation(Shell shell, ICVSRemoteFolder[] remoteFolders, String targetLocation) {
        super(shell, remoteFolders);
        this.targetLocation = targetLocation;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createAndOpenProject(IProject project, IProgressMonitor monitor) throws CVSException {
        try {
            try {
                monitor.beginTask(null, 5);
                IProjectDescription desc = this.getDescriptionFor(project);
                if (project.exists()) {
                    if (desc != null) {
                        project.move(desc, true, Policy.subMonitorFor(monitor, 3));
                    }
                } else if (desc == null) {
                    project.create(Policy.subMonitorFor(monitor, 3));
                } else {
                    project.create(desc, Policy.subMonitorFor(monitor, 3));
                }
                if (!project.isOpen()) {
                    project.open(Policy.subMonitorFor(monitor, 2));
                }
            }
            catch (CoreException e) {
                throw CVSException.wrapException((CoreException)e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        monitor.done();
    }

    protected IProjectDescription getDescriptionFor(IProject project) {
        if (this.targetLocation == null) {
            return null;
        }
        String projectName = project.getName();
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        description.setLocation(this.getTargetLocationFor(project));
        return description;
    }

    protected IPath getTargetLocationFor(IProject project) {
        if (this.targetLocation == null) {
            return null;
        }
        return new Path(this.targetLocation);
    }

    protected String getRemoteModuleName(ICVSRemoteFolder resource) {
        String moduleName = resource.isDefinedModule() ? resource.getName() : resource.getRepositoryRelativePath();
        return moduleName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus checkout(final ICVSRemoteFolder resource, final IProject project, IProgressMonitor pm) throws CVSException {
        IStatus iStatus;
        Session session;
        block8: {
            IStatus iStatus2;
            block7: {
                IStatus iStatus3;
                block6: {
                    ICVSFolder root = CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot());
                    ICVSRepositoryLocation repository = resource.getRepository();
                    session = new Session(repository, root);
                    pm.beginTask(null, 100);
                    Policy.checkCanceled(pm);
                    session.open(Policy.subMonitorFor(pm, 5), false);
                    try {
                        try {
                            final IProject[] targetProjects = this.determineProjects(session, resource, project, Policy.subMonitorFor(pm, 5));
                            if (targetProjects == null) {
                                iStatus3 = this.getLastError();
                                Object var9_13 = null;
                                break block6;
                            }
                            if (targetProjects.length == 0) {
                                iStatus2 = CVSOperation.OK;
                                break block7;
                            }
                            final IStatus[] result = new IStatus[1];
                            EclipseSynchronizer.getInstance().run(this.getSchedulingRule(targetProjects), new ICVSRunnable(){

                                public void run(IProgressMonitor monitor) throws CVSException {
                                    result[0] = CheckoutProjectOperation.this.performCheckout(session, resource, targetProjects, project != null, Policy.subMonitorFor(monitor, 90));
                                }
                            }, Policy.subMonitorFor(pm, 90));
                            iStatus = result[0];
                            break block8;
                        }
                        catch (CVSException e) {
                            IStatus iStatus4 = e.getStatus();
                            Object var9_16 = null;
                            session.close();
                            pm.done();
                            return iStatus4;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_17 = null;
                        session.close();
                        pm.done();
                        throw throwable;
                    }
                }
                session.close();
                pm.done();
                return iStatus3;
            }
            Object var9_14 = null;
            session.close();
            pm.done();
            return iStatus2;
        }
        Object var9_15 = null;
        session.close();
        pm.done();
        return iStatus;
    }

    private ISchedulingRule getSchedulingRule(IProject[] projects) {
        if (projects.length == 1) {
            return projects[0];
        }
        return new MultiRule((ISchedulingRule[])projects);
    }

    IStatus performCheckout(Session session, ICVSRemoteFolder resource, IProject[] targetProjects, boolean sendModuleName, IProgressMonitor pm) throws CVSException {
        block8: {
            CVSTag tag;
            block7: {
                IStatus iStatus;
                String taskName = targetProjects.length == 1 ? Policy.bind("CheckoutProjectOperation.8", resource.getName(), targetProjects[0].getName()) : Policy.bind("CheckoutProjectOperation.9", resource.getName(), String.valueOf(targetProjects.length));
                pm.beginTask(taskName, 100);
                pm.setTaskName(taskName);
                Policy.checkCanceled(pm);
                try {
                    IStatus result;
                    if (!this.performScrubProjects() || (result = this.scrubProjects(resource, targetProjects, Policy.subMonitorFor(pm, 9))).isOK()) break block7;
                    iStatus = result;
                    Object var11_11 = null;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    pm.done();
                    throw throwable;
                }
                pm.done();
                return iStatus;
            }
            IProject project = targetProjects.length == 1 && (sendModuleName || targetProjects[0].getName().equals(resource.getName())) ? targetProjects[0] : null;
            ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
            if (project != null) {
                localOptions.add(Checkout.makeDirectoryNameOption((String)project.getName()));
            }
            if (CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
                localOptions.add(Checkout.PRUNE_EMPTY_DIRECTORIES);
            }
            if ((tag = resource.getTag()) == null) {
                tag = CVSTag.DEFAULT;
            }
            localOptions.add(Update.makeTagOption((CVSTag)tag));
            IStatus status = Command.CHECKOUT.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions.toArray(new Command.LocalOption[localOptions.size()]), new String[]{this.getRemoteModuleName(resource)}, null, Policy.subMonitorFor(pm, 90));
            if (status.getCode() != -10) break block8;
            IStatus iStatus = status;
            Object var11_12 = null;
            pm.done();
            return iStatus;
        }
        this.refreshProjects(targetProjects, Policy.subMonitorFor(pm, 1));
        IStatus iStatus = CVSOperation.OK;
        Object var11_13 = null;
        pm.done();
        return iStatus;
    }

    private IProject[] determineProjects(Session session, ICVSRemoteFolder remoteFolder, IProject project, IProgressMonitor pm) throws CVSException {
        HashSet<IProject> targetProjectSet = new HashSet<IProject>();
        String moduleName = this.getRemoteModuleName(remoteFolder);
        if (project == null) {
            Policy.checkCanceled(pm);
            IStatus status = Request.EXPAND_MODULES.execute(session, new String[]{moduleName}, pm);
            if (status.getCode() == -10) {
                this.collectStatus(status);
                return null;
            }
            String[] expansions = session.getModuleExpansions();
            if (expansions.length == 1 && expansions[0].equals(moduleName)) {
                String lastSegment = new Path(expansions[0]).lastSegment();
                targetProjectSet.add(ResourcesPlugin.getWorkspace().getRoot().getProject(lastSegment));
            } else {
                int j = 0;
                while (j < expansions.length) {
                    targetProjectSet.add(ResourcesPlugin.getWorkspace().getRoot().getProject(new Path(expansions[j]).segment(0)));
                    ++j;
                }
            }
        } else {
            targetProjectSet.add(project);
        }
        IProject[] targetProjects = targetProjectSet.toArray(new IProject[targetProjectSet.size()]);
        return targetProjects;
    }

    protected boolean performScrubProjects() {
        return true;
    }

    private IStatus scrubProjects(ICVSRemoteFolder remoteFolder, IProject[] projects, IProgressMonitor monitor) throws CVSException {
        IProject project;
        if (projects == null) {
            monitor.done();
            return CVSOperation.OK;
        }
        if (projects.length > 1) {
            this.setInvolvesMultipleResources(true);
        }
        int i = 0;
        while (i < projects.length) {
            project = projects[i];
            Policy.checkCanceled(monitor);
            if (this.needsPromptForOverwrite(project) && !this.promptToOverwrite(remoteFolder, project)) {
                Policy.cancelOperation();
            }
            ++i;
        }
        monitor.beginTask(null, projects.length * 100);
        i = 0;
        while (i < projects.length) {
            project = projects[i];
            this.createAndOpenProject(project, Policy.subMonitorFor(monitor, 10));
            this.scrubProject(project, Policy.subMonitorFor(monitor, 90));
            ++i;
        }
        monitor.done();
        return CVSOperation.OK;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scrubProject(IProject project, IProgressMonitor monitor) throws CVSException {
        try {
            if (RepositoryProvider.getProvider((IProject)project) != null) {
                RepositoryProvider.unmap((IProject)project);
            }
            IResource[] children = project.members(2);
            Policy.checkCanceled(monitor);
            monitor.beginTask(null, 100 + children.length * 100);
            monitor.subTask(Policy.bind("CheckoutOperation.scrubbingProject", project.getName()));
            try {
                int j = 0;
                while (true) {
                    block9: {
                        if (j < children.length) break block9;
                        EclipseSynchronizer.getInstance().flush((IContainer)project, true, Policy.subMonitorFor(monitor, 100));
                        break;
                    }
                    if (!children[j].getName().equals(".project")) {
                        children[j].delete(true, Policy.subMonitorFor(monitor, 100));
                    }
                    ++j;
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var5_9 = null;
                monitor.done();
                return;
            }
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
        catch (CoreException e) {
            throw CVSException.wrapException((CoreException)e);
        }
    }

    protected boolean needsPromptForOverwrite(IProject project) {
        File localLocation;
        IProjectDescription desc = this.getDescriptionFor(project);
        if (desc != null && (localLocation = desc.getLocation().toFile()).exists()) {
            return true;
        }
        if (project.exists()) {
            return true;
        }
        localLocation = this.getFileLocation(project);
        return localLocation.exists();
    }

    protected File getFileLocation(IProject project) {
        return new File(project.getParent().getLocation().toFile(), project.getName());
    }

    private boolean promptToOverwrite(ICVSRemoteFolder remoteFolder, IProject project) {
        return this.promptToOverwrite(Policy.bind("CheckoutOperation.confirmOverwrite"), this.getOverwritePromptMessage(remoteFolder, project));
    }

    protected String getOverwritePromptMessage(ICVSRemoteFolder remoteFolder, IProject project) {
        if (project.exists()) {
            return Policy.bind("CheckoutOperation.thisResourceExists", project.getName(), this.getRemoteModuleName(remoteFolder));
        }
        return Policy.bind("CheckoutOperation.thisExternalFileExists", project.getName(), this.getRemoteModuleName(remoteFolder));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refreshProjects(IProject[] projects, IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(null, projects.length * 100);
        try {
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                try {
                    monitor.subTask(Policy.bind("CheckoutOperation.refreshingProject", project.getName()));
                    RepositoryProvider.map((IProject)project, (String)CVSProviderPlugin.getTypeId());
                }
                catch (TeamException e) {
                    throw CVSException.wrapException((CoreException)((Object)e));
                }
                CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId());
                provider.setWatchEditEnabled(CVSProviderPlugin.getPlugin().isWatchEditEnabled());
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        monitor.done();
    }

    protected String getTaskName() {
        ICVSRemoteFolder[] remoteFolders = this.getRemoteFolders();
        if (remoteFolders.length == 1) {
            return Policy.bind("CheckoutSingleProjectOperation.taskname", remoteFolders[0].getName());
        }
        return Policy.bind("CheckoutMultipleProjectsOperation.taskName", new Integer(remoteFolders.length).toString());
    }
}

