/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.util.Assert;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CVSBlockingRunnableContext;
import org.eclipse.team.internal.ccvs.ui.operations.CVSNonblockingRunnableContext;
import org.eclipse.team.internal.ccvs.ui.operations.ICVSRunnableContext;

public abstract class CVSOperation
implements IRunnableWithProgress {
    private int statusCount;
    private boolean involvesMultipleResources = false;
    private List errors = new ArrayList();
    protected static final IStatus OK = Status.OK_STATUS;
    private Shell shell;
    private boolean confirmOverwrite = true;
    ICVSRunnableContext cvsRunnableContext;

    public CVSOperation(Shell shell) {
        this.shell = shell;
    }

    public synchronized void run() throws CVSException, InterruptedException {
        try {
            this.getCVSRunnableContext().run(this.getTaskName(), this.getSchedulingRule(), this.getPostponeBuild(), this);
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
    }

    protected boolean areJobsEnabled() {
        return true;
    }

    public boolean canRunAsJob() {
        return true;
    }

    protected ISchedulingRule getSchedulingRule() {
        return null;
    }

    protected boolean getPostponeBuild() {
        return true;
    }

    public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.startOperation();
        try {
            this.execute(monitor);
            this.endOperation();
        }
        catch (CVSException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected void startOperation() {
        this.statusCount = 0;
        this.resetErrors();
        this.confirmOverwrite = true;
    }

    protected void endOperation() throws CVSException {
        this.handleErrors(this.errors.toArray(new IStatus[this.errors.size()]));
    }

    protected abstract void execute(IProgressMonitor var1) throws CVSException, InterruptedException;

    private ICVSRunnableContext getCVSRunnableContext() {
        if (this.cvsRunnableContext == null) {
            if (this.canRunAsJob() && this.areJobsEnabled()) {
                return new CVSNonblockingRunnableContext();
            }
            return new CVSBlockingRunnableContext(this.shell);
        }
        return this.cvsRunnableContext;
    }

    public void setCVSRunnableContext(ICVSRunnableContext cvsRunnableContext) {
        this.cvsRunnableContext = cvsRunnableContext;
    }

    public Shell getShell() {
        return this.getCVSRunnableContext().getShell();
    }

    protected void addError(IStatus status) {
        if (status.isOK()) {
            return;
        }
        if (this.isLastError(status)) {
            return;
        }
        this.errors.add(status);
    }

    protected void collectStatus(IStatus status) {
        if (this.isLastError(status)) {
            return;
        }
        ++this.statusCount;
        if (!status.isOK()) {
            this.addError(status);
        }
    }

    protected void resetErrors() {
        this.errors.clear();
        this.statusCount = 0;
    }

    protected IStatus getLastError() {
        Assert.isTrue((this.errors.size() > 0 ? 1 : 0) != 0);
        IStatus status = (IStatus)this.errors.get(this.errors.size() - 1);
        return status;
    }

    private boolean isLastError(IStatus status) {
        return this.errors.size() > 0 && this.getLastError() == status;
    }

    protected void handleErrors(IStatus[] errors) throws CVSException {
        if (errors.length == 0) {
            return;
        }
        if (errors.length == 1 && this.statusCount == 1) {
            throw new CVSException(errors[0]);
        }
        MultiStatus result = new MultiStatus("org.eclipse.team.cvs.ui", 0, this.getErrorMessage(errors, this.statusCount), null);
        int i = 0;
        while (i < errors.length) {
            IStatus s = errors[i];
            if (s.isMultiStatus()) {
                result.add((IStatus)new CVSStatus(s.getSeverity(), s.getMessage(), s.getException()));
                result.addAll(s);
            } else {
                result.add(s);
            }
            ++i;
        }
        throw new CVSException((IStatus)result);
    }

    protected String getErrorMessage(IStatus[] failures, int totalOperations) {
        return Policy.bind("CVSOperation.0", String.valueOf(failures.length), String.valueOf(totalOperations));
    }

    protected boolean promptToOverwrite(String title, String msg) {
        if (!this.confirmOverwrite) {
            return true;
        }
        String[] buttons = this.involvesMultipleResources() ? new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL} : new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
        Shell displayShell = this.getShell();
        final MessageDialog dialog = new MessageDialog(displayShell, title, null, msg, 3, buttons, 0);
        displayShell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        if (this.involvesMultipleResources()) {
            switch (dialog.getReturnCode()) {
                case 0: {
                    return true;
                }
                case 1: {
                    this.confirmOverwrite = false;
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            throw new OperationCanceledException();
        }
        return dialog.getReturnCode() == 0;
    }

    protected boolean involvesMultipleResources() {
        return this.involvesMultipleResources;
    }

    public void setInvolvesMultipleResources(boolean b) {
        this.involvesMultipleResources = b;
    }

    protected abstract String getTaskName();

    protected boolean errorsOccurred() {
        Iterator iter = this.errors.iterator();
        while (iter.hasNext()) {
            IStatus status = (IStatus)iter.next();
            if (status.getSeverity() != 4) continue;
            return true;
        }
        return false;
    }
}

