/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.model;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.progress.IElementCollector;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.model.CVSModelElement;
import org.eclipse.team.internal.ccvs.ui.model.RepositoryLocationSchedulingRule;
import org.eclipse.team.internal.ccvs.ui.operations.FetchMembersOperation;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;

public class CVSTagElement
extends CVSModelElement
implements IDeferredWorkbenchAdapter {
    CVSTag tag;
    ICVSRepositoryLocation root;

    public CVSTagElement(CVSTag tag, ICVSRepositoryLocation root) {
        this.tag = tag;
        this.root = root;
    }

    public ICVSRepositoryLocation getRoot() {
        return this.root;
    }

    public CVSTag getTag() {
        return this.tag;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CVSTagElement)) {
            return false;
        }
        CVSTagElement t = (CVSTagElement)o;
        if (!this.tag.equals((Object)t.tag)) {
            return false;
        }
        return this.root.equals(t.root);
    }

    public int hashCode() {
        return this.root.hashCode() ^ this.tag.hashCode();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (!(object instanceof CVSTagElement)) {
            return null;
        }
        if (this.tag.getType() == 1 || this.tag.getType() == 0) {
            return CVSUIPlugin.getPlugin().getImageDescriptor("obj16/tag.gif");
        }
        if (this.tag.getType() == 2) {
            return CVSUIPlugin.getPlugin().getImageDescriptor("obj16/prjversions_rep.gif");
        }
        return null;
    }

    public String getLabel(Object o) {
        if (!(o instanceof CVSTagElement)) {
            return null;
        }
        return ((CVSTagElement)o).tag.getName();
    }

    public String toString() {
        return this.tag.getName();
    }

    public Object getParent(Object o) {
        if (!(o instanceof CVSTagElement)) {
            return null;
        }
        return ((CVSTagElement)o).root;
    }

    protected Object[] fetchChildren(Object o, IProgressMonitor monitor) throws TeamException {
        Object[] children = CVSUIPlugin.getPlugin().getRepositoryManager().getFoldersForTag(this.root, this.tag, monitor);
        if (this.getWorkingSet() != null) {
            children = CVSUIPlugin.getPlugin().getRepositoryManager().filterResources(this.getWorkingSet(), (ICVSRemoteResource[])children);
        }
        return children;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fetchDeferredChildren(Object o, IElementCollector collector, IProgressMonitor monitor) {
        if (this.tag.getType() == 0) {
            try {
                try {
                    monitor = Policy.monitorFor(monitor);
                    RemoteFolder folder = new RemoteFolder(null, this.root, "", this.tag);
                    monitor.beginTask(Policy.bind("RemoteFolderElement.fetchingRemoteChildren", this.root.toString()), 100);
                    FetchMembersOperation operation = new FetchMembersOperation(null, (ICVSRemoteFolder)folder, collector);
                    operation.setFilter(new FetchMembersOperation.RemoteFolderFilter(){

                        public ICVSRemoteResource[] filter(ICVSRemoteResource[] folders) {
                            return CVSUIPlugin.getPlugin().getRepositoryManager().filterResources(CVSTagElement.this.getWorkingSet(), folders);
                        }
                    });
                    operation.run(Policy.subMonitorFor(monitor, 100));
                }
                catch (InvocationTargetException e) {
                    CVSUIPlugin.log((CoreException)((Object)CVSException.wrapException((Exception)e)));
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var6_10 = null;
                monitor.done();
                return;
            }
        }
        try {
            collector.add(this.fetchChildren(o, monitor), monitor);
            return;
        }
        catch (TeamException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    public ISchedulingRule getRule(Object element) {
        return new RepositoryLocationSchedulingRule(this.root);
    }

    public boolean isContainer() {
        return true;
    }
}

