/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.merge;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.team.internal.ccvs.core.CVSMergeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.merge.MergeWizardEndPage;
import org.eclipse.team.internal.ccvs.ui.merge.MergeWizardStartPage;
import org.eclipse.team.internal.ccvs.ui.subscriber.MergeSynchronizeParticipant;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MergeWizard
extends Wizard {
    MergeWizardStartPage startPage;
    MergeWizardEndPage endPage;
    IResource[] resources;

    public void addPages() {
        IProject projectForTagRetrieval = this.resources[0].getProject();
        this.setWindowTitle(Policy.bind("MergeWizard.title"));
        ImageDescriptor mergeImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/mergestream_wizban.gif");
        this.startPage = new MergeWizardStartPage("startPage", Policy.bind("MergeWizard.start"), mergeImage);
        this.startPage.setProject(projectForTagRetrieval);
        this.addPage((IWizardPage)this.startPage);
        this.endPage = new MergeWizardEndPage("endPage", Policy.bind("MergeWizard.end"), mergeImage, this.startPage);
        this.endPage.setProject(projectForTagRetrieval);
        this.addPage((IWizardPage)this.endPage);
    }

    public boolean performFinish() {
        IWorkbenchWindow wWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (wWindow != null) {
            wWindow.getActivePage();
        }
        CVSTag startTag = this.startPage.getTag();
        CVSTag endTag = this.endPage.getTag();
        CVSMergeSubscriber s = new CVSMergeSubscriber(this.resources, startTag, endTag);
        MergeSynchronizeParticipant participant = new MergeSynchronizeParticipant(s);
        ISynchronizeManager manager = TeamUI.getSynchronizeManager();
        manager.addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
        ISynchronizeView view = manager.showSynchronizeViewInActivePage(null);
        if (view == null) {
            CVSUIPlugin.openError(this.getShell(), Policy.bind("error"), Policy.bind("Error.unableToShowSyncView"), null);
            return false;
        }
        view.display((ISynchronizeParticipant)participant);
        participant.refreshWithRemote(s.roots());
        return true;
    }

    public void setResources(IResource[] resources) {
        this.resources = resources;
    }
}

