/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.merge;

import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.sync.CVSSyncCompareInput;
import org.eclipse.team.internal.ui.sync.MergeResource;
import org.eclipse.team.internal.ui.sync.TeamFile;

public class MergeEditorInput
extends CVSSyncCompareInput {
    CVSTag start;
    CVSTag end;

    public MergeEditorInput(IResource[] resources, CVSTag start, CVSTag end) {
        super(resources, 2);
        this.start = start;
        this.end = end;
    }

    public Viewer createDiffViewer(Composite parent) {
        Viewer viewer = super.createDiffViewer(parent);
        this.getViewer().syncModeChanged(4);
        return viewer;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IRemoteSyncElement[] createSyncElements(IProgressMonitor monitor) throws TeamException {
        IResource[] resources = this.getResources();
        IRemoteSyncElement[] trees = new IRemoteSyncElement[resources.length];
        int work = 100 * resources.length;
        monitor.beginTask(null, work);
        try {
            int i = 0;
            while (i < trees.length) {
                IResource resource = resources[i];
                ICVSRemoteResource base = CVSWorkspaceRoot.getRemoteTree((IResource)resource, (CVSTag)this.start, (IProgressMonitor)Policy.subMonitorFor(monitor, 50));
                ICVSRemoteResource remote = CVSWorkspaceRoot.getRemoteTree((IResource)resource, (CVSTag)this.end, (IProgressMonitor)Policy.subMonitorFor(monitor, 50));
                trees[i] = new CVSRemoteSyncElement(true, resource, (IRemoteResource)base, (IRemoteResource)remote);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        monitor.done();
        return trees;
    }

    public CVSTag getStartTag() {
        return this.start;
    }

    public CVSTag getEndTag() {
        return this.end;
    }

    public String getTitle() {
        return Policy.bind("MergeEditorInput.title", this.start.getName(), this.end.getName());
    }

    protected void contentsChanged(ICompareInput source) {
    }

    protected IDiffElement collectResourceChanges(IDiffContainer parent, IRemoteSyncElement tree, IProgressMonitor pm) throws TeamException {
        if (!tree.isContainer()) {
            CVSRemoteSyncElement cvsTree = (CVSRemoteSyncElement)tree;
            RemoteFile base = (RemoteFile)cvsTree.getBase();
            RemoteFile remote = (RemoteFile)cvsTree.getRemote();
            if (base != null && remote != null && base.getRevision().equals(remote.getRevision())) {
                MergeResource mergeResource = new MergeResource(tree);
                TeamFile file = new TeamFile(parent, mergeResource, 0, this.getShell());
                return file;
            }
        }
        return super.collectResourceChanges(parent, tree, pm);
    }
}

