/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.console;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.client.listeners.IConsoleListener;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class CVSOutputConsole
extends MessageConsole
implements IConsoleListener,
IPropertyChangeListener {
    private Color commandColor;
    private Color messageColor;
    private Color errorColor;
    private long commandStarted = 0L;
    MessageConsoleStream commandStream = this.newMessageStream();
    MessageConsoleStream messageStream;
    MessageConsoleStream errorStream = this.newMessageStream();
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat(Policy.bind("Console.resultTimeFormat"));

    public CVSOutputConsole() {
        super("CVS", CVSUIPlugin.getPlugin().getImageDescriptor("cview16/console_view.gif"));
        this.messageStream = this.newMessageStream();
        this.commandColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_command_color");
        this.commandStream.setColor(this.commandColor);
        this.messageColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_message_color");
        this.messageStream.setColor(this.messageColor);
        this.errorColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_error_color");
        this.errorStream.setColor(this.errorColor);
        this.setFont(JFaceResources.getFont((String)this.getPreferenceStore().getString("pref_console_font")));
        CVSProviderPlugin.getPlugin().setConsoleListener((IConsoleListener)this);
        CVSUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void shutdown() {
        this.commandColor.dispose();
        this.messageColor.dispose();
        this.errorColor.dispose();
    }

    public void commandInvoked(String line) {
        this.commandStarted = System.currentTimeMillis();
        this.commandStream.println(Policy.bind("Console.preExecutionDelimiter"));
        this.commandStream.println(line);
    }

    public void messageLineReceived(String line) {
        this.messageStream.println("  " + line);
    }

    public void errorLineReceived(String line) {
        this.errorStream.println("  " + line);
    }

    public void commandCompleted(IStatus status, Exception exception) {
        String time;
        long commandRuntime = System.currentTimeMillis() - this.commandStarted;
        try {
            time = TIME_FORMAT.format(new Date(commandRuntime));
        }
        catch (RuntimeException e) {
            CVSUIPlugin.log(4, Policy.bind("Console.couldNotFormatTime"), e);
            time = "";
        }
        if (status != null) {
            String statusText = status.getCode() == -10 ? Policy.bind("Console.resultServerError", status.getMessage(), time) : Policy.bind("Console.resultOk", time);
            this.commandStream.println(statusText);
            IStatus[] children = status.getChildren();
            if (children.length == 0) {
                if (!status.isOK()) {
                    this.commandStream.println(this.messageLineForStatus(status));
                }
            } else {
                int i = 0;
                while (i < children.length) {
                    if (!children[i].isOK()) {
                        this.commandStream.println(this.messageLineForStatus(children[i]));
                    }
                    ++i;
                }
            }
        } else if (exception != null) {
            String statusText = exception instanceof OperationCanceledException ? Policy.bind("Console.resultAborted", time) : Policy.bind("Console.resultException", time);
            this.commandStream.println(statusText);
        } else {
            String statusText = Policy.bind("Console.resultOk", time);
        }
        this.commandStream.println(Policy.bind("Console.postExecutionDelimiter"));
        this.commandStream.println("");
    }

    private String messageLineForStatus(IStatus status) {
        if (status.getSeverity() == 4) {
            return Policy.bind("Console.error", status.getMessage());
        }
        if (status.getSeverity() == 2) {
            return Policy.bind("Console.warning", status.getMessage());
        }
        if (status.getSeverity() == 1) {
            return Policy.bind("Console.info", status.getMessage());
        }
        return status.getMessage();
    }

    private Color createColor(Display display, String preference) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)preference);
        return new Color((Device)display, rgb);
    }

    private IPreferenceStore getPreferenceStore() {
        return CVSUIPlugin.getPlugin().getPreferenceStore();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("pref_console_command_color")) {
            Color newColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_command_color");
            this.commandStream.setColor(newColor);
            this.commandColor.dispose();
            this.commandColor = newColor;
        } else if (property.equals("pref_console_message_color")) {
            Color newColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_message_color");
            this.messageStream.setColor(newColor);
            this.messageColor.dispose();
            this.messageColor = newColor;
        } else if (property.equals("pref_console_error_color")) {
            Color newColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_error_color");
            this.errorStream.setColor(newColor);
            this.errorColor.dispose();
            this.errorColor = newColor;
        } else if (property.equals("pref_console_font")) {
            this.setFont(JFaceResources.getFont((String)this.getPreferenceStore().getString("pref_console_font")));
        }
    }
}

