/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.MessageDialogWithToggle;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.TagAsVersionDialog;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ccvs.ui.operations.ITagOperation;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;

public abstract class TagAction
extends WorkspaceAction {
    private boolean wasCancelled = false;

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.setWasCancelled(false);
        if (!this.performPrompting()) {
            this.setWasCancelled(true);
            return;
        }
        final ITagOperation[] result = new ITagOperation[1];
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = TagAction.this.configureOperation();
                if (result[0] == null) {
                    return;
                }
            }
        });
        if (result[0] == null) {
            this.setWasCancelled(true);
            return;
        }
        try {
            result[0].run();
        }
        catch (CVSException e1) {
            throw new InvocationTargetException(e1);
        }
    }

    protected boolean performPrompting() {
        return true;
    }

    protected ITagOperation configureOperation() {
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        ITagOperation operation = this.createTagOperation();
        TagAsVersionDialog dialog = new TagAsVersionDialog(this.getShell(), Policy.bind("TagAction.tagResources"), operation);
        if (dialog.open() != 0) {
            return null;
        }
        if (dialog.shouldMoveTag() && store.getBoolean("pref_confirm_move_tag")) {
            MessageDialogWithToggle confirmDialog = MessageDialogWithToggle.openQuestion(this.getShell(), Policy.bind("TagAction.moveTagConfirmTitle"), Policy.bind("TagAction.moveTagConfirmMessage", dialog.getTagName()), null, false);
            if (confirmDialog.getReturnCode() == 0) {
                store.setValue("pref_confirm_move_tag", !confirmDialog.getToggleState());
            } else {
                return null;
            }
        }
        return dialog.getOperation();
    }

    protected abstract ITagOperation createTagOperation();

    protected String getErrorTitle() {
        return Policy.bind("TagAction.tagErrorTitle");
    }

    protected String getWarningTitle() {
        return Policy.bind("TagAction.tagWarningTitle");
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public void setWasCancelled(boolean b) {
        this.wasCancelled = b;
    }

    public static void broadcastTagChange(final ICVSResource[] resources, final CVSTag tag) throws InvocationTargetException, InterruptedException {
        final RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
        manager.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    int i = 0;
                    while (i < resources.length) {
                        ICVSResource resource = resources[i];
                        manager.addTags(this.getRootParent(resource), new CVSTag[]{tag});
                        ++i;
                    }
                }
                catch (CVSException e) {
                    CVSUIPlugin.log((CoreException)((Object)e));
                }
            }

            private ICVSResource getRootParent(ICVSResource resource) throws CVSException {
                if (!resource.isManaged()) {
                    return resource;
                }
                ICVSFolder parent = resource.getParent();
                if (parent == null) {
                    return resource;
                }
                if (parent.getName().length() == 0) {
                    return resource;
                }
                return this.getRootParent((ICVSResource)parent);
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }
}

