/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.RemoteFileEditorInput;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class OpenRemoteFileAction
extends CVSAction {
    static /* synthetic */ Class class$0;

    protected ICVSRemoteFile[] getSelectedRemoteFiles() {
        ArrayList<Object> resources = null;
        if (!this.selection.isEmpty()) {
            resources = new ArrayList<Object>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object adapter;
                Object next = elements.next();
                if (next instanceof ICVSRemoteFile) {
                    resources.add(next);
                    continue;
                }
                if (next instanceof ILogEntry) {
                    resources.add(((ILogEntry)next).getRemoteFile());
                    continue;
                }
                if (!(next instanceof IAdaptable)) continue;
                IAdaptable a = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("[Lorg.eclipse.team.internal.ccvs.core.ICVSRemoteFile;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((adapter = a.getAdapter((Class)clazz)) instanceof ICVSRemoteFile)) continue;
                resources.add(adapter);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            ICVSRemoteFile[] result = new ICVSRemoteFile[resources.size()];
            resources.toArray(result);
            return result;
        }
        return new ICVSRemoteFile[0];
    }

    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                IWorkbench workbench = CVSUIPlugin.getPlugin().getWorkbench();
                IEditorRegistry registry = workbench.getEditorRegistry();
                IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                ICVSRemoteFile[] files = OpenRemoteFileAction.this.getSelectedRemoteFiles();
                int i = 0;
                while (i < files.length) {
                    ICVSRemoteFile file = files[i];
                    String filename = file.getName();
                    IEditorDescriptor descriptor = registry.getDefaultEditor(filename);
                    String id = descriptor == null ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
                    try {
                        try {
                            page.openEditor((IEditorInput)new RemoteFileEditorInput(files[i]), id);
                        }
                        catch (PartInitException e) {
                            if (id.equals("org.eclipse.ui.DefaultTextEditor")) {
                                throw e;
                            }
                            page.openEditor((IEditorInput)new RemoteFileEditorInput(files[i]), "org.eclipse.ui.DefaultTextEditor");
                        }
                    }
                    catch (PartInitException e) {
                        throw new InvocationTargetException(e);
                    }
                    ++i;
                }
            }
        }, false, 2);
    }

    protected boolean isEnabled() throws TeamException {
        ICVSRemoteFile[] resources = this.getSelectedRemoteFiles();
        return resources.length != 0;
    }
}

