/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.IgnoreResourcesDialog;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class IgnoreAction
extends WorkspaceAction {
    protected void execute(final IAction action) throws InvocationTargetException, InterruptedException {
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                IResource[] resources = IgnoreAction.this.getSelectedResources();
                IgnoreResourcesDialog dialog = new IgnoreResourcesDialog(IgnoreAction.this.getShell(), resources);
                if (dialog.open() != 0) {
                    return;
                }
                try {
                    int i = 0;
                    while (i < resources.length) {
                        IResource resource = resources[i];
                        String pattern = dialog.getIgnorePatternFor(resource);
                        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                        cvsResource.setIgnoredAs(pattern);
                        ++i;
                    }
                    if (action != null) {
                        action.setEnabled(IgnoreAction.this.isEnabled());
                    }
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, false, 2);
    }

    protected String getErrorTitle() {
        return Policy.bind("IgnoreAction.ignore");
    }

    protected boolean isEnabledForManagedResources() {
        return false;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }
}

