/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSLocalCompareEditorInput;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.ui.IWorkbenchPage;

public class CompareWithRemoteAction
extends WorkspaceAction {
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        final IResource[] resources = this.getSelectedResources();
        final CVSTag[] tags = new CVSTag[resources.length];
        try {
            int i = 0;
            while (i < resources.length) {
                tags[i] = this.getTag(resources[i]);
                ++i;
            }
        }
        catch (CVSException e) {
            throw new InvocationTargetException(e);
        }
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                CompareUI.openCompareEditorOnPage((CompareEditorInput)new CVSLocalCompareEditorInput(resources, tags), (IWorkbenchPage)CompareWithRemoteAction.this.getTargetPage());
            }
        }, false, 2);
    }

    protected CVSTag getTag(IResource resource) throws CVSException {
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
        return this.getTag(cvsResource);
    }

    protected CVSTag getTag(ICVSResource cvsResource) throws CVSException {
        CVSTag tag = null;
        if (cvsResource.isFolder()) {
            FolderSyncInfo folderInfo = ((ICVSFolder)cvsResource).getFolderSyncInfo();
            if (folderInfo != null && (tag = folderInfo.getTag()) == null) {
                tag = CVSTag.DEFAULT;
            }
        } else {
            ResourceSyncInfo info = cvsResource.getSyncInfo();
            if (info != null) {
                tag = info.getTag();
            }
        }
        if (tag == null && cvsResource.getParent().isCVSFolder() && (tag = cvsResource.getParent().getFolderSyncInfo().getTag()) == null) {
            tag = CVSTag.DEFAULT;
        }
        return tag;
    }

    protected String getErrorTitle() {
        return Policy.bind("CompareWithRemoteAction.compare");
    }

    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        if (super.isEnabledForCVSResource(cvsResource)) {
            String tag;
            String revision;
            ResourceSyncInfo info;
            return cvsResource.isFolder() || (info = cvsResource.getSyncInfo()) == null || info.getTag() == null || !(revision = info.getRevision()).equals(tag = info.getTag().getName());
        }
        return this.getTag(cvsResource) != null;
    }

    protected void setActionEnablement(IAction action) {
        super.setActionEnablement(action);
        action.setText(this.calculateActionTagValue());
    }

    protected boolean isEnabledForNonExistantResources() {
        return true;
    }
}

