/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.ui.TagSelectionDialog;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteCompareOperation;

public class CompareRemoteWithTagAction
extends CVSAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        ICVSRemoteResource[] resources = this.getSelectedRemoteResources();
        if (resources.length == 0) {
            return;
        }
        final ICVSRemoteResource resource = resources[0];
        final CVSTag[] tag = new CVSTag[1];
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                ICVSFolder folder = resource instanceof ICVSRemoteFolder ? (ICVSFolder)resource : resource.getParent();
                tag[0] = TagSelectionDialog.getTagToCompareWith(CompareRemoteWithTagAction.this.getShell(), new ICVSFolder[]{folder});
            }
        }, false, 2);
        if (tag[0] == null) {
            return;
        }
        try {
            new RemoteCompareOperation(null, resource, tag[0]).run();
        }
        catch (CVSException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected boolean isEnabled() {
        ICVSRemoteResource[] resources = this.getSelectedRemoteResources();
        return resources.length == 1;
    }
}

