/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.AddToWorkspaceAction;
import org.eclipse.team.internal.ccvs.ui.operations.HasProjectMetaFileOperation;
import org.eclipse.team.internal.ccvs.ui.wizards.CheckoutAsWizard;

public class CheckoutAsAction
extends AddToWorkspaceAction {
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        ICVSRemoteFolder[] folders = this.getSelectedRemoteFolders();
        try {
            CheckoutAsWizard wizard = new CheckoutAsWizard(folders, this.allowProjectConfiguration(folders));
            WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
            dialog.open();
        }
        catch (CVSException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected boolean allowProjectConfiguration(ICVSRemoteFolder[] folders) throws CVSException, InterruptedException {
        if (folders.length != 1) {
            return false;
        }
        return !HasProjectMetaFileOperation.hasMetaFile(this.getShell(), folders[0]);
    }

    protected boolean isEnabled() throws TeamException {
        return this.getSelectedRemoteFolders().length > 0;
    }

    protected String getErrorTitle() {
        return Policy.bind("CheckoutAsAction.checkoutFailed");
    }
}

