/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.AvoidableMessageDialog;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.team.internal.ui.dialogs.IPromptCondition;
import org.eclipse.team.internal.ui.synchronize.views.SynchronizeViewNode;
import org.eclipse.ui.PlatformUI;

public abstract class CVSAction
extends TeamAction {
    private List accumulatedStatus = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public final void run(IAction action) {
        try {
            if (!this.beginExecution(action)) {
                return;
            }
            this.execute(action);
            this.endExecution();
        }
        catch (InvocationTargetException e) {
            this.handle(e);
        }
        catch (InterruptedException interruptedException) {
            this.handle(null);
        }
        catch (TeamException e) {
            this.handle((Exception)((Object)e));
        }
    }

    protected boolean beginExecution(IAction action) throws TeamException {
        this.accumulatedStatus.clear();
        return !this.needsToSaveDirtyEditors() || this.saveAllEditors();
    }

    protected abstract void execute(IAction var1) throws InvocationTargetException, InterruptedException;

    protected void endExecution() throws TeamException {
        if (!this.accumulatedStatus.isEmpty()) {
            this.handle(null);
        }
    }

    protected void addStatus(IStatus status) {
        this.accumulatedStatus.add(status);
    }

    protected IStatus[] getAccumulatedStatus() {
        return this.accumulatedStatus.toArray(new IStatus[this.accumulatedStatus.size()]);
    }

    protected String getErrorTitle() {
        return Policy.bind("CVSAction.errorTitle");
    }

    protected String getWarningTitle() {
        return Policy.bind("CVSAction.warningTitle");
    }

    protected String getMultiStatusMessage() {
        return Policy.bind("CVSAction.multipleProblemsMessage");
    }

    protected IStatus getStatusToDisplay(IStatus[] problems) {
        if (problems.length == 1) {
            return problems[0];
        }
        MultiStatus combinedStatus = new MultiStatus("org.eclipse.team.cvs.ui", 0, this.getMultiStatusMessage(), null);
        int i = 0;
        while (i < problems.length) {
            combinedStatus.merge(problems[i]);
            ++i;
        }
        return combinedStatus;
    }

    protected void handle(Exception exception) {
        ArrayList<IStatus> problems = new ArrayList<IStatus>();
        IStatus[] status = this.getAccumulatedStatus();
        if (status != null) {
            int i = 0;
            while (i < status.length) {
                IStatus iStatus = status[i];
                if (!iStatus.isOK() || iStatus.getCode() == -10) {
                    problems.add(iStatus);
                }
                ++i;
            }
        }
        if (problems.size() == 0) {
            if (exception == null) {
                return;
            }
            this.handle(exception, this.getErrorTitle(), null);
            return;
        }
        if (exception != null) {
            this.handle(exception, this.getErrorTitle(), null);
        }
        String message = null;
        IStatus statusToDisplay = this.getStatusToDisplay(problems.toArray(new IStatus[problems.size()]));
        if (statusToDisplay.isOK()) {
            return;
        }
        if (statusToDisplay.isMultiStatus() && statusToDisplay.getChildren().length == 1) {
            message = statusToDisplay.getMessage();
            statusToDisplay = statusToDisplay.getChildren()[0];
        }
        String title = statusToDisplay.getSeverity() == 4 ? this.getErrorTitle() : this.getWarningTitle();
        CVSUIPlugin.openError(this.getShell(), title, message, new CVSException(statusToDisplay));
    }

    protected final void run(final IRunnableWithProgress runnable, boolean cancelable, int progressKind) throws InvocationTargetException, InterruptedException {
        final Exception[] exceptions = new Exception[1];
        final IRunnableWithProgress innerRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                CVSAction.this.getRepositoryManager().run(runnable, monitor);
            }
        };
        switch (progressKind) {
            case 3: {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, runnable);
                }
                catch (InterruptedException e1) {
                    exceptions[0] = null;
                    e1.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    exceptions[0] = e;
                }
                break;
            }
            case 2: {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            innerRunnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (InvocationTargetException e) {
                            exceptions[0] = e;
                        }
                        catch (InterruptedException e) {
                            exceptions[0] = e;
                        }
                    }
                });
                break;
            }
            default: {
                new ProgressMonitorDialog(this.getShell()).run(cancelable, true, innerRunnable);
            }
        }
        if (exceptions[0] != null) {
            if (exceptions[0] instanceof InvocationTargetException) {
                throw (InvocationTargetException)exceptions[0];
            }
            throw (InterruptedException)exceptions[0];
        }
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    protected ICVSResource[] getSelectedCVSResources() {
        ArrayList<Object> resources = null;
        if (!this.selection.isEmpty()) {
            resources = new ArrayList<Object>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object adapter;
                Object next = elements.next();
                if (next instanceof ICVSResource) {
                    resources.add(next);
                    continue;
                }
                if (!(next instanceof IAdaptable)) continue;
                IAdaptable a = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("[Lorg.eclipse.team.internal.ccvs.core.ICVSResource;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((adapter = a.getAdapter((Class)clazz)) instanceof ICVSResource)) continue;
                resources.add(adapter);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            return resources.toArray(new ICVSResource[resources.size()]);
        }
        return new ICVSResource[0];
    }

    protected ICVSRemoteFolder[] getSelectedRemoteFolders() {
        ArrayList<Object> resources = null;
        if (!this.selection.isEmpty()) {
            resources = new ArrayList<Object>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object adapter;
                Object next = elements.next();
                if (next instanceof ICVSRemoteFolder) {
                    resources.add(next);
                    continue;
                }
                if (!(next instanceof IAdaptable)) continue;
                IAdaptable a = (IAdaptable)next;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("[Lorg.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((adapter = a.getAdapter((Class)clazz)) instanceof ICVSRemoteFolder)) continue;
                resources.add(adapter);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            return resources.toArray(new ICVSRemoteFolder[resources.size()]);
        }
        return new ICVSRemoteFolder[0];
    }

    protected ICVSRemoteResource[] getSelectedRemoteResources() {
        ArrayList<Object> resources = null;
        if (!this.selection.isEmpty()) {
            resources = new ArrayList<Object>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object adapter;
                Object next = elements.next();
                if (next instanceof ICVSRemoteResource) {
                    resources.add(next);
                    continue;
                }
                if (next instanceof ILogEntry) {
                    resources.add(((ILogEntry)next).getRemoteFile());
                    continue;
                }
                if (!(next instanceof IAdaptable)) continue;
                IAdaptable a = (IAdaptable)next;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("[Lorg.eclipse.team.internal.ccvs.core.ICVSRemoteResource;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((adapter = a.getAdapter((Class)clazz)) instanceof ICVSRemoteResource)) continue;
                resources.add(adapter);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            ICVSRemoteResource[] result = new ICVSRemoteResource[resources.size()];
            resources.toArray(result);
            return result;
        }
        return new ICVSRemoteResource[0];
    }

    public static IPromptCondition getOverwriteLocalChangesPrompt(IResource[] dirtyResources) {
        return new IPromptCondition(dirtyResources){
            List resources;
            {
                this.resources = Arrays.asList(iResourceArray);
            }

            public boolean needsPrompt(IResource resource) {
                return this.resources.contains(resource);
            }

            public String promptMessage(IResource resource) {
                return Policy.bind("ReplaceWithAction.localChanges", resource.getName());
            }
        };
    }

    public static boolean checkForMixingTags(final Shell shell, IResource[] resources, final CVSTag tag) throws CVSException {
        final IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        if (!store.getBoolean("pref_prompt_on_mixed_tags")) {
            return true;
        }
        final boolean[] result = new boolean[]{true};
        int i = 0;
        while (i < resources.length) {
            ICVSResource cvsResource;
            CVSEntryLineTag parentTag;
            IResource resource = resources[i];
            if (resource.getType() != 4 && !CVSTag.equalTags((CVSTag)tag, (CVSTag)(parentTag = (cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource)).getParent().getFolderSyncInfo().getTag())) && !CVSTag.equalTags((CVSTag)tag, (CVSTag)CVSTag.BASE)) {
                shell.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        AvoidableMessageDialog dialog = new AvoidableMessageDialog(shell, Policy.bind("CVSAction.mixingTagsTitle"), null, Policy.bind("CVSAction.mixingTags", tag.getName()), 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                        boolean bl = result[0] = dialog.open() == 0;
                        if (result[0] && dialog.isDontShowAgain()) {
                            store.setValue("pref_prompt_on_mixed_tags", false);
                        }
                    }
                });
                break;
            }
            ++i;
        }
        return result[0];
    }

    private boolean saveAllEditors() {
        final int option = CVSUIPlugin.getPlugin().getPreferenceStore().getInt("pref_save_dirty_editors");
        final boolean[] okToContinue = new boolean[]{true};
        if (option != 1) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    boolean confirm = option == 2;
                    okToContinue[0] = PlatformUI.getWorkbench().saveAllEditors(confirm);
                }
            });
        }
        return okToContinue[0];
    }

    protected void handle(Exception exception, String title, String message) {
        CVSUIPlugin.openError(this.getShell(), title, message, exception, 12);
    }

    protected RepositoryManager getRepositoryManager() {
        return CVSUIPlugin.getPlugin().getRepositoryManager();
    }

    protected IResource[] getSelectedResources() {
        if (this.selection.isEmpty()) {
            return new IResource[0];
        }
        Iterator it = this.selection.iterator();
        ArrayList<Object> resources = new ArrayList<Object>();
        while (it.hasNext()) {
            Object adapter;
            Object element = it.next();
            if (element instanceof SynchronizeViewNode) {
                resources.add(((SynchronizeViewNode)element).getResource());
                continue;
            }
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!((adapter = TeamAction.getAdapter(element, (Class)clazz)) instanceof IResource)) continue;
            resources.add(adapter);
        }
        return resources.toArray(new IResource[resources.size()]);
    }
}

