/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.BranchPromptDialog;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class BranchAction
extends WorkspaceAction {
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        final IResource[] resources = this.getSelectedResources();
        boolean allSticky = this.areAllResourcesSticky(resources);
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)resources[0].getProject());
        BranchPromptDialog dialog = new BranchPromptDialog(this.getShell(), Policy.bind("BranchWizard.title"), folder, allSticky, this.calculateInitialVersionName(resources, allSticky));
        if (dialog.open() != 0) {
            return;
        }
        String tagString = dialog.getBranchTagName();
        final boolean update = dialog.getUpdate();
        String versionString = dialog.getVersionTagName();
        final CVSTag rootVersionTag = versionString == null ? null : new CVSTag(versionString, 2);
        final CVSTag branchTag = new CVSTag(tagString, 1);
        if (update) {
            try {
                if (!CVSAction.checkForMixingTags(this.getShell(), resources, branchTag)) {
                    return;
                }
            }
            catch (CVSException e) {
                throw new InvocationTargetException(e);
            }
        }
        final RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                Hashtable table = BranchAction.this.getProviderMapping(resources);
                Set keySet = table.keySet();
                monitor.beginTask(null, keySet.size() * 1000);
                Iterator iterator = keySet.iterator();
                while (iterator.hasNext()) {
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
                    CVSTeamProvider provider = (CVSTeamProvider)iterator.next();
                    List list = (List)table.get(provider);
                    IResource[] providerResources = list.toArray(new IResource[list.size()]);
                    try {
                        provider.getCVSWorkspaceRoot().getRemoteLocation();
                        if (!BranchAction.this.areAllResourcesSticky(resources)) {
                            provider.makeBranch(providerResources, rootVersionTag, branchTag, update, (IProgressMonitor)subMonitor);
                        } else {
                            provider.makeBranch(providerResources, null, branchTag, update, (IProgressMonitor)subMonitor);
                        }
                        if (rootVersionTag == null && !update) continue;
                        int i = 0;
                        while (i < providerResources.length) {
                            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)providerResources[i]);
                            if (rootVersionTag != null) {
                                manager.addTags(cvsResource, new CVSTag[]{rootVersionTag});
                            }
                            if (update) {
                                manager.addTags(cvsResource, new CVSTag[]{branchTag});
                            }
                            ++i;
                        }
                    }
                    catch (TeamException e) {
                        BranchAction.this.addStatus(e.getStatus());
                    }
                }
            }
        }, true, 1);
    }

    private boolean areAllResourcesSticky(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (!this.hasStickyTag(resources[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean hasStickyTag(IResource resource) {
        try {
            int tagType;
            CVSTag tag;
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
            if (cvsResource.isFolder()) {
                FolderSyncInfo folderInfo = ((ICVSFolder)cvsResource).getFolderSyncInfo();
                tag = folderInfo.getTag();
            } else {
                ResourceSyncInfo info = cvsResource.getSyncInfo();
                tag = info.getTag();
            }
            if (tag != null && (tagType = tag.getType()) == 2) {
                return true;
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)e);
            return false;
        }
        return false;
    }

    private String calculateInitialVersionName(IResource[] resources, boolean allSticky) {
        String versionName = "";
        try {
            if (allSticky) {
                IResource stickyResource = resources[0];
                if (stickyResource.getType() == 1) {
                    ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)stickyResource));
                    versionName = cvsFile.getSyncInfo().getTag().getName();
                } else {
                    ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)((IContainer)stickyResource));
                    versionName = cvsFolder.getFolderSyncInfo().getTag().getName();
                }
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)e);
            versionName = "";
        }
        return versionName;
    }

    protected String getErrorTitle() {
        return Policy.bind("BranchWizard.errorBranching");
    }
}

