/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.ui.help.WorkbenchHelp;

public class UserValidationDialog
extends Dialog {
    protected Text usernameField;
    protected Text passwordField;
    protected String domain;
    protected String defaultUsername;
    protected String password = null;
    protected boolean isUsernameMutable = true;
    protected String username = null;
    protected String message = null;

    public UserValidationDialog(Shell parentShell, String location, String defaultName, String message) {
        super(parentShell);
        this.defaultUsername = defaultName;
        this.domain = location;
        this.message = message;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Policy.bind("UserValidationDialog.required"));
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.team.cvs.ui.user_validation_dialog_context");
    }

    public void create() {
        super.create();
        this.usernameField.setText(this.defaultUsername);
        if (this.isUsernameMutable) {
            this.usernameField.selectAll();
            this.usernameField.setFocus();
        } else {
            this.usernameField.setEditable(false);
            this.passwordField.setFocus();
        }
    }

    protected Control createDialogArea(Composite parent) {
        GridData data;
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(768));
        if (this.message != null) {
            Label messageLabel = new Label(main, 64);
            messageLabel.setText(this.message);
            messageLabel.setForeground(messageLabel.getDisplay().getSystemColor(3));
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.widthHint = 400;
            messageLabel.setLayoutData((Object)data);
        }
        Label label = new Label(main, 64);
        if (this.isUsernameMutable) {
            label.setText(Policy.bind("UserValidationDialog.labelUser", this.domain));
        } else {
            label.setText(Policy.bind("UserValidationDialog.labelPassword", new Object[]{this.defaultUsername, this.domain}));
        }
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = 400;
        label.setLayoutData((Object)data);
        this.createUsernameFields(main);
        this.createPasswordFields(main);
        Dialog.applyDialogFont((Control)parent);
        return main;
    }

    protected void createPasswordFields(Composite parent) {
        new Label(parent, 0).setText(Policy.bind("UserValidationDialog.password"));
        this.passwordField = new Text(parent, 0x400800);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.passwordField.setLayoutData((Object)data);
    }

    protected void createUsernameFields(Composite parent) {
        new Label(parent, 0).setText(Policy.bind("UserValidationDialog.user"));
        this.usernameField = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.usernameField.setLayoutData((Object)data);
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    protected void okPressed() {
        this.password = this.passwordField.getText();
        this.username = this.usernameField.getText();
        super.okPressed();
    }

    public void setUsernameMutable(boolean value) {
        this.isUsernameMutable = value;
    }
}

