/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ITeamResourceChangeListener;
import org.eclipse.team.core.subscribers.SyncInfo;
import org.eclipse.team.core.subscribers.TeamDelta;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffProviderImplementation;

public class RemoteRevisionQuickDiffProvider
implements IQuickDiffProviderImplementation {
    private ITextEditor fEditor = null;
    private IDocument fReference = null;
    private boolean fReferenceInitialized = false;
    private IDocumentProvider fDocumentProvider = null;
    private String fId;
    private SyncInfo fLastSyncState;
    private Job fUpdateJob;
    private boolean DEBUG = false;
    private ITeamResourceChangeListener teamChangeListener = new ITeamResourceChangeListener(){

        public void teamResourceChanged(TeamDelta[] deltas) {
            if (RemoteRevisionQuickDiffProvider.this.initialized()) {
                int i = 0;
                while (i < deltas.length) {
                    TeamDelta delta = deltas[i];
                    IResource resource = delta.getResource();
                    if (resource.getType() == 1 && RemoteRevisionQuickDiffProvider.this.fLastSyncState != null && resource.equals((Object)RemoteRevisionQuickDiffProvider.this.fLastSyncState.getLocal()) && delta.getFlags() == 1) {
                        RemoteRevisionQuickDiffProvider.this.fetchContentsInJob();
                    }
                    ++i;
                }
            }
        }
    };
    private IElementStateListener documentListener = new IElementStateListener(){

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }

        public void elementContentReplaced(Object element) {
            if (RemoteRevisionQuickDiffProvider.this.fEditor != null && RemoteRevisionQuickDiffProvider.this.fEditor.getEditorInput() == element) {
                RemoteRevisionQuickDiffProvider.this.fetchContentsInJob();
            }
        }

        public void elementDeleted(Object element) {
        }

        public void elementMoved(Object originalElement, Object movedElement) {
        }
    };

    public IDocument getReference(IProgressMonitor monitor) {
        try {
            if (!this.fReferenceInitialized) {
                this.readDocument(monitor);
            }
            return this.fReference;
        }
        catch (CoreException e) {
            CVSUIPlugin.log(e);
            return null;
        }
    }

    public void setActiveEditor(ITextEditor targetEditor) {
        if (targetEditor != this.fEditor) {
            this.dispose();
            this.fEditor = targetEditor;
        }
    }

    public boolean isEnabled() {
        if (!this.initialized()) {
            return false;
        }
        return this.getManagedCVSFile() != null;
    }

    public void dispose() {
        this.fReferenceInitialized = false;
        if (this.fUpdateJob != null && this.fUpdateJob.getState() != 0) {
            this.fUpdateJob.cancel();
            try {
                this.fUpdateJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        RemoteRevisionQuickDiffProvider remoteRevisionQuickDiffProvider = this;
        synchronized (remoteRevisionQuickDiffProvider) {
            if (this.fDocumentProvider != null) {
                this.fDocumentProvider.removeElementStateListener(this.documentListener);
            }
            CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().removeListener(this.teamChangeListener);
            this.fReferenceInitialized = false;
            this.fReference = null;
            this.fUpdateJob = null;
            this.fLastSyncState = null;
        }
    }

    public void setId(String id) {
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    private boolean computeChange(IProgressMonitor monitor) throws TeamException {
        boolean needToUpdateReferenceDocument = false;
        if (this.initialized()) {
            SyncInfo info = this.getSyncState((IResource)this.getFileFromEditor(), monitor);
            if (info == null && this.fLastSyncState != null) {
                return true;
            }
            info.getKind();
            if (this.fLastSyncState == null) {
                needToUpdateReferenceDocument = true;
            } else if (!this.fLastSyncState.equals((Object)info)) {
                needToUpdateReferenceDocument = true;
            }
            if (this.DEBUG) {
                this.debug(this.fLastSyncState, info);
            }
            this.fLastSyncState = info;
        }
        return needToUpdateReferenceDocument;
    }

    private void debug(SyncInfo lastSyncState, SyncInfo info) {
        String last = "[none]";
        if (lastSyncState != null) {
            last = lastSyncState.toString();
        }
        System.out.println("+ CVSQuickDiff: was " + last + " is " + info.toString());
    }

    private SyncInfo getSyncState(IResource resource, IProgressMonitor monitor) throws TeamException {
        this.getManagedCVSFile();
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().getSyncInfo(resource, monitor);
    }

    private boolean initialized() {
        return this.fEditor != null && this.fEditor.getEditorInput() instanceof IFileEditorInput;
    }

    private synchronized void readDocument(IProgressMonitor monitor) throws CoreException {
        if (!this.initialized()) {
            return;
        }
        this.fReferenceInitialized = false;
        this.fDocumentProvider = this.fEditor.getDocumentProvider();
        if (this.fReference == null) {
            this.fReference = new Document();
        }
        if (this.computeChange(monitor)) {
            ICVSRemoteFile remoteFile = (ICVSRemoteFile)this.fLastSyncState.getRemote();
            if (this.fLastSyncState.getRemote() != null && this.fDocumentProvider instanceof IStorageDocumentProvider) {
                InputStream stream;
                IStorageDocumentProvider provider = (IStorageDocumentProvider)this.fDocumentProvider;
                String encoding = provider.getEncoding((Object)this.fEditor.getEditorInput());
                if (encoding == null) {
                    encoding = provider.getDefaultEncoding();
                }
                if ((stream = remoteFile.getContents(monitor)) == null) {
                    return;
                }
                if (!monitor.isCanceled()) {
                    RemoteRevisionQuickDiffProvider.setDocumentContent(this.fReference, stream, encoding);
                }
            } else {
                this.fReference = new Document();
                this.fReference.set("");
            }
        }
        if (this.fDocumentProvider != null) {
            CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().addListener(this.teamChangeListener);
            this.fDocumentProvider.addElementStateListener(this.documentListener);
        }
        this.fReferenceInitialized = true;
    }

    /*
     * Exception decompiling
     */
    private static void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 148->152)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ICVSFile getManagedCVSFile() {
        if (this.fEditor != null) {
            IFile file = this.getFileFromEditor();
            try {
                if (file != null && CVSWorkspaceRoot.isSharedWithCVS((IResource)file)) {
                    return CVSWorkspaceRoot.getCVSFileFor((IFile)file);
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        return null;
    }

    private IFile getFileFromEditor() {
        IEditorInput input;
        if (this.fEditor != null && (input = this.fEditor.getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    private void fetchContentsInJob() {
        if (this.fUpdateJob != null && this.fUpdateJob.getState() != 0) {
            this.fUpdateJob.cancel();
            try {
                this.fUpdateJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        Job updateJob = new Job(Policy.bind("RemoteRevisionQuickDiffProvider.fetchingFile")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    RemoteRevisionQuickDiffProvider.this.readDocument(monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        updateJob.schedule();
    }
}

