/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;

public class RemoteFileStorage
extends PlatformObject
implements IStorage {
    ICVSRemoteFile file;

    public RemoteFileStorage(ICVSRemoteFile file) {
        this.file = file;
    }

    public InputStream getContents() throws CoreException {
        block3: {
            try {
                final InputStream[] holder = new InputStream[1];
                CVSUIPlugin.runWithProgress(null, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            holder[0] = RemoteFileStorage.this.file.getContents(monitor);
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
                return holder[0];
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (!(t instanceof TeamException)) break block3;
                throw new CoreException(((TeamException)t).getStatus());
            }
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    public IPath getFullPath() {
        ICVSRepositoryLocation location = this.file.getRepository();
        Path path = new Path(location.getRootDirectory());
        path = path.setDevice(String.valueOf(location.getHost()) + ':');
        path = path.append(this.file.getRepositoryRelativePath());
        return path;
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean isReadOnly() {
        return true;
    }
}

