/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.RemoteFileStorage;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class RemoteFileEditorInput
implements IWorkbenchAdapter,
IStorageEditorInput {
    ICVSRemoteFile file;
    IStorage storage;
    static /* synthetic */ Class class$0;

    public RemoteFileEditorInput(ICVSRemoteFile file) {
        this.file = file;
    }

    public boolean exists() {
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RemoteFileEditorInput)) {
            return false;
        }
        RemoteFileEditorInput input = (RemoteFileEditorInput)o;
        return this.file.equals((Object)input.file);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.model.IWorkbenchAdapter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return null;
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public String getContentType() {
        String name = this.file.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public String getFullPath() {
        String fullPath;
        ICVSRepositoryLocation location = this.file.getRepository();
        Path path = new Path(location.getRootDirectory());
        path = path.setDevice(String.valueOf(location.getHost()) + ':');
        path = path.append(this.file.getRepositoryRelativePath());
        try {
            String revision = this.file.getRevision();
            fullPath = Policy.bind("RemoteFileEditorInput.fullPathAndRevision", path.toString(), revision);
        }
        catch (TeamException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            fullPath = path.toString();
        }
        return fullPath;
    }

    public ImageDescriptor getImageDescriptor() {
        IWorkbenchAdapter fileAdapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.model.IWorkbenchAdapter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (fileAdapter = (IWorkbenchAdapter)this.file.getAdapter((Class)clazz)) == null ? null : fileAdapter.getImageDescriptor((Object)this.file);
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        IWorkbenchAdapter fileAdapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.model.IWorkbenchAdapter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (fileAdapter = (IWorkbenchAdapter)this.file.getAdapter((Class)clazz)) == null ? null : fileAdapter.getImageDescriptor((Object)this.file);
    }

    public String getLabel(Object o) {
        return this.file.getName();
    }

    public String getName() {
        String name = this.file.getName();
        try {
            return Policy.bind("nameAndRevision", name, this.file.getRevision());
        }
        catch (TeamException teamException) {
            return name;
        }
    }

    public Object getParent(Object o) {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() throws CoreException {
        if (this.storage == null) {
            this.storage = new RemoteFileStorage(this.file);
        }
        return this.storage;
    }

    public String getToolTipText() {
        return this.getFullPath();
    }

    public ICVSRemoteFile getCVSRemoteFile() {
        return this.file;
    }
}

