/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchMessages;

public class MessageDialogWithToggle
extends MessageDialog {
    private String toggleMessage = null;
    private boolean toggleState = false;
    private Button toggleButton = null;
    IPreferenceStore fStore = null;

    public MessageDialogWithToggle(Shell parentShell, String dialogTitle, Image image, String message, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String toggleMessage, boolean toggleState) {
        super(parentShell, dialogTitle, image, message, dialogImageType, dialogButtonLabels, defaultIndex);
        this.toggleMessage = toggleMessage;
        this.toggleState = toggleState;
    }

    public boolean getToggleState() {
        return this.toggleState;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.toggleButton = this.createToggleButton(dialogArea);
        return dialogArea;
    }

    protected Button createToggleButton(Composite parent) {
        final Button button = new Button(parent, 16416);
        String text = this.toggleMessage;
        if (text == null) {
            text = WorkbenchMessages.getString((String)"MessageDialogWithToggle.defaultToggleMessage");
        }
        button.setText(text);
        button.setSelection(this.toggleState);
        GridData data = new GridData(0);
        data.horizontalSpan = 2;
        data.horizontalAlignment = 2;
        button.setLayoutData((Object)data);
        button.setFont(parent.getFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageDialogWithToggle.this.toggleState = button.getSelection();
            }
        });
        return button;
    }

    protected Button getToggleButton() {
        return this.toggleButton;
    }

    public static MessageDialogWithToggle openConfirm(Shell parent, String title, String message, String toggleMessage, boolean toggleState) {
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(parent, title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0, toggleMessage, toggleState);
        dialog.open();
        return dialog;
    }

    public static MessageDialogWithToggle openError(Shell parent, String title, String message, String toggleMessage, boolean toggleState) {
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(parent, title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0, toggleMessage, toggleState);
        dialog.open();
        return dialog;
    }

    public static MessageDialogWithToggle openInformation(Shell parent, String title, String message, String toggleMessage, boolean toggleState) {
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(parent, title, null, message, 2, new String[]{IDialogConstants.OK_LABEL}, 0, toggleMessage, toggleState);
        dialog.open();
        return dialog;
    }

    public static MessageDialogWithToggle openQuestion(Shell parent, String title, String message, String toggleMessage, boolean toggleState) {
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(parent, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1, toggleMessage, toggleState);
        dialog.open();
        return dialog;
    }

    public static MessageDialogWithToggle openWarning(Shell parent, String title, String message, String toggleMessage, boolean toggleState) {
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(parent, title, null, message, 4, new String[]{IDialogConstants.OK_LABEL}, 0, toggleMessage, toggleState);
        dialog.open();
        return dialog;
    }
}

