/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.team.internal.ccvs.ui.HistoryView;
import org.eclipse.ui.part.ResourceTransfer;

public class HistoryDropAdapter
extends ViewerDropAdapter {
    HistoryView view;

    public HistoryDropAdapter(StructuredViewer viewer, HistoryView view) {
        super((Viewer)viewer);
        this.view = view;
    }

    public void dragOver(DropTargetEvent event) {
        if ((event.operations & 4) == 4) {
            event.detail = 4;
        }
        super.dragOver(event);
    }

    public void drop(DropTargetEvent event) {
        super.drop(event);
        event.detail = 4;
    }

    public boolean performDrop(Object data) {
        if (data == null) {
            return false;
        }
        IResource[] sources = (IResource[])data;
        if (sources.length == 0) {
            return false;
        }
        IResource resource = sources[0];
        if (!(resource instanceof IFile)) {
            return false;
        }
        this.view.showHistory(resource);
        return true;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return transferType != null && ResourceTransfer.getInstance().isSupportedType(transferType);
    }
}

