/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.client.listeners.IConsoleListener;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.ConsoleDocument;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.TextViewerAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class Console
extends ViewPart {
    public static final String CONSOLE_ID = "org.eclipse.team.ccvs.ui.console";
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat(Policy.bind("Console.resultTimeFormat"));
    private static ConsoleDocument document;
    private static List instances;
    private TextViewer viewer;
    private Color commandColor;
    private Color messageColor;
    private Color errorColor;
    private IDocumentListener documentListener;
    private IPropertyChangeListener propertyChangeListener;
    private TextViewerAction copyAction;
    private TextViewerAction selectAllAction;
    private Action clearOutputAction;
    private static final int MAX_BUFFER_SIZE = 200;
    private static Vector pendingConsoleData;
    private static Runnable aSyncRunnable;

    static {
        pendingConsoleData = new Vector(400);
    }

    public static void startup() {
        instances = new ArrayList();
        CVSProviderPlugin.getPlugin().setConsoleListener((IConsoleListener)new ConsoleListener());
    }

    public static void shutdown() {
        document = null;
        instances = null;
        CVSProviderPlugin.getPlugin().setConsoleListener(null);
    }

    public void dispose() {
        if (this.documentListener != null) {
            document.removeDocumentListener(this.documentListener);
            this.documentListener = null;
        }
        if (this.propertyChangeListener != null) {
            Console.getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        instances.remove((Object)this);
        super.dispose();
        if (this.commandColor != null) {
            this.commandColor.dispose();
            this.commandColor = null;
        }
        if (this.messageColor != null) {
            this.messageColor.dispose();
            this.messageColor = null;
        }
        if (this.errorColor != null) {
            this.errorColor.dispose();
            this.errorColor = null;
        }
    }

    public void setFocus() {
        this.viewer.getTextWidget().setFocus();
    }

    public void createPartControl(Composite parent) {
        if (document == null) {
            document = new ConsoleDocument();
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        this.updatePreferences(null);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.cvs.ui.console_view_context");
        this.viewer = new TextViewer(composite, 768);
        GridData data = new GridData(1808);
        this.viewer.getControl().setLayoutData((Object)data);
        this.viewer.setEditable(false);
        this.viewer.setDocument((IDocument)document);
        this.viewer.getTextWidget().setFont(JFaceResources.getFont((String)"pref_console_font"));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Console.this.copyAction.update();
            }
        });
        this.viewer.getTextWidget().addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                StyleRange style = new StyleRange(event.lineOffset, event.lineText.length(), Console.this.getConsoleLineColor(event.lineOffset), null);
                event.styles = new StyleRange[]{style};
            }
        });
        this.createActions();
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Console.this.updatePreferences(event.getProperty());
            }
        };
        Console.getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        JFaceResources.getFontRegistry().addListener(this.propertyChangeListener);
        this.documentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (Console.this.viewer == null) {
                    return;
                }
                StyledText styledText = Console.this.viewer.getTextWidget();
                if (styledText.isDisposed()) {
                    return;
                }
                styledText.setTopIndex(styledText.getLineCount());
            }
        };
        document.addDocumentListener(this.documentListener);
        instances.add(this);
        Console.flushConsoleBuffer();
    }

    private void createActions() {
        CVSUIPlugin plugin = CVSUIPlugin.getPlugin();
        this.clearOutputAction = new Action(Policy.bind("Console.clearOutput"), plugin.getImageDescriptor("elcl16/clear_co.gif")){

            public void run() {
                document.clear();
            }
        };
        this.clearOutputAction.setToolTipText(Policy.bind("Console.clearOutput"));
        this.clearOutputAction.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/clear_co.gif"));
        this.clearOutputAction.setHoverImageDescriptor(plugin.getImageDescriptor("clcl16/clear_co.gif"));
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                Console.this.fillContextMenu(mgr);
            }
        });
        Menu menu = mgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)this.clearOutputAction);
        tbm.update(false);
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.copyAction = new TextViewerAction((ITextViewer)this.viewer, 4);
        this.copyAction.setText(Policy.bind("Console.copy"));
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this.copyAction);
        this.selectAllAction = new TextViewerAction((ITextViewer)this.viewer, 7);
        this.selectAllAction.setText(Policy.bind("Console.selectAll"));
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, (IAction)this.selectAllAction);
        actionBars.updateActionBars();
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.selectAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.clearOutputAction);
    }

    private Color getConsoleLineColor(int offset) {
        switch (document.getLineType(offset)) {
            case 0: 
            case 3: 
            case 4: {
                return this.commandColor;
            }
            case 1: {
                return this.messageColor;
            }
            case 2: {
                return this.errorColor;
            }
        }
        throw new IllegalStateException();
    }

    private void updatePreferences(String property) {
        Display display = this.getViewSite().getShell().getDisplay();
        if (property == null || property.equals("pref_console_command_color") || property.equals("pref_console_message_color") || property.equals("pref_console_error_color")) {
            Color oldCommandColor = this.commandColor;
            Color oldMessageColor = this.messageColor;
            Color oldErrorColor = this.errorColor;
            this.commandColor = this.createColor(display, "pref_console_command_color");
            this.messageColor = this.createColor(display, "pref_console_message_color");
            this.errorColor = this.createColor(display, "pref_console_error_color");
            if (oldCommandColor != null) {
                if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
                    this.viewer.refresh();
                }
                oldCommandColor.dispose();
                oldMessageColor.dispose();
                oldErrorColor.dispose();
            }
        }
        if ((property == null || property.equals("pref_console_font")) && this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getTextWidget().setFont(JFaceResources.getFont((String)"pref_console_font"));
        }
    }

    private Color createColor(Display display, String preference) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)Console.getPreferenceStore(), (String)preference);
        return new Color((Device)display, rgb);
    }

    private static void appendConsoleLine(int type, String line) {
        if (Policy.DEBUG_CONSOLE_BUFFERING) {
            System.out.println("<<Console buffering [" + String.valueOf(type) + "] :" + line);
        }
        pendingConsoleData.add(new PendingConsoleLine(type, line));
        if (document == null) {
            if (pendingConsoleData.size() > 200) {
                pendingConsoleData.remove(0);
            }
            return;
        }
        if (aSyncRunnable != null) {
            return;
        }
        Console.flushConsoleBuffer();
    }

    private static void flushConsoleBuffer() {
        if (document == null) {
            return;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (Policy.DEBUG_CONSOLE_BUFFERING) {
            System.out.println("++Console creating runnable");
        }
        aSyncRunnable = new Runnable(){

            public void run() {
                if (Policy.DEBUG_CONSOLE_BUFFERING) {
                    System.out.println("==Console running runnable");
                }
                while (!pendingConsoleData.isEmpty()) {
                    PendingConsoleLine consoleLine = (PendingConsoleLine)pendingConsoleData.remove(0);
                    if (Policy.DEBUG_CONSOLE_BUFFERING) {
                        System.out.println(">>Console flushing [" + String.valueOf(consoleLine.type) + "] :" + consoleLine.line);
                    }
                    document.appendConsoleLine(consoleLine.type, consoleLine.line);
                }
                if (Policy.DEBUG_CONSOLE_BUFFERING) {
                    System.out.println("--Console discarding runnable");
                }
                aSyncRunnable = null;
            }
        };
        display.asyncExec(aSyncRunnable);
    }

    private static Console findInActivePerspective() {
        try {
            IWorkbenchPage page = CVSUIPlugin.getActivePage();
            IViewPart consolePart = page.findView(CONSOLE_ID);
            if (consolePart == null) {
                IWorkbenchPart activePart = page.getActivePart();
                consolePart = page.showView(CONSOLE_ID);
                if (activePart != null) {
                    page.activate(activePart);
                }
            } else {
                page.bringToTop((IWorkbenchPart)consolePart);
            }
            return (Console)consolePart;
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    private static IPreferenceStore getPreferenceStore() {
        return CVSUIPlugin.getPlugin().getPreferenceStore();
    }

    private static class PendingConsoleLine {
        public int type;
        public String line;

        public PendingConsoleLine(int type, String line) {
            this.type = type;
            this.line = line;
        }
    }

    private static class ConsoleListener
    implements IConsoleListener {
        private long commandStarted = 0L;

        ConsoleListener() {
        }

        public void commandInvoked(String line) {
            this.commandStarted = System.currentTimeMillis();
            Console.appendConsoleLine(4, Policy.bind("Console.preExecutionDelimiter"));
            Console.appendConsoleLine(0, line);
        }

        public void messageLineReceived(String line) {
            Console.appendConsoleLine(1, "  " + line);
        }

        public void errorLineReceived(String line) {
            Console.appendConsoleLine(2, "  " + line);
        }

        public void commandCompleted(IStatus status, Exception exception) {
            String time;
            long commandRuntime = System.currentTimeMillis() - this.commandStarted;
            try {
                time = TIME_FORMAT.format(new Date(commandRuntime));
            }
            catch (RuntimeException e) {
                CVSUIPlugin.log(4, Policy.bind("Console.couldNotFormatTime"), e);
                time = "";
            }
            if (status != null) {
                String statusText = status.getCode() == -10 ? Policy.bind("Console.resultServerError", status.getMessage(), time) : Policy.bind("Console.resultOk", time);
                Console.appendConsoleLine(3, statusText);
                IStatus[] children = status.getChildren();
                if (children.length == 0) {
                    if (!status.isOK()) {
                        Console.appendConsoleLine(3, this.messageLineForStatus(status));
                    }
                } else {
                    int i = 0;
                    while (i < children.length) {
                        if (!children[i].isOK()) {
                            Console.appendConsoleLine(3, this.messageLineForStatus(children[i]));
                        }
                        ++i;
                    }
                }
            } else if (exception != null) {
                String statusText = exception instanceof OperationCanceledException ? Policy.bind("Console.resultAborted", time) : Policy.bind("Console.resultException", time);
                Console.appendConsoleLine(3, statusText);
            } else {
                String statusText = Policy.bind("Console.resultOk", time);
            }
            Console.appendConsoleLine(4, Policy.bind("Console.postExecutionDelimiter"));
            Console.appendConsoleLine(4, "");
            Console.flushConsoleBuffer();
        }

        private String messageLineForStatus(IStatus status) {
            if (status.getSeverity() == 4) {
                return Policy.bind("Console.error", status.getMessage());
            }
            if (status.getSeverity() == 2) {
                return Policy.bind("Console.warning", status.getMessage());
            }
            if (status.getSeverity() == 1) {
                return Policy.bind("Console.info", status.getMessage());
            }
            return status.getMessage();
        }
    }
}

