/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ui.dialogs.DialogArea;

public class CommitCommentArea
extends DialogArea {
    private static final int WIDTH_HINT = 350;
    private static final int HEIGHT_HINT = 150;
    private Text text;
    private Combo previousCommentsCombo;
    private IProject mainProject;
    private String[] comments = CVSUIPlugin.getPlugin().getRepositoryManager().getPreviousComments();
    private String comment = "";
    public static final String OK_REQUESTED = "OkRequested";

    public CommitCommentArea(Dialog parentDialog, IDialogSettings settings) {
        super(parentDialog, settings);
    }

    public Control createArea(Composite parent) {
        Dialog.applyDialogFont((Control)parent);
        Composite composite = this.createGrabbingComposite(parent, 1);
        this.initializeDialogUnits((Control)composite);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(Policy.bind("ReleaseCommentDialog.enterComment"));
        this.text = new Text(composite, 2818);
        GridData data = new GridData(1808);
        data.widthHint = 350;
        data.heightHint = 150;
        this.text.setLayoutData((Object)data);
        this.text.selectAll();
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 && (e.stateMask & 0x40000) != 0) {
                    e.doit = false;
                    CommitCommentArea.this.signalCtrlEnter();
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommitCommentArea.this.comment = CommitCommentArea.this.text.getText();
            }
        });
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(Policy.bind("ReleaseCommentDialog.choosePrevious"));
        this.previousCommentsCombo = new Combo(composite, 8);
        data = new GridData(768);
        data.widthHint = 200;
        this.previousCommentsCombo.setLayoutData((Object)data);
        this.initializeValues();
        this.previousCommentsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = CommitCommentArea.this.previousCommentsCombo.getSelectionIndex();
                if (index != -1) {
                    CommitCommentArea.this.text.setText(CommitCommentArea.this.comments[index]);
                }
            }
        });
        return composite;
    }

    private void initializeValues() {
        String initialComment;
        int i = 0;
        while (i < this.comments.length) {
            this.previousCommentsCombo.add(this.flattenText(this.comments[i]));
            ++i;
        }
        this.previousCommentsCombo.setText("");
        try {
            initialComment = this.getCommitTemplate();
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            initialComment = null;
        }
        if (initialComment != null && initialComment.length() != 0) {
            this.text.setText(initialComment);
        }
    }

    private String flattenText(String string) {
        StringBuffer buffer = new StringBuffer(string.length() + 20);
        boolean skipAdjacentLineSeparator = true;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '\r' || c == '\n') {
                if (!skipAdjacentLineSeparator) {
                    buffer.append(Policy.bind("separator"));
                }
                skipAdjacentLineSeparator = true;
            } else {
                buffer.append(c);
                skipAdjacentLineSeparator = false;
            }
            ++i;
        }
        return buffer.toString();
    }

    private void signalCtrlEnter() {
        this.firePropertyChangeChange(OK_REQUESTED, null, null);
    }

    private void clearCommitText() {
        try {
            this.text.setText(this.getCommitTemplate());
            this.previousCommentsCombo.deselectAll();
        }
        catch (CVSException e) {
            CVSUIPlugin.openError(this.getShell(), null, null, e, 1);
        }
    }

    private String getCommitTemplate() throws CVSException {
        CVSTeamProvider provider = this.getProvider();
        if (provider == null) {
            return "";
        }
        String template = provider.getCommitTemplate();
        if (template == null) {
            template = "";
        }
        return template;
    }

    private CVSTeamProvider getProvider() throws CVSException {
        if (this.mainProject == null) {
            return null;
        }
        return (CVSTeamProvider)RepositoryProvider.getProvider((IProject)this.mainProject, (String)CVSProviderPlugin.getTypeId());
    }

    private String getSelectedComment() {
        if (this.comments.length == 0) {
            try {
                return this.getCommitTemplate();
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        } else {
            int index = this.previousCommentsCombo.getSelectionIndex();
            if (index != -1) {
                return this.comments[index];
            }
        }
        return "";
    }

    public String[] getComments() {
        return this.comments;
    }

    public String getComment() {
        if (this.comment != null && this.comment.length() > 0) {
            this.finished();
        }
        return this.comment;
    }

    public void setProject(IProject iProject) {
        this.mainProject = iProject;
    }

    private void finished() {
        try {
            if (this.comment.equals(this.getCommitTemplate())) {
                this.comment = "";
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
        if (this.comment.length() > 0) {
            CVSUIPlugin.getPlugin().getRepositoryManager().addComment(this.comment);
        }
    }
}

