/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class CVSPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button pruneEmptyDirectoriesField;
    private Text timeoutValue;
    private Combo quietnessCombo;
    private Combo compressionLevelCombo;
    private Combo ksubstCombo;
    private List ksubstOptions;
    private Button considerContentsInCompare;
    private Button replaceUnmanaged;
    private Button repositoriesAreBinary;
    private Button determineVersionEnabled;
    private Button confirmMoveTag;
    private Button debugProtocol;
    private Button never;
    private Button prompt;
    private Button auto;

    public CVSPreferencesPage() {
        this.setDescription(Policy.bind("CVSPreferencePage.description"));
        Command.KSubstOption[] options = Command.KSubstOption.getAllKSubstOptions();
        this.ksubstOptions = new ArrayList();
        int i = 0;
        while (i < options.length) {
            Command.KSubstOption option = options[i];
            if (!option.isBinary()) {
                this.ksubstOptions.add(option);
            }
            ++i;
        }
        Collections.sort(this.ksubstOptions, new Comparator(){

            public int compare(Object a, Object b) {
                String aKey = ((Command.KSubstOption)a).getLongDisplayText();
                String bKey = ((Command.KSubstOption)b).getLongDisplayText();
                return aKey.compareTo(bKey);
            }
        });
    }

    protected Combo createCombo(Composite parent, int widthChars) {
        Combo combo = new Combo(parent, 8);
        GridData data = new GridData(768);
        GC gc = new GC((Drawable)combo);
        gc.setFont(combo.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        data.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)widthChars);
        gc.dispose();
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected Combo createCombo(Composite parent) {
        Combo combo = new Combo(parent, 8);
        GridData data = new GridData(768);
        data.widthHint = 200;
        combo.setLayoutData((Object)data);
        return combo;
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        this.pruneEmptyDirectoriesField = this.createCheckBox(composite, Policy.bind("CVSPreferencePage.pruneEmptyDirectories"));
        this.considerContentsInCompare = this.createCheckBox(composite, Policy.bind("CVSPreferencePage.considerContentsInCompare"));
        this.replaceUnmanaged = this.createCheckBox(composite, Policy.bind("CVSPreferencePage.replaceUnmanaged"));
        this.repositoriesAreBinary = this.createCheckBox(composite, Policy.bind("CVSPreferencePage.repositoriesAreBinary"));
        this.determineVersionEnabled = this.createCheckBox(composite, Policy.bind("CVSPreferencePage.determineVersionEnabled"));
        this.confirmMoveTag = this.createCheckBox(composite, Policy.bind("CVSPreferencePage.confirmMoveTag"));
        this.debugProtocol = this.createCheckBox(composite, Policy.bind("CVSPreferencePage.debugProtocol"));
        this.createLabel(composite, "");
        this.createLabel(composite, "");
        this.createLabel(composite, Policy.bind("CVSPreferencePage.timeoutValue"));
        this.timeoutValue = this.createTextField(composite);
        this.timeoutValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    int x = Integer.parseInt(CVSPreferencesPage.this.timeoutValue.getText());
                    if (x >= 0) {
                        CVSPreferencesPage.this.setErrorMessage(null);
                        CVSPreferencesPage.this.setValid(true);
                    } else {
                        CVSPreferencesPage.this.setErrorMessage(Policy.bind("CVSPreferencesPage.Timeout_must_not_be_negative_1"));
                        CVSPreferencesPage.this.setValid(false);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    CVSPreferencesPage.this.setErrorMessage(Policy.bind("CVSPreferencesPage.Timeout_must_be_a_number_2"));
                    CVSPreferencesPage.this.setValid(false);
                }
            }
        });
        this.createLabel(composite, Policy.bind("CVSPreferencePage.quietness"));
        this.quietnessCombo = this.createCombo(composite);
        this.createLabel(composite, Policy.bind("CVSPreferencePage.compressionLevel"));
        this.compressionLevelCombo = this.createCombo(composite);
        this.createLabel(composite, Policy.bind("CVSPreferencePage.defaultTextKSubst"));
        int chars = 0;
        Iterator it = this.ksubstOptions.iterator();
        while (it.hasNext()) {
            Command.KSubstOption option = (Command.KSubstOption)it.next();
            int c = option.getLongDisplayText().length();
            if (c <= chars) continue;
            chars = c;
        }
        this.ksubstCombo = this.createCombo(composite, chars);
        this.createLabel(composite, "");
        this.createLabel(composite, "");
        this.createSaveCombo(composite);
        this.initializeValues();
        this.quietnessCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CVSPreferencesPage.getQuietnessOptionFor(CVSPreferencesPage.this.quietnessCombo.getSelectionIndex()).equals((Object)Command.SILENT)) {
                    MessageDialog.openWarning((Shell)CVSPreferencesPage.this.getShell(), (String)Policy.bind("CVSPreferencePage.silentWarningTitle"), (String)Policy.bind("CVSPreferencePage.silentWarningMessage"));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        WorkbenchHelp.setHelp((Control)this.pruneEmptyDirectoriesField, (String)"org.eclipse.team.cvs.ui.prune_empty_directories_pref");
        WorkbenchHelp.setHelp((Control)this.compressionLevelCombo, (String)"org.eclipse.team.cvs.ui.compression_level_pref");
        WorkbenchHelp.setHelp((Control)this.quietnessCombo, (String)"org.eclipse.team.cvs.ui.quietness_level_pref");
        WorkbenchHelp.setHelp((Control)this.ksubstCombo, (String)"org.eclipse.team.cvs.ui.default_keywordmode_pref");
        WorkbenchHelp.setHelp((Control)this.timeoutValue, (String)"org.eclipse.team.cvs.ui.comms_timeout_pref");
        WorkbenchHelp.setHelp((Control)this.considerContentsInCompare, (String)"org.eclipse.team.cvs.ui.consider_content_pref");
        WorkbenchHelp.setHelp((Control)this.replaceUnmanaged, (String)"org.eclipse.team.cvs.ui.replace_deletion_of_unmanaged_pref");
        WorkbenchHelp.setHelp((Control)this.repositoriesAreBinary, (String)"org.eclipse.team.cvs.ui.treat_new_files_as_binary_pref");
        WorkbenchHelp.setHelp((Control)this.determineVersionEnabled, (String)"org.eclipse.team.cvs.ui.determine_server_version");
        WorkbenchHelp.setHelp((Control)this.confirmMoveTag, (String)"org.eclipse.team.cvs.ui.confirm_move_tag");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private Text createTextField(Composite group) {
        Text text = new Text(group, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.pruneEmptyDirectoriesField.setSelection(store.getBoolean("pref_prune_empty_directories"));
        this.timeoutValue.setText(new Integer(store.getInt("pref_timeout")).toString());
        this.repositoriesAreBinary.setSelection(store.getBoolean("pref_repositories_are_binary"));
        this.quietnessCombo.add(Policy.bind("CVSPreferencePage.notquiet"));
        this.quietnessCombo.add(Policy.bind("CVSPreferencePage.somewhatquiet"));
        this.quietnessCombo.add(Policy.bind("CVSPreferencePage.reallyquiet"));
        this.quietnessCombo.select(store.getInt("pref_quietness"));
        int i = 0;
        while (i < 10) {
            this.compressionLevelCombo.add(Policy.bind("CVSPreferencePage.level" + i));
            ++i;
        }
        this.compressionLevelCombo.select(store.getInt("pref_compression_level"));
        Iterator it = this.ksubstOptions.iterator();
        while (it.hasNext()) {
            Command.KSubstOption option = (Command.KSubstOption)it.next();
            this.ksubstCombo.add(option.getLongDisplayText());
        }
        this.ksubstCombo.select(this.getKSubstComboIndexFor(store.getString("pref_text_ksubst")));
        this.considerContentsInCompare.setSelection(store.getBoolean("pref_consider_contents"));
        this.replaceUnmanaged.setSelection(store.getBoolean("pref_replace_unmanaged"));
        this.determineVersionEnabled.setSelection(store.getBoolean("pref_determine_server_version"));
        this.confirmMoveTag.setSelection(store.getBoolean("pref_confirm_move_tag"));
        this.debugProtocol.setSelection(store.getBoolean("pref_debug_protocol"));
        this.initializeSaveRadios(store.getInt("pref_save_dirty_editors"));
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        int timeout = Integer.parseInt(this.timeoutValue.getText());
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("pref_prune_empty_directories", this.pruneEmptyDirectoriesField.getSelection());
        store.setValue("pref_timeout", timeout);
        store.setValue("pref_quietness", this.quietnessCombo.getSelectionIndex());
        store.setValue("pref_compression_level", this.compressionLevelCombo.getSelectionIndex());
        String mode = ((Command.KSubstOption)this.ksubstOptions.get(this.ksubstCombo.getSelectionIndex())).toMode();
        if (mode.length() == 0) {
            mode = "-kkv";
        }
        store.setValue("pref_text_ksubst", mode);
        store.setValue("pref_consider_contents", this.considerContentsInCompare.getSelection());
        store.setValue("pref_replace_unmanaged", this.replaceUnmanaged.getSelection());
        store.setValue("pref_save_dirty_editors", this.getSaveRadio());
        store.setValue("pref_repositories_are_binary", this.repositoriesAreBinary.getSelection());
        store.setValue("pref_determine_server_version", this.determineVersionEnabled.getSelection());
        store.setValue("pref_confirm_move_tag", this.confirmMoveTag.getSelection());
        store.setValue("pref_debug_protocol", this.debugProtocol.getSelection());
        CVSProviderPlugin.getPlugin().setReplaceUnmanaged(store.getBoolean("pref_replace_unmanaged"));
        CVSProviderPlugin.getPlugin().setPruneEmptyDirectories(store.getBoolean("pref_prune_empty_directories"));
        CVSProviderPlugin.getPlugin().setTimeout(store.getInt("pref_timeout"));
        CVSProviderPlugin.getPlugin().setQuietness(CVSPreferencesPage.getQuietnessOptionFor(store.getInt("pref_quietness")));
        CVSProviderPlugin.getPlugin().setCompressionLevel(store.getInt("pref_compression_level"));
        CVSProviderPlugin.getPlugin().setDebugProtocol(store.getBoolean("pref_debug_protocol"));
        CVSProviderPlugin.getPlugin().setRepositoriesAreBinary(store.getBoolean("pref_repositories_are_binary"));
        Command.KSubstOption oldKSubst = CVSProviderPlugin.getPlugin().getDefaultTextKSubstOption();
        Command.KSubstOption newKSubst = Command.KSubstOption.fromMode((String)store.getString("pref_text_ksubst"));
        CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(newKSubst);
        CVSProviderPlugin.getPlugin().setDetermineVersionEnabled(store.getBoolean("pref_determine_server_version"));
        CVSProviderPlugin.getPlugin().setConfirmMoveTagEnabled(store.getBoolean("pref_confirm_move_tag"));
        if (!oldKSubst.equals((Object)newKSubst)) {
            CVSUIPlugin.broadcastPropertyChange(new PropertyChangeEvent((Object)this, "org.eclipse.team.cvs.ui.P_DECORATORS_CHANGED", null, null));
        }
        CVSUIPlugin.getPlugin().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = this.getPreferenceStore();
        this.pruneEmptyDirectoriesField.setSelection(store.getDefaultBoolean("pref_prune_empty_directories"));
        this.timeoutValue.setText(new Integer(store.getDefaultInt("pref_timeout")).toString());
        this.quietnessCombo.select(store.getDefaultInt("pref_quietness"));
        this.compressionLevelCombo.select(store.getDefaultInt("pref_compression_level"));
        this.ksubstCombo.select(this.getKSubstComboIndexFor(store.getDefaultString("pref_text_ksubst")));
        this.replaceUnmanaged.setSelection(store.getDefaultBoolean("pref_replace_unmanaged"));
        this.initializeSaveRadios(store.getDefaultInt("pref_save_dirty_editors"));
        this.repositoriesAreBinary.setSelection(store.getDefaultBoolean("pref_repositories_are_binary"));
        this.confirmMoveTag.setSelection(store.getDefaultBoolean("pref_confirm_move_tag"));
        this.debugProtocol.setSelection(store.getDefaultBoolean("pref_debug_protocol"));
    }

    private void createSaveCombo(Composite composite) {
        Group group = new Group(composite, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setText(Policy.bind("CVSPreferencePage.Save_dirty_editors_before_CVS_operations_1"));
        this.never = new Button((Composite)group, 16400);
        this.never.setLayoutData((Object)new GridData());
        this.never.setText(Policy.bind("CVSPreferencePage.&Never_2"));
        this.prompt = new Button((Composite)group, 16400);
        this.prompt.setLayoutData((Object)new GridData());
        this.prompt.setText(Policy.bind("CVSPreferencePage.&Prompt_3"));
        this.auto = new Button((Composite)group, 16400);
        this.auto.setLayoutData((Object)new GridData());
        this.auto.setText(Policy.bind("CVSPreferencePage.Auto-&save_4"));
        WorkbenchHelp.setHelp((Control)group, (String)"org.eclipse.team.cvs.ui.save_dirty_editors_pref");
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CVSUIPlugin.getPlugin().getPreferenceStore();
    }

    protected static Command.QuietOption getQuietnessOptionFor(int option) {
        switch (option) {
            case 0: {
                return Command.VERBOSE;
            }
            case 1: {
                return Command.PARTLY_QUIET;
            }
            case 2: {
                return Command.SILENT;
            }
        }
        return null;
    }

    protected int getKSubstComboIndexFor(String mode) {
        Command.KSubstOption ksubst = Command.KSubstOption.fromMode((String)mode);
        int i = 0;
        Iterator it = this.ksubstOptions.iterator();
        while (it.hasNext()) {
            Command.KSubstOption option = (Command.KSubstOption)it.next();
            if (ksubst.equals((Object)option)) {
                return i;
            }
            ++i;
        }
        this.ksubstOptions.add(ksubst);
        this.ksubstCombo.add(ksubst.getLongDisplayText());
        return i;
    }

    protected void initializeSaveRadios(int option) {
        this.auto.setSelection(false);
        this.never.setSelection(false);
        this.prompt.setSelection(false);
        switch (option) {
            case 3: {
                this.auto.setSelection(true);
                break;
            }
            case 1: {
                this.never.setSelection(true);
                break;
            }
            case 2: {
                this.prompt.setSelection(true);
            }
        }
    }

    protected int getSaveRadio() {
        if (this.auto.getSelection()) {
            return 3;
        }
        if (this.never.getSelection()) {
            return 1;
        }
        return 2;
    }
}

