/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.util.Assert;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.sync.CVSSyncCompareInput;

public class CVSLocalCompareEditorInput
extends CVSSyncCompareInput {
    CVSTag[] tags;

    public CVSLocalCompareEditorInput(IResource[] resources, CVSTag[] tags) {
        super(resources);
        Assert.isTrue((resources.length == tags.length ? 1 : 0) != 0);
        this.tags = tags;
    }

    public CVSLocalCompareEditorInput(IResource[] resources, CVSTag tag) {
        super(resources);
        Assert.isTrue((tag != null ? 1 : 0) != 0);
        this.tags = new CVSTag[]{tag};
    }

    public Viewer createDiffViewer(Composite parent) {
        Viewer viewer = super.createDiffViewer(parent);
        this.getViewer().syncModeChanged(5);
        return viewer;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IRemoteSyncElement[] createSyncElements(IProgressMonitor monitor) throws TeamException {
        IResource[] resources = this.getResources();
        IRemoteSyncElement[] trees = new IRemoteSyncElement[resources.length];
        int work = 100 * resources.length;
        monitor.beginTask(null, work);
        try {
            int i = 0;
            while (i < trees.length) {
                IResource resource = resources[i];
                CVSTag tag = this.tags.length != resources.length ? this.tags[0] : this.tags[i];
                ICVSRemoteResource remote = CVSWorkspaceRoot.getRemoteTree((IResource)resource, (CVSTag)tag, (boolean)this.getCacheFileContentsHint(), (IProgressMonitor)Policy.subMonitorFor(monitor, 50));
                trees[i] = new CVSRemoteSyncElement(false, resource, null, (IRemoteResource)remote);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        monitor.done();
        return trees;
    }

    private boolean getCacheFileContentsHint() {
        return this.getSyncGranularity() != 1;
    }

    public String getTitle() {
        return Policy.bind("CVSLocalCompareEditorInput.title", this.tags[0].getName());
    }

    protected void contentsChanged(ICompareInput source) {
    }

    public String getToolTipText() {
        return this.getTitle();
    }
}

