/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ccvs.ssh2;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.ccvs.ssh2.JSchSession;
import org.eclipse.team.ccvs.ssh2.Policy;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IServerConnection;
import org.eclipse.team.internal.ccvs.core.connection.CVSAuthenticationException;
import org.eclipse.team.internal.ccvs.ssh.SSHServerConnection;

public class CVSSSH2ServerConnection
implements IServerConnection {
    private static final String COMMAND = "cvs server";
    private ICVSRepositoryLocation location;
    private String password;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Session session;
    private Channel channel;
    private IServerConnection ssh1;

    protected CVSSSH2ServerConnection(ICVSRepositoryLocation location, String password) {
        this.location = location;
        this.password = password;
    }

    public void close() throws IOException {
        if (this.ssh1 != null) {
            this.ssh1.close();
            return;
        }
        if (this.channel != null) {
            this.channel.disconnect();
        }
    }

    public InputStream getInputStream() {
        if (this.ssh1 != null) {
            return this.ssh1.getInputStream();
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        if (this.ssh1 != null) {
            return this.ssh1.getOutputStream();
        }
        return this.outputStream;
    }

    /*
     * WARNING - void declaration
     */
    public void open(IProgressMonitor monitor) throws IOException, CVSAuthenticationException {
        if (this.ssh1 != null) {
            this.ssh1.open(monitor);
            return;
        }
        monitor.subTask(Policy.bind("CVSSSH2ServerConnection.open", this.location.getHost()));
        monitor.worked(1);
        try {
            void var6_7;
            void var7_8;
            String hostname = this.location.getHost();
            String username = this.location.getUsername();
            int port = this.location.getPort();
            if (port == 0) {
                port = 0;
            }
            int retry = 1;
            while (true) {
                this.session = JSchSession.getSession(this.location, username, this.password, hostname, port, monitor);
                this.channel = this.session.openChannel("exec");
                ((ChannelExec)this.channel).setCommand(COMMAND);
                OutputStream channel_out = this.channel.getOutputStream();
                InputStream channel_in = this.channel.getInputStream();
                try {
                    this.channel.connect();
                }
                catch (JSchException jSchException) {
                    if (--retry < 0) {
                        throw new CVSAuthenticationException(Policy.bind("CVSSSH2ServerConnection.3"));
                    }
                    if (!this.session.isConnected()) continue;
                    this.session.disconnect();
                    continue;
                }
                break;
            }
            this.inputStream = var7_8;
            this.outputStream = var6_7;
        }
        catch (JSchException e) {
            if (e.toString().indexOf("invalid server's version string") == -1) {
                throw new CVSAuthenticationException(e.toString());
            }
            this.ssh1 = new SSHServerConnection(this.location, this.password);
            if (this.ssh1 == null) {
                throw new CVSAuthenticationException(e.toString());
            }
            this.ssh1.open(monitor);
        }
    }
}

