/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ccvs.ssh2;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.ccvs.ssh2.CVSSSH2Plugin;
import org.eclipse.team.ccvs.ssh2.JSchSession;
import org.eclipse.team.ccvs.ssh2.Policy;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CVSSSH2PreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String KEY_PROXY = "CVSSSH2PreferencePage.PROXY";
    public static String KEY_PROXY_TYPE = "CVSSSH2PreferencePage.PROXY_TYPE";
    public static String KEY_PROXY_HOST = "CVSSSH2PreferencePage.PROXY_HOST";
    public static String KEY_PROXY_PORT = "CVSSSH2PreferencePage.PROXY_PORT";
    public static String KEY_PROXY_AUTH = "CVSSSH2PreferencePage.PROXY_AUTH";
    public static String KEY_PROXY_USER = "CVSSSH2PreferencePage.PROXY_USER";
    public static String KEY_PROXY_PASS = "CVSSSH2PreferencePage.PROXY_PASS";
    public static String KEY_SSH2HOME = "CVSSSH2PreferencePage.SSH2HOME";
    public static String KEY_KEYFILE = "CVSSSH2PreferencePage.KEYFILE";
    public static String KEY_PRIVATEKEY = "CVSSSH2PreferencePage.PRIVATEKEY";
    public static String KEY_USE_SSH2 = "CVSSSH2PreferencePage.SSH2_USE_SSH2";
    static String SOCKS5 = "SOCKS5";
    static String HTTP = "HTTP";
    private static String HTTP_DEFAULT_PORT = "80";
    private static String SOCKS5_DEFAULT_PORT = "1080";
    private static String privatekeys = "id_dsa,id_rsa";
    static String DSA = "DSA";
    static String RSA = "RSA";
    private Label ssh2HomeLabel;
    private Label proxyTypeLabel;
    private Label proxyHostLabel;
    private Label proxyPortLabel;
    private Label proxyUserLabel;
    private Label proxyPassLabel;
    private Label privateKeyLabel;
    private Combo proxyTypeCombo;
    private Text ssh2HomeText;
    private Text proxyHostText;
    private Text proxyPortText;
    private Text proxyUserText;
    private Text proxyPassText;
    private Text privateKeyText;
    private Button enableProxy;
    private Button enableAuth;
    private Button enableSSH2;
    private Button privateKeyAdd;
    private boolean useProxy;
    private boolean useAuth;
    private Label keyTypeLabel;
    private Combo keyTypeCombo;
    private Button ssh2HomeBrowse;
    private Button keyGenerate;
    private Button saveKeyPair;
    private Label keyCommentLabel;
    private Text keyCommentText;
    private Label keyFingerPrintLabel;
    private Text keyFingerPrintText;
    private Label keyPassphrase1Label;
    private Text keyPassphrase1Text;
    private Label keyPassphrase2Label;
    private Text keyPassphrase2Text;
    private Label publicKeylabel;
    private Text publicKeyText;
    private KeyPair kpair = null;
    private String kpairComment;

    public CVSSSH2PreferencePage() {
        IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        this.setDescription(Policy.bind("CVSSSH2PreferencePage.18"));
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        TabFolder tabFolder = new TabFolder(container, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Policy.bind("CVSSSH2PreferencePage.19"));
        tabItem.setControl(this.createGeneralPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Policy.bind("CVSSSH2PreferencePage.20"));
        tabItem.setControl(this.createProxyPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Policy.bind("CVSSSH2PreferencePage.21"));
        tabItem.setControl(this.createKeyManagementPage((Composite)tabFolder));
        IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
        CVSSSH2PreferencePage.initDefaults(store);
        this.initControls();
        return container;
    }

    private Control createGeneralPage(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        group.setLayoutData((Object)data);
        this.enableSSH2 = new Button(group, 32);
        this.enableSSH2.setText(Policy.bind("CVSSSH2PreferencePage.22"));
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.enableSSH2.setLayoutData((Object)gd);
        this.createSpacer(group, 3);
        this.ssh2HomeLabel = new Label(group, 0);
        this.ssh2HomeLabel.setText(Policy.bind("CVSSSH2PreferencePage.23"));
        this.ssh2HomeText = new Text(group, 2052);
        this.ssh2HomeText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.ssh2HomeText.setLayoutData((Object)gd);
        this.ssh2HomeBrowse = new Button(group, 0);
        this.ssh2HomeBrowse.setText(Policy.bind("CVSSSH2PreferencePage.24"));
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.ssh2HomeBrowse.setLayoutData((Object)gd);
        this.createSpacer(group, 3);
        this.privateKeyLabel = new Label(group, 0);
        this.privateKeyLabel.setText(Policy.bind("CVSSSH2PreferencePage.25"));
        this.privateKeyText = new Text(group, 2052);
        this.privateKeyText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.privateKeyText.setLayoutData((Object)gd);
        this.privateKeyAdd = new Button(group, 0);
        this.privateKeyAdd.setText(Policy.bind("CVSSSH2PreferencePage.26"));
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.privateKeyAdd.setLayoutData((Object)gd);
        this.ssh2HomeBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String home = CVSSSH2PreferencePage.this.ssh2HomeText.getText();
                if (!new File(home).exists()) {
                    int foo;
                    while ((foo = home.lastIndexOf(File.separator, home.length())) != -1 && !new File(home = home.substring(0, foo)).exists()) {
                    }
                }
                DirectoryDialog dd = new DirectoryDialog(CVSSSH2PreferencePage.this.getShell());
                dd.setFilterPath(home);
                dd.setMessage(Policy.bind("CVSSSH2PreferencePage.27"));
                String dir = dd.open();
                if (dir == null) {
                    return;
                }
                CVSSSH2PreferencePage.this.ssh2HomeText.setText(dir);
            }
        });
        this.privateKeyAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String home = CVSSSH2PreferencePage.this.ssh2HomeText.getText();
                FileDialog fd = new FileDialog(CVSSSH2PreferencePage.this.getShell(), 4098);
                fd.setFilterPath(home);
                String o = fd.open();
                if (o == null) {
                    return;
                }
                String[] files = fd.getFileNames();
                String keys = CVSSSH2PreferencePage.this.privateKeyText.getText();
                String dir = fd.getFilterPath();
                dir = dir.equals(home) ? "" : String.valueOf(dir) + File.separator;
                int i = 0;
                while (i < files.length) {
                    String foo = files[i];
                    keys = String.valueOf(keys) + "," + dir + foo;
                    ++i;
                }
                CVSSSH2PreferencePage.this.privateKeyText.setText(keys);
            }
        });
        return group;
    }

    private Control createProxyPage(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        group.setLayoutData((Object)data);
        this.enableProxy = new Button(group, 32);
        this.enableProxy.setText(Policy.bind("CVSSSH2PreferencePage.30"));
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.enableProxy.setLayoutData((Object)gd);
        this.proxyTypeLabel = new Label(group, 0);
        this.proxyTypeLabel.setText(Policy.bind("CVSSSH2PreferencePage.31"));
        this.proxyTypeCombo = new Combo(group, 8);
        this.proxyTypeCombo.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyTypeCombo.setLayoutData((Object)gd);
        this.proxyTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CVSSSH2PreferencePage.this.proxyPortText == null) {
                    return;
                }
                Combo combo = (Combo)e.getSource();
                String foo = combo.getText();
                if (foo.equals(HTTP)) {
                    CVSSSH2PreferencePage.this.proxyPortText.setText(HTTP_DEFAULT_PORT);
                } else if (foo.equals(SOCKS5)) {
                    CVSSSH2PreferencePage.this.proxyPortText.setText(SOCKS5_DEFAULT_PORT);
                }
            }
        });
        this.proxyTypeCombo.add(HTTP);
        this.proxyTypeCombo.add(SOCKS5);
        this.proxyTypeCombo.select(0);
        this.proxyHostLabel = new Label(group, 0);
        this.proxyHostLabel.setText(Policy.bind("CVSSSH2PreferencePage.32"));
        this.proxyHostText = new Text(group, 2052);
        this.proxyHostText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyHostText.setLayoutData((Object)gd);
        this.proxyPortLabel = new Label(group, 0);
        this.proxyPortLabel.setText(Policy.bind("CVSSSH2PreferencePage.33"));
        this.proxyPortText = new Text(group, 2052);
        this.proxyPortText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyPortText.setLayoutData((Object)gd);
        this.createSpacer(group, 3);
        this.enableAuth = new Button(group, 32);
        this.enableAuth.setText(Policy.bind("CVSSSH2PreferencePage.34"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.enableAuth.setLayoutData((Object)gd);
        this.proxyUserLabel = new Label(group, 0);
        this.proxyUserLabel.setText(Policy.bind("CVSSSH2PreferencePage.35"));
        this.proxyUserText = new Text(group, 2052);
        this.proxyUserText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyUserText.setLayoutData((Object)gd);
        this.proxyPassLabel = new Label(group, 0);
        this.proxyPassLabel.setText(Policy.bind("CVSSSH2PreferencePage.36"));
        this.proxyPassText = new Text(group, 2052);
        this.proxyPassText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyPassText.setLayoutData((Object)gd);
        this.enableProxy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CVSSSH2PreferencePage.this.updateControls();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.enableAuth.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CVSSSH2PreferencePage.this.updateControls();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return group;
    }

    private Control createKeyManagementPage(Composite parent) {
        int columnSpan = 3;
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        group.setLayoutData((Object)data);
        this.keyTypeLabel = new Label(group, 0);
        this.keyTypeLabel.setText(Policy.bind("CVSSSH2PreferencePage.37"));
        this.keyTypeCombo = new Combo(group, 8);
        this.keyTypeCombo.setFont(group.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyTypeCombo.setLayoutData((Object)gd);
        this.keyGenerate = new Button(group, 0);
        this.keyGenerate.setText(Policy.bind("CVSSSH2PreferencePage.38"));
        gd = new GridData(128);
        gd.horizontalSpan = columnSpan;
        this.keyGenerate.setLayoutData((Object)gd);
        this.publicKeylabel = new Label(group, 0);
        this.publicKeylabel.setText(Policy.bind("CVSSSH2PreferencePage.39"));
        gd = new GridData();
        gd.horizontalSpan = columnSpan;
        this.publicKeylabel.setLayoutData((Object)gd);
        this.publicKeyText = new Text(group, 2626);
        this.publicKeyText.setText("");
        this.publicKeyText.setEditable(false);
        gd = new GridData();
        gd.horizontalSpan = columnSpan;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.publicKeyText.setLayoutData((Object)gd);
        this.keyFingerPrintLabel = new Label(group, 0);
        this.keyFingerPrintLabel.setText(Policy.bind("CVSSSH2PreferencePage.41"));
        this.keyFingerPrintText = new Text(group, 2052);
        this.keyFingerPrintText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyFingerPrintText.setLayoutData((Object)gd);
        this.keyCommentLabel = new Label(group, 0);
        this.keyCommentLabel.setText(Policy.bind("CVSSSH2PreferencePage.42"));
        this.keyCommentText = new Text(group, 2052);
        this.keyCommentText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyCommentText.setLayoutData((Object)gd);
        this.keyPassphrase1Label = new Label(group, 0);
        this.keyPassphrase1Label.setText(Policy.bind("CVSSSH2PreferencePage.43"));
        this.keyPassphrase1Text = new Text(group, 2052);
        this.keyPassphrase1Text.setFont(group.getFont());
        this.keyPassphrase1Text.setEchoChar('*');
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyPassphrase1Text.setLayoutData((Object)gd);
        this.keyPassphrase2Label = new Label(group, 0);
        this.keyPassphrase2Label.setText(Policy.bind("CVSSSH2PreferencePage.44"));
        this.keyPassphrase2Text = new Text(group, 2052);
        this.keyPassphrase2Text.setFont(group.getFont());
        this.keyPassphrase2Text.setEchoChar('*');
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyPassphrase2Text.setLayoutData((Object)gd);
        this.saveKeyPair = new Button(group, 0);
        this.saveKeyPair.setText(Policy.bind("CVSSSH2PreferencePage.45"));
        gd = new GridData(128);
        gd.horizontalSpan = columnSpan;
        this.saveKeyPair.setLayoutData((Object)gd);
        this.keyGenerate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSch jsch = JSchSession.getJSch();
                String _type = CVSSSH2PreferencePage.this.keyTypeCombo.getText();
                try {
                    int type = 0;
                    if (_type.equals(DSA)) {
                        type = 0;
                    } else if (_type.equals(RSA)) {
                        type = 1;
                    } else {
                        return;
                    }
                    CVSSSH2PreferencePage.this.kpair = KeyPair.genKeyPair((JSch)jsch, (int)type);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    CVSSSH2PreferencePage.this.kpairComment = String.valueOf(_type) + "-1024";
                    CVSSSH2PreferencePage.this.kpair.writePublicKey((OutputStream)out, CVSSSH2PreferencePage.this.kpairComment);
                    out.close();
                    CVSSSH2PreferencePage.this.publicKeyText.setText(out.toString());
                    CVSSSH2PreferencePage.this.keyFingerPrintText.setText(CVSSSH2PreferencePage.this.kpair.getFingerPrint());
                    CVSSSH2PreferencePage.this.keyCommentText.setText(CVSSSH2PreferencePage.this.kpairComment);
                    CVSSSH2PreferencePage.this.updateControls();
                }
                catch (IOException iOException) {
                }
                catch (JSchException jSchException) {}
                MessageBox mb = new MessageBox(CVSSSH2PreferencePage.this.getShell(), 34);
                mb.setText(Policy.bind("CVSSSH2PreferencePage.info"));
                mb.setMessage(String.valueOf(_type) + Policy.bind("CVSSSH2PreferencePage.47"));
                mb.open();
            }
        });
        this.saveKeyPair.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox mb;
                if (CVSSSH2PreferencePage.this.kpair == null) {
                    return;
                }
                String pass = CVSSSH2PreferencePage.this.keyPassphrase1Text.getText();
                if (!pass.equals(CVSSSH2PreferencePage.this.keyPassphrase2Text.getText())) {
                    MessageBox mb2 = new MessageBox(CVSSSH2PreferencePage.this.getShell(), 33);
                    mb2.setText(Policy.bind("CVSSSH2PreferencePage.error"));
                    mb2.setMessage(Policy.bind("CVSSSH2PreferencePage.48"));
                    mb2.open();
                    return;
                }
                if (pass.length() == 0) {
                    mb = new MessageBox(CVSSSH2PreferencePage.this.getShell(), 200);
                    mb.setText(Policy.bind("CVSSSH2PreferencePage.warning"));
                    mb.setMessage(Policy.bind("CVSSSH2PreferencePage.49"));
                    if (mb.open() == 128) {
                        return;
                    }
                }
                CVSSSH2PreferencePage.this.kpair.setPassphrase(pass);
                CVSSSH2Plugin.getDefault().getPreferenceStore();
                String home = CVSSSH2PreferencePage.this.ssh2HomeText.getText();
                File _home = new File(home);
                if (!_home.exists()) {
                    mb = new MessageBox(CVSSSH2PreferencePage.this.getShell(), 196);
                    mb.setText(Policy.bind("CVSSSH2PreferencePage.question"));
                    mb.setMessage(String.valueOf(home) + Policy.bind("CVSSSH2PreferencePage.50"));
                    if (mb.open() == 128) {
                        return;
                    }
                    if (!_home.mkdirs()) {
                        return;
                    }
                }
                FileDialog fd = new FileDialog(CVSSSH2PreferencePage.this.getShell(), 8192);
                fd.setFilterPath(home);
                String file = CVSSSH2PreferencePage.this.kpair.getKeyType() == 1 ? "id_rsa" : "id_dsa";
                fd.setFileName(file);
                file = fd.open();
                if (file == null) {
                    return;
                }
                if (new File(file).exists()) {
                    mb = new MessageBox(CVSSSH2PreferencePage.this.getShell(), 200);
                    mb.setText(Policy.bind("CVSSSH2PreferencePage.warning"));
                    mb.setMessage(String.valueOf(file) + Policy.bind("CVSSSH2PreferencePage.53"));
                    if (mb.open() == 128) {
                        return;
                    }
                }
                boolean ok = true;
                try {
                    CVSSSH2PreferencePage.this.kpair.writePrivateKey(file);
                    CVSSSH2PreferencePage.this.kpair.writePublicKey(String.valueOf(file) + ".pub", CVSSSH2PreferencePage.this.kpairComment);
                }
                catch (Exception exception) {
                    ok = false;
                }
                if (ok) {
                    mb = new MessageBox(CVSSSH2PreferencePage.this.getShell(), 34);
                    mb.setText(Policy.bind("CVSSSH2PreferencePage.information"));
                    mb.setMessage(String.valueOf(Policy.bind("CVSSSH2PreferencePage.55")) + "\n" + Policy.bind("CVSSSH2PreferencePage.57") + file + "\n" + Policy.bind("CVSSSH2PreferencePage.59") + file + ".pub");
                    mb.open();
                }
            }
        });
        this.keyTypeCombo.add(DSA);
        this.keyTypeCombo.add(RSA);
        this.keyTypeCombo.select(0);
        return group;
    }

    private void updateControls() {
        boolean enable = this.enableProxy.getSelection();
        this.proxyTypeLabel.setEnabled(enable);
        this.proxyTypeCombo.setEnabled(enable);
        this.proxyPortLabel.setEnabled(enable);
        this.proxyPortText.setEnabled(enable);
        this.proxyHostLabel.setEnabled(enable);
        this.proxyHostText.setEnabled(enable);
        this.enableAuth.setEnabled(enable);
        this.proxyUserLabel.setEnabled(enable &= this.enableAuth.getSelection());
        this.proxyUserText.setEnabled(enable);
        this.proxyPassLabel.setEnabled(enable);
        this.proxyPassText.setEnabled(enable);
        enable = this.kpair != null;
        this.publicKeylabel.setEnabled(enable);
        this.publicKeyText.setEnabled(enable);
        this.keyFingerPrintLabel.setEnabled(enable);
        this.keyFingerPrintText.setEnabled(enable);
        this.keyCommentLabel.setEnabled(enable);
        this.keyCommentText.setEnabled(enable);
        this.keyPassphrase1Label.setEnabled(enable);
        this.keyPassphrase1Text.setEnabled(enable);
        this.keyPassphrase2Label.setEnabled(enable);
        this.keyPassphrase2Text.setEnabled(enable);
        this.saveKeyPair.setEnabled(enable);
    }

    public void init(IWorkbench workbench) {
    }

    public void initialize() {
        this.initControls();
    }

    public static void initDefaults(IPreferenceStore store) {
        CVSSSH2PreferencePage.setDefault(store, KEY_SSH2HOME, JSchSession.default_ssh_home);
        CVSSSH2PreferencePage.setDefault(store, KEY_PRIVATEKEY, privatekeys);
        CVSSSH2PreferencePage.setDefault(store, KEY_PROXY_TYPE, HTTP);
        CVSSSH2PreferencePage.setDefault(store, KEY_PROXY_PORT, HTTP_DEFAULT_PORT);
        CVSSSH2PreferencePage.setDefault(store, KEY_PROXY_AUTH, "false");
        CVSSSH2PreferencePage.setDefault(store, KEY_PROXY_USER, "");
        CVSSSH2PreferencePage.setDefault(store, KEY_PROXY_PASS, "");
        store.setDefault(KEY_USE_SSH2, false);
    }

    private static void setDefault(IPreferenceStore store, String key, String value) {
        store.setDefault(key, value);
        if (store.getString(key).length() == 0) {
            store.setValue(key, value);
        }
    }

    private void initControls() {
        IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
        this.ssh2HomeText.setText(store.getString(KEY_SSH2HOME));
        this.privateKeyText.setText(store.getString(KEY_PRIVATEKEY));
        this.enableSSH2.setSelection(store.getBoolean(KEY_USE_SSH2));
        this.useProxy = store.getString(KEY_PROXY).equals("true");
        this.enableProxy.setSelection(this.useProxy);
        this.proxyHostText.setText(store.getString(KEY_PROXY_HOST));
        this.proxyPortText.setText(store.getString(KEY_PROXY_PORT));
        this.proxyTypeCombo.select(store.getString(KEY_PROXY_TYPE).equals(HTTP) ? 0 : 1);
        this.useAuth = store.getString(KEY_PROXY_AUTH).equals("true");
        this.enableAuth.setSelection(this.useAuth);
        this.proxyUserText.setText(store.getString(KEY_PROXY_USER));
        this.proxyPassText.setText(store.getString(KEY_PROXY_PASS));
        this.proxyPassText.setEchoChar('*');
        this.updateControls();
    }

    protected void createProxy(Composite composite, int columnSpan) {
        Group group = new Group(composite, 0);
        group.setText(Policy.bind("CVSSSH2PreferencePage.66"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        gd.horizontalAlignment = 4;
        group.setLayoutData((Object)gd);
        group.setFont(composite.getFont());
        this.enableProxy = new Button((Composite)group, 32);
        this.enableProxy.setText(Policy.bind("CVSSSH2PreferencePage.67"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.enableProxy.setLayoutData((Object)gd);
        this.proxyTypeLabel = new Label((Composite)group, 0);
        this.proxyTypeLabel.setText(Policy.bind("CVSSSH2PreferencePage.68"));
        this.proxyTypeCombo = new Combo((Composite)group, 8);
        this.proxyTypeCombo.setFont(group.getFont());
        gd = new GridData(768);
        this.proxyTypeCombo.setLayoutData((Object)gd);
        this.proxyTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CVSSSH2PreferencePage.this.proxyPortText == null) {
                    return;
                }
                Combo combo = (Combo)e.getSource();
                String foo = combo.getText();
                if (foo.equals(HTTP)) {
                    CVSSSH2PreferencePage.this.proxyPortText.setText(HTTP_DEFAULT_PORT);
                } else if (foo.equals(SOCKS5)) {
                    CVSSSH2PreferencePage.this.proxyPortText.setText(SOCKS5_DEFAULT_PORT);
                }
            }
        });
        this.proxyTypeCombo.add(HTTP);
        this.proxyTypeCombo.add(SOCKS5);
        this.proxyTypeCombo.select(0);
        this.proxyHostLabel = new Label((Composite)group, 0);
        this.proxyHostLabel.setText(Policy.bind("CVSSSH2PreferencePage.69"));
        this.proxyHostText = new Text((Composite)group, 2052);
        this.proxyHostText.setFont(group.getFont());
        gd = new GridData(768);
        this.proxyHostText.setLayoutData((Object)gd);
        this.proxyPortLabel = new Label((Composite)group, 0);
        this.proxyPortLabel.setText(Policy.bind("CVSSSH2PreferencePage.70"));
        this.proxyPortText = new Text((Composite)group, 2052);
        this.proxyPortText.setFont(group.getFont());
        gd = new GridData(768);
        this.proxyPortText.setLayoutData((Object)gd);
        this.createSpacer((Composite)group, 3);
        this.enableAuth = new Button((Composite)group, 32);
        this.enableAuth.setText(Policy.bind("CVSSSH2PreferencePage.71"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.enableAuth.setLayoutData((Object)gd);
        this.proxyUserLabel = new Label((Composite)group, 0);
        this.proxyUserLabel.setText(Policy.bind("CVSSSH2PreferencePage.72"));
        this.proxyUserText = new Text((Composite)group, 2052);
        this.proxyUserText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyUserText.setLayoutData((Object)gd);
        this.proxyPassLabel = new Label((Composite)group, 0);
        this.proxyPassLabel.setText(Policy.bind("CVSSSH2PreferencePage.73"));
        this.proxyPassText = new Text((Composite)group, 2052);
        this.proxyPassText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyPassText.setLayoutData((Object)gd);
        this.enableProxy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CVSSSH2PreferencePage.this.updateControls();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.enableAuth.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CVSSSH2PreferencePage.this.updateControls();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createKeyGeneration(Composite composite, int columnSpan) {
        Group group = new Group(composite, 0);
        group.setText(Policy.bind("CVSSSH2PreferencePage.74"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        gd.horizontalAlignment = 4;
        group.setLayoutData((Object)gd);
        group.setFont(composite.getFont());
        this.keyTypeLabel = new Label((Composite)group, 0);
        this.keyTypeLabel.setText(Policy.bind("CVSSSH2PreferencePage.75"));
        this.keyTypeCombo = new Combo((Composite)group, 8);
        this.keyTypeCombo.setFont(group.getFont());
        gd = new GridData(768);
        this.keyTypeCombo.setLayoutData((Object)gd);
        this.keyGenerate = new Button((Composite)group, 0);
        this.keyGenerate.setText(Policy.bind("CVSSSH2PreferencePage.76"));
        gd = new GridData(128);
        gd.horizontalSpan = columnSpan;
        this.keyGenerate.setLayoutData((Object)gd);
        this.publicKeylabel = new Label((Composite)group, 0);
        this.publicKeylabel.setText(Policy.bind("CVSSSH2PreferencePage.77"));
        gd = new GridData();
        gd.horizontalSpan = columnSpan;
        this.publicKeylabel.setLayoutData((Object)gd);
        this.publicKeyText = new Text((Composite)group, 2562);
        this.publicKeyText.setText("");
        this.publicKeyText.setEditable(false);
        gd = new GridData();
        gd.horizontalSpan = columnSpan;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.publicKeyText.setLayoutData((Object)gd);
        this.keyFingerPrintLabel = new Label((Composite)group, 0);
        this.keyFingerPrintLabel.setText(Policy.bind("CVSSSH2PreferencePage.79"));
        this.keyFingerPrintText = new Text((Composite)group, 2052);
        this.keyFingerPrintText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyFingerPrintText.setLayoutData((Object)gd);
        this.keyCommentLabel = new Label((Composite)group, 0);
        this.keyCommentLabel.setText(Policy.bind("CVSSSH2PreferencePage.80"));
        this.keyCommentText = new Text((Composite)group, 2052);
        this.keyCommentText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyCommentText.setLayoutData((Object)gd);
        this.keyPassphrase1Label = new Label((Composite)group, 0);
        this.keyPassphrase1Label.setText(Policy.bind("CVSSSH2PreferencePage.81"));
        this.keyPassphrase1Text = new Text((Composite)group, 2052);
        this.keyPassphrase1Text.setFont(group.getFont());
        this.keyPassphrase1Text.setEchoChar('*');
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyPassphrase1Text.setLayoutData((Object)gd);
        this.keyPassphrase2Label = new Label((Composite)group, 0);
        this.keyPassphrase2Label.setText(Policy.bind("CVSSSH2PreferencePage.82"));
        this.keyPassphrase2Text = new Text((Composite)group, 2052);
        this.keyPassphrase2Text.setFont(group.getFont());
        this.keyPassphrase2Text.setEchoChar('*');
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyPassphrase2Text.setLayoutData((Object)gd);
        this.saveKeyPair = new Button((Composite)group, 0);
        this.saveKeyPair.setText(Policy.bind("CVSSSH2PreferencePage.83"));
        gd = new GridData(128);
        gd.horizontalSpan = columnSpan;
        this.saveKeyPair.setLayoutData((Object)gd);
        this.keyGenerate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSch jsch = JSchSession.getJSch();
                String _type = CVSSSH2PreferencePage.this.keyTypeCombo.getText();
                try {
                    int type = 0;
                    if (_type.equals(DSA)) {
                        type = 0;
                    } else if (_type.equals(RSA)) {
                        type = 1;
                    } else {
                        return;
                    }
                    CVSSSH2PreferencePage.this.kpair = KeyPair.genKeyPair((JSch)jsch, (int)type);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    CVSSSH2PreferencePage.this.kpairComment = String.valueOf(_type) + "-1024";
                    CVSSSH2PreferencePage.this.kpair.writePublicKey((OutputStream)out, CVSSSH2PreferencePage.this.kpairComment);
                    out.close();
                    CVSSSH2PreferencePage.this.publicKeyText.setText(out.toString());
                    CVSSSH2PreferencePage.this.keyFingerPrintText.setText(CVSSSH2PreferencePage.this.kpair.getFingerPrint());
                    CVSSSH2PreferencePage.this.keyCommentText.setText(CVSSSH2PreferencePage.this.kpairComment);
                    CVSSSH2PreferencePage.this.updateControls();
                }
                catch (IOException iOException) {
                }
                catch (JSchException jSchException) {}
                MessageBox mb = new MessageBox(CVSSSH2PreferencePage.this.getShell(), 34);
                mb.setText(Policy.bind("CVSSSH2PreferencePage.information"));
                mb.setMessage(String.valueOf(_type) + Policy.bind("CVSSSH2PreferencePage.85"));
                mb.open();
            }
        });
        this.saveKeyPair.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox mb;
                if (CVSSSH2PreferencePage.this.kpair == null) {
                    return;
                }
                String pass = CVSSSH2PreferencePage.this.keyPassphrase1Text.getText();
                if (!pass.equals(CVSSSH2PreferencePage.this.keyPassphrase2Text.getText())) {
                    MessageBox mb2 = new MessageBox(CVSSSH2PreferencePage.this.getShell(), 33);
                    mb2.setText(Policy.bind("CVSSSH2PreferencePage.error"));
                    mb2.setMessage(Policy.bind("CVSSSH2PreferencePage.86"));
                    mb2.open();
                    return;
                }
                if (pass.length() == 0) {
                    mb = new MessageBox(CVSSSH2PreferencePage.this.getShell(), 200);
                    mb.setText(Policy.bind("CVSSSH2PreferencePage.awrning"));
                    mb.setMessage(Policy.bind("CVSSSH2PreferencePage.87"));
                    if (mb.open() == 128) {
                        return;
                    }
                }
                CVSSSH2PreferencePage.this.kpair.setPassphrase(pass);
                CVSSSH2Plugin.getDefault().getPreferenceStore();
                String home = CVSSSH2PreferencePage.this.ssh2HomeText.getText();
                File _home = new File(home);
                if (!_home.exists()) {
                    mb = new MessageBox(CVSSSH2PreferencePage.this.getShell(), 196);
                    mb.setText(Policy.bind("CVSSSH2PreferencePage.question"));
                    mb.setMessage(String.valueOf(home) + Policy.bind("CVSSSH2PreferencePage.88"));
                    if (mb.open() == 128) {
                        return;
                    }
                    if (!_home.mkdirs()) {
                        return;
                    }
                }
                FileDialog fd = new FileDialog(CVSSSH2PreferencePage.this.getShell(), 8192);
                fd.setFilterPath(home);
                String file = CVSSSH2PreferencePage.this.kpair.getKeyType() == 1 ? "id_rsa" : "id_dsa";
                fd.setFileName(file);
                file = fd.open();
                if (file == null) {
                    return;
                }
                if (new File(file).exists()) {
                    mb = new MessageBox(CVSSSH2PreferencePage.this.getShell(), 200);
                    mb.setText(Policy.bind("CVSSSH2PreferencePage.warning"));
                    mb.setMessage(String.valueOf(file) + Policy.bind("CVSSSH2PreferencePage.91"));
                    if (mb.open() == 128) {
                        return;
                    }
                }
                boolean ok = true;
                try {
                    CVSSSH2PreferencePage.this.kpair.writePrivateKey(file);
                    CVSSSH2PreferencePage.this.kpair.writePublicKey(String.valueOf(file) + ".pub", CVSSSH2PreferencePage.this.kpairComment);
                }
                catch (Exception exception) {
                    ok = false;
                }
                if (ok) {
                    mb = new MessageBox(CVSSSH2PreferencePage.this.getShell(), 34);
                    mb.setText(Policy.bind("CVSSSH2PreferencePage.information"));
                    mb.setMessage(String.valueOf(Policy.bind("CVSSSH2PreferencePage.93")) + "\n" + Policy.bind("CVSSSH2PreferencePage.95") + file + "\n" + Policy.bind("CVSSSH2PreferencePage.97") + file + ".pub");
                    mb.open();
                }
            }
        });
        this.keyTypeCombo.add(DSA);
        this.keyTypeCombo.add(RSA);
        this.keyTypeCombo.select(0);
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result) {
            String home = this.ssh2HomeText.getText();
            File _home = new File(home);
            if (!_home.exists()) {
                MessageBox mb = new MessageBox(this.getShell(), 196);
                mb.setText(Policy.bind("CVSSSH2PreferencePage.question"));
                mb.setMessage(String.valueOf(home) + Policy.bind("CVSSSH2PreferencePage.99"));
                if (mb.open() == 64 && !_home.mkdirs()) {
                    mb = new MessageBox(this.getShell(), 33);
                    mb.setText(Policy.bind("CVSSSH2PreferencePage.error"));
                    mb.setMessage(String.valueOf(Policy.bind("CVSSSH2PreferencePage.100")) + home);
                    mb.open();
                    return false;
                }
            }
            IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
            store.setValue(KEY_SSH2HOME, home);
            store.setValue(KEY_PRIVATEKEY, this.privateKeyText.getText());
            store.setValue(KEY_PROXY, this.enableProxy.getSelection());
            store.setValue(KEY_PROXY_TYPE, this.proxyTypeCombo.getText());
            store.setValue(KEY_PROXY_HOST, this.proxyHostText.getText());
            store.setValue(KEY_PROXY_PORT, this.proxyPortText.getText());
            store.setValue(KEY_PROXY_AUTH, this.enableAuth.getSelection());
            store.setValue(KEY_PROXY_USER, this.proxyUserText.getText());
            store.setValue(KEY_PROXY_PASS, this.proxyPassText.getText());
            store.setValue(KEY_USE_SSH2, this.enableSSH2.getSelection());
        }
        CVSSSH2Plugin.getDefault().savePluginPreferences();
        return result;
    }

    public void performApply() {
        super.performApply();
        String home = this.ssh2HomeText.getText();
        File _home = new File(home);
        if (!_home.exists()) {
            MessageBox mb = new MessageBox(this.getShell(), 196);
            mb.setText(Policy.bind("CVSSSH2PreferencePage.question"));
            mb.setMessage(String.valueOf(home) + Policy.bind("CVSSSH2PreferencePage.101"));
            if (mb.open() == 64 && !_home.mkdirs()) {
                mb = new MessageBox(this.getShell(), 33);
                mb.setText(Policy.bind("CVSSSH2PreferencePage.error"));
                mb.setMessage(String.valueOf(Policy.bind("CVSSSH2PreferencePage.102")) + home);
                mb.open();
            }
        }
        IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
        store.setValue(KEY_SSH2HOME, this.ssh2HomeText.getText());
        store.setValue(KEY_PRIVATEKEY, this.privateKeyText.getText());
        store.setValue(KEY_PROXY, this.enableProxy.getSelection());
        store.setValue(KEY_PROXY_TYPE, this.proxyTypeCombo.getText());
        store.setValue(KEY_PROXY_HOST, this.proxyHostText.getText());
        store.setValue(KEY_PROXY_PORT, this.proxyPortText.getText());
        store.setValue(KEY_PROXY_AUTH, this.enableAuth.getSelection());
        store.setValue(KEY_PROXY_USER, this.proxyUserText.getText());
        store.setValue(KEY_PROXY_PASS, this.proxyPassText.getText());
    }

    protected void performDefaults() {
        super.performDefaults();
        this.enableProxy.setSelection(false);
        this.proxyHostText.setText("");
        this.proxyPortText.setText(HTTP_DEFAULT_PORT);
        this.proxyTypeCombo.select(0);
        this.enableAuth.setSelection(false);
        this.proxyUserText.setText("");
        this.proxyPassText.setText("");
        this.updateControls();
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }
}

