/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.team.internal.ccvs.ssh.Policy;
import org.eclipse.team.internal.ccvs.ssh.SSHPlugin;

public class KnownHosts {
    private String filename;

    public KnownHosts(String filename) {
        this.filename = filename;
    }

    public KnownHosts() {
        this.filename = KnownHosts.defaultFilename();
    }

    static String defaultFilename() {
        if (!BootLoader.getOS().equals("linux")) {
            return KnownHosts.internalFilename();
        }
        String HOME = System.getProperty("user.home");
        if (HOME == null) {
            return KnownHosts.internalFilename();
        }
        return String.valueOf(HOME) + "/.ssh/known_hosts";
    }

    private static String internalFilename() {
        return SSHPlugin.getPlugin().getStateLocation().append("known_hosts").toOSString();
    }

    public boolean verifyKey(String hostname, byte[] host_key_bits, BigInteger e, BigInteger n) {
        FileReader f;
        BigInteger nbits = new BigInteger(1, host_key_bits);
        try {
            f = new FileReader(this.filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.createHostFile();
            this.addHost(hostname, nbits, e, n);
            return true;
        }
        BufferedReader r = new BufferedReader(f);
        try {
            String line;
            while ((line = r.readLine()) != null) {
                String[] tokens;
                if (line.length() == 0 || line.startsWith("#") || (tokens = KnownHosts.subStrings(line)).length != 4 || !Character.isDigit(tokens[1].charAt(0)) || !tokens[0].equalsIgnoreCase(hostname)) continue;
                if (nbits.equals(new BigInteger(tokens[1])) && e.equals(new BigInteger(tokens[2])) && n.equals(new BigInteger(tokens[3]))) {
                    f.close();
                    return true;
                }
                f.close();
                return false;
            }
            f.close();
            this.addHost(hostname, nbits, e, n);
            return true;
        }
        catch (IOException ex) {
            SSHPlugin.log(4, Policy.bind("KnownHosts.8"), ex);
            return false;
        }
    }

    void addHost(String hostname, BigInteger key_bits, BigInteger e, BigInteger n) {
        try {
            FileWriter w = new FileWriter(KnownHosts.defaultFilename(), true);
            w.write(13);
            w.write(String.valueOf(hostname) + " " + key_bits.toString(10) + " " + e.toString(10) + " " + n.toString(10));
            w.close();
            String message = Policy.bind("Client.addedHostKey", new String[]{hostname, KnownHosts.defaultFilename()});
            SSHPlugin.log(1, message, null);
        }
        catch (IOException ex) {
            SSHPlugin.log(4, Policy.bind("KnownHosts.9"), ex);
        }
    }

    void createHostFile() {
        try {
            File file = new File(KnownHosts.defaultFilename());
            File parentDir = file.getParentFile();
            parentDir.mkdirs();
            file.createNewFile();
        }
        catch (IOException ee) {
            SSHPlugin.log(4, Policy.bind("KnownHosts.10"), ee);
        }
    }

    private static String[] subStrings(String s) {
        Vector v = KnownHosts.subStringsVector(s);
        Object[] substrings = new String[v.size()];
        v.copyInto(substrings);
        return substrings;
    }

    private static Vector subStringsVector(String s) {
        Vector<String> v = new Vector<String>();
        if ((s = s.trim()).length() == 0) {
            return v;
        }
        int first1 = s.indexOf(32);
        int first2 = s.indexOf(9);
        int first = first1 == -1 && first2 == -1 ? -1 : (first1 != -1 && first2 != -1 ? Math.min(first1, first2) : (first1 != -1 ? first1 : first2));
        if (first == -1) {
            v.add(s);
            return v;
        }
        v.add(s.substring(0, first));
        v.addAll(KnownHosts.subStringsVector(s.substring(first + 1)));
        return v;
    }
}

