/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SftpATTRS {
    static final int S_ISUID = 2048;
    static final int S_ISGID = 1024;
    static final int S_ISVTX = 512;
    static final int S_IRUSR = 256;
    static final int S_IWUSR = 128;
    static final int S_IXUSR = 64;
    static final int S_IREAD = 256;
    static final int S_IWRITE = 128;
    static final int S_IEXEC = 64;
    static final int S_IRGRP = 32;
    static final int S_IWGRP = 16;
    static final int S_IXGRP = 8;
    static final int S_IROTH = 4;
    static final int S_IWOTH = 2;
    static final int S_IXOTH = 1;
    public static final int SSH_FILEXFER_ATTR_SIZE = 1;
    public static final int SSH_FILEXFER_ATTR_UIDGID = 2;
    public static final int SSH_FILEXFER_ATTR_PERMISSIONS = 4;
    public static final int SSH_FILEXFER_ATTR_ACMODTIME = 8;
    public static final int SSH_FILEXFER_ATTR_EXTENDED = Integer.MIN_VALUE;
    static final int S_IFDIR = 16384;
    int flags = 0;
    long size;
    int uid;
    int gid;
    int permissions;
    int atime;
    int mtime;
    String[] extended = null;

    String getPermissionsString() {
        StringBuffer buf = new StringBuffer(10);
        if (this.isDir()) {
            buf.append('d');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 0x100) != 0) {
            buf.append('r');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 0x80) != 0) {
            buf.append('w');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 0x800) != 0) {
            buf.append('s');
        } else if ((this.permissions & 0x40) != 0) {
            buf.append('x');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 0x20) != 0) {
            buf.append('r');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 0x10) != 0) {
            buf.append('w');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 0x400) != 0) {
            buf.append('s');
        } else if ((this.permissions & 8) != 0) {
            buf.append('x');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 4) != 0) {
            buf.append('r');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 2) != 0) {
            buf.append('w');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 1) != 0) {
            buf.append('x');
        } else {
            buf.append('-');
        }
        return buf.toString();
    }

    public String getAtimeString() {
        SimpleDateFormat locale = new SimpleDateFormat();
        return locale.format(new Date(this.atime));
    }

    public String getMtimeString() {
        Date date = new Date((long)this.mtime * 1000L);
        return date.toString();
    }

    static SftpATTRS getATTR(Buffer buf) {
        int count;
        SftpATTRS attr = new SftpATTRS();
        attr.flags = buf.getInt();
        if ((attr.flags & 1) != 0) {
            attr.size = buf.getLong();
        }
        if ((attr.flags & 2) != 0) {
            attr.uid = buf.getInt();
            attr.gid = buf.getInt();
        }
        if ((attr.flags & 4) != 0) {
            attr.permissions = buf.getInt();
        }
        if ((attr.flags & 8) != 0) {
            attr.atime = buf.getInt();
        }
        if ((attr.flags & 8) != 0) {
            attr.mtime = buf.getInt();
        }
        if ((attr.flags & Integer.MIN_VALUE) != 0 && (count = buf.getInt()) > 0) {
            attr.extended = new String[count * 2];
            int i = 0;
            while (i < count) {
                attr.extended[i * 2] = new String(buf.getString());
                attr.extended[i * 2 + 1] = new String(buf.getString());
                ++i;
            }
        }
        return attr;
    }

    int length() {
        int len = 4;
        if ((this.flags & 1) != 0) {
            len += 8;
        }
        if ((this.flags & 2) != 0) {
            len += 8;
        }
        if ((this.flags & 4) != 0) {
            len += 4;
        }
        if ((this.flags & 8) != 0) {
            len += 8;
        }
        if ((this.flags & Integer.MIN_VALUE) != 0) {
            len += 4;
            int count = this.extended.length / 2;
            if (count > 0) {
                int i = 0;
                while (i < count) {
                    len += 4;
                    len += this.extended[i * 2].length();
                    len += 4;
                    len += this.extended[i * 2 + 1].length();
                    ++i;
                }
            }
        }
        return len;
    }

    void dump(Buffer buf) {
        int count;
        buf.putInt(this.flags);
        if ((this.flags & 1) != 0) {
            buf.putLong(this.size);
        }
        if ((this.flags & 2) != 0) {
            buf.putInt(this.uid);
            buf.putInt(this.gid);
        }
        if ((this.flags & 4) != 0) {
            buf.putInt(this.permissions);
        }
        if ((this.flags & 8) != 0) {
            buf.putInt(this.atime);
        }
        if ((this.flags & 8) != 0) {
            buf.putInt(this.mtime);
        }
        if ((this.flags & Integer.MIN_VALUE) != 0 && (count = this.extended.length / 2) > 0) {
            int i = 0;
            while (i < count) {
                buf.putString(this.extended[i * 2].getBytes());
                buf.putString(this.extended[i * 2 + 1].getBytes());
                ++i;
            }
        }
    }

    void setSIZE(long size) {
        this.flags |= 1;
        this.size = size;
    }

    void setUIDGID(int uid, int gid) {
        this.flags |= 2;
        this.uid = uid;
        this.gid = gid;
    }

    void setACMODTIME(int atime, int mtime) {
        this.flags |= 8;
        this.atime = atime;
        this.mtime = mtime;
    }

    void setPERMISSIONS(int permissions) {
        this.flags |= 4;
        this.permissions = permissions;
    }

    public boolean isDir() {
        return (this.flags & 4) != 0 && (this.permissions & 0x4000) != 0;
    }

    public int getFlags() {
        return this.flags;
    }

    public long getSize() {
        return this.size;
    }

    public int getUId() {
        return this.uid;
    }

    public int getGId() {
        return this.gid;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public int getATime() {
        return this.atime;
    }

    public int getMTime() {
        return this.mtime;
    }

    public String[] getExtended() {
        return this.extended;
    }

    public String toString() {
        return this.getPermissionsString() + " " + this.getUId() + " " + this.getGId() + " " + this.getSize() + " " + this.getMtimeString();
    }

    static {
        S_ISUID = 2048;
        S_ISGID = 1024;
        S_ISVTX = 512;
        S_IRUSR = 256;
        S_IWUSR = 128;
        S_IXUSR = 64;
        S_IREAD = 256;
        S_IWRITE = 128;
        S_IEXEC = 64;
        S_IRGRP = 32;
        S_IWGRP = 16;
        S_IXGRP = 8;
        S_IROTH = 4;
        S_IWOTH = 2;
        S_IXOTH = 1;
        SSH_FILEXFER_ATTR_SIZE = 1;
        SSH_FILEXFER_ATTR_UIDGID = 2;
        SSH_FILEXFER_ATTR_PERMISSIONS = 4;
        SSH_FILEXFER_ATTR_ACMODTIME = 8;
        SSH_FILEXFER_ATTR_EXTENDED = Integer.MIN_VALUE;
        S_IFDIR = 16384;
    }
}

