/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelForwardedTCPIP;
import com.jcraft.jsch.ChannelX11;
import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.Compression;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyExchange;
import com.jcraft.jsch.MAC;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.PortWatcher;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Random;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserAuth;
import com.jcraft.jsch.UserAuthKeyboardInteractive;
import com.jcraft.jsch.UserAuthNone;
import com.jcraft.jsch.UserAuthPassword;
import com.jcraft.jsch.UserAuthPublicKey;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;

public class Session
implements Runnable {
    private static final String version = "JSCH-0.1.12";
    static final int SSH_MSG_DISCONNECT = 1;
    static final int SSH_MSG_IGNORE = 2;
    static final int SSH_MSG_UNIMPLEMENTED = 3;
    static final int SSH_MSG_DEBUG = 4;
    static final int SSH_MSG_SERVICE_REQUEST = 5;
    static final int SSH_MSG_SERVICE_ACCEPT = 6;
    static final int SSH_MSG_KEXINIT = 20;
    static final int SSH_MSG_NEWKEYS = 21;
    static final int SSH_MSG_KEXDH_INIT = 30;
    static final int SSH_MSG_KEXDH_REPLY = 31;
    static final int SSH_MSG_USERAUTH_REQUEST = 50;
    static final int SSH_MSG_USERAUTH_FAILURE = 51;
    static final int SSH_MSG_USERAUTH_SUCCESS = 52;
    static final int SSH_MSG_USERAUTH_BANNER = 53;
    static final int SSH_MSG_USERAUTH_INFO_REQUEST = 60;
    static final int SSH_MSG_USERAUTH_INFO_RESPONSE = 61;
    static final int SSH_MSG_USERAUTH_PK_OK = 60;
    static final int SSH_MSG_GLOBAL_REQUEST = 80;
    static final int SSH_MSG_REQUEST_SUCCESS = 81;
    static final int SSH_MSG_REQUEST_FAILURE = 82;
    static final int SSH_MSG_CHANNEL_OPEN = 90;
    static final int SSH_MSG_CHANNEL_OPEN_CONFIRMATION = 91;
    static final int SSH_MSG_CHANNEL_OPEN_FAILURE = 92;
    static final int SSH_MSG_CHANNEL_WINDOW_ADJUST = 93;
    static final int SSH_MSG_CHANNEL_DATA = 94;
    static final int SSH_MSG_CHANNEL_EXTENDED_DATA = 95;
    static final int SSH_MSG_CHANNEL_EOF = 96;
    static final int SSH_MSG_CHANNEL_CLOSE = 97;
    static final int SSH_MSG_CHANNEL_REQUEST = 98;
    static final int SSH_MSG_CHANNEL_SUCCESS = 99;
    static final int SSH_MSG_CHANNEL_FAILURE = 100;
    private byte[] V_S;
    private byte[] V_C = "SSH-2.0-JSCH-0.1.12".getBytes();
    private byte[] I_C;
    private byte[] I_S;
    private byte[] K_S;
    private byte[] session_id;
    private byte[] IVc2s;
    private byte[] IVs2c;
    private byte[] Ec2s;
    private byte[] Es2c;
    private byte[] MACc2s;
    private byte[] MACs2c;
    private int seqi = 0;
    private int seqo = 0;
    private Cipher s2ccipher;
    private Cipher c2scipher;
    private MAC s2cmac;
    private MAC c2smac;
    private byte[] mac_buf;
    private Compression deflater;
    private Compression inflater;
    private IO io;
    private Socket socket;
    private int timeout = 0;
    private boolean isConnected = false;
    InputStream in = null;
    OutputStream out = null;
    static Random random;
    Buffer buf;
    Packet packet;
    SocketFactory socket_factory = null;
    private Hashtable config = null;
    private Proxy proxy = null;
    private UserInfo userinfo;
    String host = "127.0.0.1";
    int port = 22;
    String username = null;
    String password = null;
    JSch jsch;
    private boolean in_kex = false;
    int[] uncompress_len = new int[1];
    Runnable thread;

    Session(JSch jsch) throws JSchException {
        this.jsch = jsch;
        this.buf = new Buffer();
        this.packet = new Packet(this.buf);
        this.io = new IO();
    }

    public void connect() throws JSchException {
        if (random == null) {
            try {
                Class<?> c = Class.forName(this.getConfig("random"));
                random = (Random)c.newInstance();
            }
            catch (Exception e) {
                System.err.println("connect: random " + e);
            }
        }
        Packet.setRandom(random);
        try {
            int j;
            boolean pad = false;
            if (this.proxy == null) {
                this.proxy = this.jsch.getProxy(this.host);
                if (this.proxy != null) {
                    this.proxy.close();
                }
            }
            if (this.proxy == null) {
                OutputStream out;
                InputStream in;
                if (this.socket_factory == null) {
                    if (this.timeout == 0) {
                        this.socket = new Socket(this.host, this.port);
                    } else {
                        final Socket[] sockp = new Socket[1];
                        final Thread thread = Thread.currentThread();
                        final Exception[] ee = new Exception[1];
                        final boolean[] done = new boolean[]{false};
                        new Thread(new Runnable(){

                            public void run() {
                                try {
                                    sockp[0] = new Socket(Session.this.host, Session.this.port);
                                    if (done[0]) {
                                        sockp[0].close();
                                    } else {
                                        thread.interrupt();
                                    }
                                }
                                catch (Exception e) {
                                    ee[0] = e;
                                }
                            }
                        }).start();
                        try {
                            Thread.sleep(this.timeout);
                        }
                        catch (Exception eee) {
                            // empty catch block
                        }
                        done[0] = true;
                        if (sockp[0] != null) {
                            this.socket = sockp[0];
                        } else {
                            String message = "socket is not established";
                            if (ee[0] != null) {
                                message = ee[0].toString();
                            }
                            throw new JSchException(message);
                        }
                    }
                    in = this.socket.getInputStream();
                    out = this.socket.getOutputStream();
                } else {
                    this.socket = this.socket_factory.createSocket(this.host, this.port);
                    in = this.socket_factory.getInputStream(this.socket);
                    out = this.socket_factory.getOutputStream(this.socket);
                }
                if (this.timeout > 0) {
                    this.socket.setSoTimeout(this.timeout);
                }
                this.socket.setTcpNoDelay(true);
                this.io.setInputStream(in);
                this.io.setOutputStream(out);
            } else {
                this.proxy.connect(this, this.host, this.port);
                this.io.setInputStream(this.proxy.getInputStream());
                this.io.setOutputStream(this.proxy.getOutputStream());
            }
            this.isConnected = true;
            int i = 0;
            do {
                j = this.io.getByte();
                this.buf.buffer[i] = (byte)j;
                ++i;
            } while (j != 10);
            if (this.buf.buffer[i - 1] == 10) {
                if (this.buf.buffer[--i - 1] == 13) {
                    --i;
                }
            } else {
                throw new JSchException("invalid server's version string");
            }
            this.V_S = new byte[i];
            System.arraycopy(this.buf.buffer, 0, this.V_S, 0, i);
            this.io.put(this.V_C, 0, this.V_C.length);
            this.io.put("\n".getBytes(), 0, 1);
            this.buf = this.read(this.buf);
            if (this.buf.buffer[5] != 20) {
                throw new JSchException("invalid protocol: " + this.buf.buffer[5]);
            }
            KeyExchange kex = this.receive_kexinit(this.buf);
            do {
                this.buf = this.read(this.buf);
                if (kex.getState() == this.buf.buffer[5]) {
                    boolean result = kex.next(this.buf);
                    if (result) continue;
                    throw new JSchException("verify: " + result);
                }
                throw new JSchException("invalid protocol(kex): " + this.buf.buffer[5]);
            } while (kex.getState() != 0);
            this.checkHost(this.host, kex);
            this.buf = this.read(this.buf);
            if (this.buf.buffer[5] != 21) {
                throw new JSchException("invalid protocol(newkyes): " + this.buf.buffer[5]);
            }
            this.receive_newkeys(this.buf, kex);
            boolean auth = false;
            UserAuthNone usn = new UserAuthNone(this.userinfo);
            auth = usn.start(this);
            String methods = usn.getMethods();
            if (methods == null) {
                methods = "publickey,password,keyboard-interactive";
            }
            while (!auth && methods != null && methods.length() > 0) {
                UserAuth us = null;
                if (methods.startsWith("publickey")) {
                    if (this.jsch.identities.size() > 0) {
                        us = new UserAuthPublicKey(this.userinfo);
                    }
                } else if (methods.startsWith("keyboard-interactive")) {
                    if (this.userinfo instanceof UIKeyboardInteractive) {
                        us = new UserAuthKeyboardInteractive(this.userinfo);
                    }
                } else if (methods.startsWith("password")) {
                    us = new UserAuthPassword(this.userinfo);
                }
                if (us != null) {
                    try {
                        auth = ((UserAuth)us).start(this);
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                }
                if (auth) continue;
                int comma = methods.indexOf(",");
                if (comma == -1) break;
                methods = methods.substring(comma + 1);
            }
            if (auth) {
                new Thread(this).start();
                return;
            }
            throw new JSchException("Auth fail");
        }
        catch (Exception e) {
            if (this.isConnected) {
                try {
                    this.packet.reset();
                    this.buf.putByte((byte)1);
                    this.buf.putInt(3);
                    this.buf.putString(e.toString().getBytes());
                    this.buf.putString("en".getBytes());
                    this.write(this.packet);
                    this.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.isConnected = false;
            if (e instanceof JSchException) {
                throw (JSchException)e;
            }
            throw new JSchException("Session.connect: " + e);
        }
    }

    private KeyExchange receive_kexinit(Buffer buf) throws Exception {
        int j = buf.getInt();
        if (j != buf.getLength()) {
            buf.getByte();
            this.I_S = new byte[buf.index - 5];
        } else {
            this.I_S = new byte[j - 1 - buf.getByte()];
        }
        System.arraycopy(buf.buffer, buf.s, this.I_S, 0, this.I_S.length);
        this.send_kexinit();
        String[] guess = KeyExchange.guess(this.I_S, this.I_C);
        if (guess == null) {
            throw new JSchException("Algorithm negotiation fail");
        }
        KeyExchange kex = null;
        try {
            Class<?> c = Class.forName(this.getConfig(guess[0]));
            kex = (KeyExchange)c.newInstance();
        }
        catch (Exception e) {
            System.err.println("kex: " + e);
        }
        kex.guess = guess;
        kex.init(this, this.V_S, this.V_C, this.I_S, this.I_C);
        return kex;
    }

    public void rekey() throws Exception {
        this.send_kexinit();
    }

    private void send_kexinit() throws Exception {
        if (this.in_kex) {
            return;
        }
        this.in_kex = true;
        this.packet.reset();
        this.buf.putByte((byte)20);
        random.fill(this.buf.buffer, this.buf.index, 16);
        this.buf.skip(16);
        this.buf.putString(this.getConfig("kex").getBytes());
        this.buf.putString(this.getConfig("server_host_key").getBytes());
        this.buf.putString(this.getConfig("cipher.c2s").getBytes());
        this.buf.putString(this.getConfig("cipher.s2c").getBytes());
        this.buf.putString(this.getConfig("mac.c2s").getBytes());
        this.buf.putString(this.getConfig("mac.s2c").getBytes());
        this.buf.putString(this.getConfig("compression.c2s").getBytes());
        this.buf.putString(this.getConfig("compression.s2c").getBytes());
        this.buf.putString(this.getConfig("lang.c2s").getBytes());
        this.buf.putString(this.getConfig("lang.s2c").getBytes());
        this.buf.putByte((byte)0);
        this.buf.putInt(0);
        this.buf.setOffSet(5);
        this.I_C = new byte[this.buf.getLength()];
        this.buf.getByte(this.I_C);
        this.write(this.packet);
    }

    private void send_newkeys() throws Exception {
        this.packet.reset();
        this.buf.putByte((byte)21);
        this.write(this.packet);
    }

    private void checkHost(String host, KeyExchange kex) throws JSchException {
        String shkc = this.getConfig("StrictHostKeyChecking");
        byte[] K_S = kex.getHostKey();
        int i = this.jsch.getKnownHosts().check(host, K_S);
        if ((shkc.equals("ask") || shkc.equals("yes")) && i == 2) {
            String message = "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n@    WARNING: REMOTE HOST IDENTIFICATION HAS CHANGED!     @\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\nIT IS POSSIBLE THAT SOMEONE IS DOING SOMETHING NASTY!      \nSomeone could be eavesdropping on you right now (man-in-the-middle attack)!\nIt is also possible that the " + kex.getKeyType() + " host key has just been changed.\n" + "The fingerprint for the " + kex.getKeyType() + " key sent by the remote host is\n" + kex.getFingerPrint() + ".\n" + "Please contact your system administrator.\n" + "Add correct host key in " + this.jsch.getKnownHosts().getKnownHostsFile() + " to get rid of this message.";
            if (this.userinfo != null) {
                this.userinfo.showMessage(message);
            }
            throw new JSchException("HostKey has been changed");
        }
        boolean insert = false;
        if ((shkc.equals("ask") || shkc.equals("yes")) && i != 0) {
            if (shkc.equals("yes")) {
                throw new JSchException("reject HostKey");
            }
            if (this.userinfo != null) {
                boolean foo = this.userinfo.promptYesNo("The authenticity of host '" + host + "' can't be established.\n" + kex.getKeyType() + " key fingerprint is " + kex.getFingerPrint() + ".\n" + "Are you sure you want to continue connecting (yes/no)?");
                if (!foo) {
                    throw new JSchException("reject HostKey");
                }
                insert = true;
            } else {
                if (i == 1) {
                    throw new JSchException("UnknownHostKey");
                }
                throw new JSchException("HostKey has been changed.");
            }
        }
        if (shkc.equals("no") && i == 1) {
            insert = true;
        }
        if (insert) {
            this.jsch.getKnownHosts().insert(host, K_S);
            String bar = this.jsch.getKnownHosts().getKnownHostsFile();
            if (bar != null) {
                boolean foo = true;
                if (!new File(bar).exists()) {
                    foo = false;
                    if (this.userinfo != null) {
                        foo = this.userinfo.promptYesNo(this.jsch.getKnownHosts().getKnownHostsFile() + " does not exist.\n" + "Are you sure you want to create it (yes/no)?");
                    }
                }
                if (foo) {
                    try {
                        this.jsch.getKnownHosts().sync(bar);
                    }
                    catch (Exception e) {
                        System.out.println("sync known_hosts: " + e);
                    }
                }
            }
        }
    }

    public Channel openChannel(String type) throws JSchException {
        if (!this.isConnected) {
            throw new JSchException("session is down");
        }
        try {
            Channel channel = Channel.getChannel(type);
            this.addChannel(channel);
            channel.init();
            return channel;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void encode(Packet packet) throws Exception {
        if (this.deflater != null) {
            packet.buffer.index = this.deflater.compress(packet.buffer.buffer, 5, packet.buffer.index);
        }
        packet.padding();
        byte[] mac = null;
        if (this.c2scipher != null) {
            byte pad = packet.buffer.buffer[4];
            random.fill(packet.buffer.buffer, packet.buffer.index - pad, pad);
        }
        if (this.c2smac != null) {
            this.c2smac.update(this.seqo);
            this.c2smac.update(packet.buffer.buffer, 0, packet.buffer.index);
            mac = this.c2smac.doFinal();
        }
        if (this.c2scipher != null) {
            byte[] buf = packet.buffer.buffer;
            this.c2scipher.update(buf, 0, packet.buffer.index, buf, 0);
        }
        if (mac != null) {
            packet.buffer.putByte(mac);
        }
    }

    public Buffer read(Buffer buf) throws Exception {
        int j = 0;
        while (true) {
            byte[] language_tag;
            int type;
            buf.reset();
            this.io.getByte(buf.buffer, buf.index, 8);
            buf.index += 8;
            if (this.s2ccipher != null) {
                this.s2ccipher.update(buf.buffer, 0, 8, buf.buffer, 0);
            }
            j = buf.buffer[0] << 24 & 0xFF000000 | buf.buffer[1] << 16 & 0xFF0000 | buf.buffer[2] << 8 & 0xFF00 | buf.buffer[3] & 0xFF;
            this.io.getByte(buf.buffer, buf.index, j - 4);
            buf.index += j - 4;
            if (this.s2ccipher != null) {
                this.s2ccipher.update(buf.buffer, 8, j - 4, buf.buffer, 8);
            }
            if (this.s2cmac != null) {
                this.s2cmac.update(this.seqi);
                this.s2cmac.update(buf.buffer, 0, buf.index);
                byte[] result = this.s2cmac.doFinal();
                this.io.getByte(this.mac_buf, 0, this.mac_buf.length);
                if (!Arrays.equals(result, this.mac_buf)) {
                    System.out.println("mac error");
                    throw new IOException("MAC Error");
                }
            }
            ++this.seqi;
            if (this.inflater != null) {
                byte pad = buf.buffer[4];
                this.uncompress_len[0] = buf.index - 5 - pad;
                byte[] foo = this.inflater.uncompress(buf.buffer, 5, this.uncompress_len);
                if (foo != null) {
                    buf.buffer = foo;
                    buf.index = 5 + this.uncompress_len[0];
                } else {
                    System.err.println("fail in inflater");
                    break;
                }
            }
            if ((type = buf.buffer[5] & 0xFF) == 1) {
                buf.rewind();
                buf.getInt();
                buf.getShort();
                int reason_code = buf.getInt();
                byte[] description = buf.getString();
                language_tag = buf.getString();
                System.err.println("SSH_MSG_DISCONNECT: " + reason_code + " " + new String(description) + " " + new String(language_tag));
                throw new JSchException("SSH_MSG_DISCONNECT: " + reason_code + " " + new String(description) + " " + new String(language_tag));
            }
            if (type == 2) continue;
            if (type == 4) {
                buf.rewind();
                buf.getInt();
                buf.getShort();
                byte always_display = (byte)buf.getByte();
                byte[] message = buf.getString();
                language_tag = buf.getString();
                System.err.println("SSH_MSG_DEBUG: " + new String(message) + " " + new String(language_tag));
                continue;
            }
            if (type != 93) break;
            buf.rewind();
            buf.getInt();
            buf.getShort();
            Channel c = Channel.getChannel(buf.getInt(), this);
            if (c == null) continue;
            c.addRemoteWindowSize(buf.getInt());
        }
        buf.rewind();
        return buf;
    }

    byte[] getSessionId() {
        return this.session_id;
    }

    private void receive_newkeys(Buffer buf, KeyExchange kex) throws Exception {
        this.send_newkeys();
        this.in_kex = false;
        this.updateKeys(kex);
    }

    private void updateKeys(KeyExchange kex) throws Exception {
        int j;
        byte[] K = kex.getK();
        byte[] H = kex.getH();
        HASH hash = kex.getHash();
        String[] guess = kex.guess;
        if (this.session_id == null) {
            this.session_id = new byte[H.length];
            System.arraycopy(H, 0, this.session_id, 0, H.length);
        }
        this.buf.reset();
        this.buf.putMPInt(K);
        this.buf.putByte(H);
        this.buf.putByte((byte)65);
        this.buf.putByte(this.session_id);
        hash.update(this.buf.buffer, 0, this.buf.index);
        this.IVc2s = hash.digest();
        int n = j = this.buf.index - this.session_id.length - 1;
        this.buf.buffer[n] = (byte)(this.buf.buffer[n] + 1);
        hash.update(this.buf.buffer, 0, this.buf.index);
        this.IVs2c = hash.digest();
        int n2 = j;
        this.buf.buffer[n2] = (byte)(this.buf.buffer[n2] + 1);
        hash.update(this.buf.buffer, 0, this.buf.index);
        this.Ec2s = hash.digest();
        int n3 = j;
        this.buf.buffer[n3] = (byte)(this.buf.buffer[n3] + 1);
        hash.update(this.buf.buffer, 0, this.buf.index);
        this.Es2c = hash.digest();
        int n4 = j;
        this.buf.buffer[n4] = (byte)(this.buf.buffer[n4] + 1);
        hash.update(this.buf.buffer, 0, this.buf.index);
        this.MACc2s = hash.digest();
        int n5 = j;
        this.buf.buffer[n5] = (byte)(this.buf.buffer[n5] + 1);
        hash.update(this.buf.buffer, 0, this.buf.index);
        this.MACs2c = hash.digest();
        try {
            byte[] bar;
            Object foo;
            Class<?> c = Class.forName(this.getConfig(guess[3]));
            this.s2ccipher = (Cipher)c.newInstance();
            while (this.s2ccipher.getBlockSize() > this.Es2c.length) {
                this.buf.reset();
                this.buf.putMPInt(K);
                this.buf.putByte(H);
                this.buf.putByte(this.Es2c);
                hash.update(this.buf.buffer, 0, this.buf.index);
                foo = hash.digest();
                bar = new byte[this.Es2c.length + ((byte[])foo).length];
                System.arraycopy(this.Es2c, 0, bar, 0, this.Es2c.length);
                System.arraycopy(foo, 0, bar, this.Es2c.length, ((byte[])foo).length);
                this.Es2c = bar;
            }
            this.s2ccipher.init(1, this.Es2c, this.IVs2c);
            c = Class.forName(this.getConfig(guess[5]));
            this.s2cmac = (MAC)c.newInstance();
            this.s2cmac.init(this.MACs2c);
            this.mac_buf = new byte[this.s2cmac.getBlockSize()];
            c = Class.forName(this.getConfig(guess[2]));
            this.c2scipher = (Cipher)c.newInstance();
            while (this.c2scipher.getBlockSize() > this.Ec2s.length) {
                this.buf.reset();
                this.buf.putMPInt(K);
                this.buf.putByte(H);
                this.buf.putByte(this.Ec2s);
                hash.update(this.buf.buffer, 0, this.buf.index);
                foo = hash.digest();
                bar = new byte[this.Ec2s.length + ((byte[])foo).length];
                System.arraycopy(this.Ec2s, 0, bar, 0, this.Ec2s.length);
                System.arraycopy(foo, 0, bar, this.Ec2s.length, ((byte[])foo).length);
                this.Ec2s = bar;
            }
            this.c2scipher.init(0, this.Ec2s, this.IVc2s);
            c = Class.forName(this.getConfig(guess[4]));
            this.c2smac = (MAC)c.newInstance();
            this.c2smac.init(this.MACc2s);
            if (!guess[6].equals("none")) {
                foo = this.getConfig(guess[6]);
                if (foo != null) {
                    try {
                        c = Class.forName((String)foo);
                        this.deflater = (Compression)c.newInstance();
                        this.deflater.init(1, 6);
                    }
                    catch (Exception ee) {
                        System.err.println((String)foo + " isn't accessible.");
                    }
                }
            } else if (this.deflater != null) {
                this.deflater = null;
            }
            if (!guess[7].equals("none")) {
                foo = this.getConfig(guess[7]);
                if (foo != null) {
                    try {
                        c = Class.forName((String)foo);
                        this.inflater = (Compression)c.newInstance();
                        this.inflater.init(0, 0);
                    }
                    catch (Exception ee) {
                        System.err.println((String)foo + " isn't accessible.");
                    }
                }
            } else if (this.inflater != null) {
                this.inflater = null;
            }
        }
        catch (Exception e) {
            System.err.println("updatekeys: " + e);
        }
    }

    public void write(Packet packet, Channel c, int length) throws Exception {
        while (true) {
            if (c.rwsize > length) {
                c.rwsize -= length;
                break;
            }
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {}
        }
        this.write(packet);
    }

    public synchronized void write(Packet packet) throws Exception {
        this.encode(packet);
        if (this.io != null) {
            this.io.put(packet);
            ++this.seqo;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.thread = this;
        buf = new Buffer();
        packet = new Packet(buf);
        i = 0;
        start = new int[1];
        length = new int[1];
        kex = null;
        try lbl-1000:
        // 20 sources

        {
            block21: while (this.thread != null) {
                buf = this.read(buf);
                msgType = buf.buffer[5] & 255;
                if (kex != null && kex.getState() == msgType) {
                    result = kex.next(buf);
                    if (result) continue;
                    throw new JSchException("verify: " + result);
                }
                switch (msgType) {
                    case 20: {
                        System.out.println("KEXINIT");
                        kex = this.receive_kexinit(buf);
                        ** break;
                    }
                    case 21: {
                        System.out.println("NEWKEYS");
                        this.receive_newkeys(buf, kex);
                        kex = null;
                        ** break;
                    }
                    case 94: {
                        buf.getInt();
                        buf.getByte();
                        buf.getByte();
                        i = buf.getInt();
                        channel = Channel.getChannel(i, this);
                        if (channel == null) {
                            // empty if block
                        }
                        foo = buf.getString(start, length);
                        try {
                            channel.write(foo, start[0], length[0]);
                        }
                        catch (Exception e) {
                            try {
                                channel.disconnect();
                            }
                            catch (Exception ee) {}
                            continue block21;
                        }
                        len = length[0];
                        channel.setLocalWindowSize(channel.lwsize - len);
                        if (channel.lwsize >= channel.lwsize_max / 2) continue block21;
                        packet.reset();
                        buf.putByte((byte)93);
                        buf.putInt(channel.getRecipient());
                        buf.putInt(channel.lwsize_max - channel.lwsize);
                        this.write(packet);
                        channel.setLocalWindowSize(channel.lwsize_max);
                        ** break;
                    }
                    case 95: {
                        buf.getInt();
                        buf.getShort();
                        i = buf.getInt();
                        channel = Channel.getChannel(i, this);
                        if (channel == null) {
                            // empty if block
                        }
                        buf.getInt();
                        foo = buf.getString(start, length);
                        channel.write_ext(foo, start[0], length[0]);
                        len = length[0];
                        channel.setLocalWindowSize(channel.lwsize - len);
                        if (channel.lwsize >= channel.lwsize_max / 2) continue block21;
                        packet.reset();
                        buf.putByte((byte)93);
                        buf.putInt(channel.getRecipient());
                        buf.putInt(channel.lwsize_max - channel.lwsize);
                        this.write(packet);
                        channel.setLocalWindowSize(channel.lwsize_max);
                        ** break;
                    }
                    case 93: {
                        buf.getInt();
                        buf.getShort();
                        i = buf.getInt();
                        channel = Channel.getChannel(i, this);
                        if (channel == null) {
                            // empty if block
                        }
                        channel.addRemoteWindowSize(buf.getInt());
                        ** break;
                    }
                    case 96: {
                        buf.getInt();
                        buf.getShort();
                        i = buf.getInt();
                        channel = Channel.getChannel(i, this);
                        if (channel == null) continue block21;
                        channel.eof();
                        ** break;
                    }
                    case 97: {
                        buf.getInt();
                        buf.getShort();
                        i = buf.getInt();
                        channel = Channel.getChannel(i, this);
                        if (channel == null) continue block21;
                        channel.disconnect();
                        ** break;
                    }
                    case 91: {
                        buf.getInt();
                        buf.getShort();
                        i = buf.getInt();
                        channel = Channel.getChannel(i, this);
                        if (channel == null) {
                            // empty if block
                        }
                        channel.setRecipient(buf.getInt());
                        channel.setRemoteWindowSize(buf.getInt());
                        channel.setRemotePacketSize(buf.getInt());
                        ** break;
                    }
                    case 98: {
                        buf.getInt();
                        buf.getShort();
                        i = buf.getInt();
                        foo = buf.getString();
                        v0 = reply = buf.getByte() != 0;
                        channel = Channel.getChannel(i, this);
                        if (channel == null) continue block21;
                        reply_type = 100;
                        if (new String(foo).equals("exit-status")) {
                            i = buf.getInt();
                            channel.setExitStatus(i);
                            reply_type = 99;
                        }
                        if (!reply) continue block21;
                        packet.reset();
                        buf.putByte((byte)reply_type);
                        buf.putInt(channel.getRecipient());
                        this.write(packet);
                        ** break;
                    }
                    case 90: {
                        buf.getInt();
                        buf.getShort();
                        foo = buf.getString();
                        ctyp = new String(foo);
                        if (!"forwarded-tcpip".equals(ctyp) && !"x11".equals(ctyp)) {
                            System.out.println("Session.run: CHANNEL OPEN " + ctyp);
                            throw new IOException("Session.run: CHANNEL OPEN " + ctyp);
                        }
                        channel = Channel.getChannel(ctyp);
                        this.addChannel(channel);
                        channel.getData(buf);
                        channel.init();
                        packet.reset();
                        buf.putByte((byte)91);
                        buf.putInt(channel.getRecipient());
                        buf.putInt(channel.id);
                        buf.putInt(channel.lwsize);
                        buf.putInt(channel.lmpsize);
                        this.write(packet);
                        new Thread(channel).start();
                        ** break;
                    }
                }
                System.out.println("Session.run: unsupported type " + msgType);
                throw new IOException("Unknown SSH message type " + msgType);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.disconnect();
        }
        catch (NullPointerException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        this.isConnected = false;
    }

    public void disconnect() {
        if (!this.isConnected) {
            return;
        }
        this.isConnected = false;
        Channel.eof(this);
        PortWatcher.delPort(this);
        ChannelForwardedTCPIP.delPort(this);
        this.thread = null;
        try {
            if (this.io != null) {
                if (this.io.in != null) {
                    this.io.in.close();
                }
                if (this.io.out != null) {
                    this.io.out.close();
                }
            }
            if (this.proxy == null) {
                if (this.socket != null) {
                    this.socket.close();
                }
            } else {
                this.proxy.close();
                this.proxy = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.io = null;
        this.socket = null;
        this.jsch.pool.removeElement(this);
    }

    public void setPortForwardingL(int lport, String host, int rport) throws JSchException {
        this.setPortForwardingL("127.0.0.1", lport, host, rport);
    }

    public void setPortForwardingL(String boundaddress, int lport, String host, int rport) throws JSchException {
        PortWatcher pw = PortWatcher.addPort(this, boundaddress, lport, host, rport);
        new Thread(pw).start();
    }

    public void delPortForwardingL(int lport) throws JSchException {
        PortWatcher.delPort(this, lport);
    }

    public String[] getPortForwardingL() throws JSchException {
        return PortWatcher.getPortForwarding(this);
    }

    public void setPortForwardingR(int rport, String host, int lport) throws JSchException {
        ChannelForwardedTCPIP.addPort(this, rport, host, lport);
        Buffer buf = new Buffer(100);
        Packet packet = new Packet(buf);
        try {
            packet.reset();
            buf.putByte((byte)80);
            buf.putString("tcpip-forward".getBytes());
            buf.putByte((byte)0);
            buf.putString("0.0.0.0".getBytes());
            buf.putInt(rport);
            this.write(packet);
        }
        catch (Exception e) {
            throw new JSchException(e.toString());
        }
    }

    public void delPortForwardingR(int rport) throws JSchException {
        ChannelForwardedTCPIP.delPort(this, rport);
    }

    void addChannel(Channel channel) {
        channel.session = this;
    }

    public String getConfig(String name) {
        String foo = null;
        if (this.config != null && (foo = (String)this.config.get(name)) instanceof String) {
            return foo;
        }
        foo = this.jsch.getConfig(name);
        if (foo instanceof String) {
            return foo;
        }
        return null;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    void setUserName(String foo) {
        this.username = foo;
    }

    public void setPassword(String foo) {
        this.password = foo;
    }

    public void setUserInfo(UserInfo userinfo) {
        this.userinfo = userinfo;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setX11Host(String host) {
        ChannelX11.setHost(host);
    }

    public void setX11Port(int port) {
        ChannelX11.setPort(port);
    }

    public void setX11Cookie(String cookie) {
        ChannelX11.setCookie(cookie);
    }

    public void setConfig(Hashtable foo) {
        if (this.config == null) {
            this.config = new Hashtable();
        }
        Enumeration e = foo.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.config.put(key, (String)foo.get(key));
        }
    }

    public void setSocketFactory(SocketFactory foo) {
        this.socket_factory = foo;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int foo) throws JSchException {
        if (this.socket == null) {
            if (foo < 0) {
                throw new JSchException("invalid timeout value");
            }
            this.timeout = foo;
            return;
        }
        try {
            this.socket.setSoTimeout(foo);
            this.timeout = foo;
        }
        catch (Exception e) {
            throw new JSchException(e.toString());
        }
    }

    static {
        version = version;
        SSH_MSG_DISCONNECT = 1;
        SSH_MSG_IGNORE = 2;
        SSH_MSG_UNIMPLEMENTED = 3;
        SSH_MSG_DEBUG = 4;
        SSH_MSG_SERVICE_REQUEST = 5;
        SSH_MSG_SERVICE_ACCEPT = 6;
        SSH_MSG_KEXINIT = 20;
        SSH_MSG_NEWKEYS = 21;
        SSH_MSG_KEXDH_INIT = 30;
        SSH_MSG_KEXDH_REPLY = 31;
        SSH_MSG_USERAUTH_REQUEST = 50;
        SSH_MSG_USERAUTH_FAILURE = 51;
        SSH_MSG_USERAUTH_SUCCESS = 52;
        SSH_MSG_USERAUTH_BANNER = 53;
        SSH_MSG_USERAUTH_INFO_REQUEST = 60;
        SSH_MSG_USERAUTH_INFO_RESPONSE = 61;
        SSH_MSG_USERAUTH_PK_OK = 60;
        SSH_MSG_GLOBAL_REQUEST = 80;
        SSH_MSG_REQUEST_SUCCESS = 81;
        SSH_MSG_REQUEST_FAILURE = 82;
        SSH_MSG_CHANNEL_OPEN = 90;
        SSH_MSG_CHANNEL_OPEN_CONFIRMATION = 91;
        SSH_MSG_CHANNEL_OPEN_FAILURE = 92;
        SSH_MSG_CHANNEL_WINDOW_ADJUST = 93;
        SSH_MSG_CHANNEL_DATA = 94;
        SSH_MSG_CHANNEL_EXTENDED_DATA = 95;
        SSH_MSG_CHANNEL_EOF = 96;
        SSH_MSG_CHANNEL_CLOSE = 97;
        SSH_MSG_CHANNEL_REQUEST = 98;
        SSH_MSG_CHANNEL_SUCCESS = 99;
        SSH_MSG_CHANNEL_FAILURE = 100;
    }
}

