/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

class PortWatcher
implements Runnable {
    private static Vector pool = new Vector();
    Session session;
    int lport;
    int rport;
    String host;
    String boundaddress;
    ServerSocket ss;
    Runnable thread;

    static String[] getPortForwarding(Session session) {
        Vector<String> foo = new Vector<String>();
        int i = 0;
        while (i < pool.size()) {
            PortWatcher p = (PortWatcher)pool.elementAt(i);
            if (p.session == session) {
                foo.addElement(p.lport + ":" + p.host + ":" + p.rport);
            }
            ++i;
        }
        String[] bar = new String[foo.size()];
        int i2 = 0;
        while (i2 < foo.size()) {
            bar[i2] = (String)foo.elementAt(i2);
            ++i2;
        }
        return bar;
    }

    static PortWatcher getPort(Session session, int lport) {
        int i = 0;
        while (i < pool.size()) {
            PortWatcher p = (PortWatcher)pool.elementAt(i);
            if (p.session == session && p.lport == lport) {
                return p;
            }
            ++i;
        }
        return null;
    }

    static PortWatcher addPort(Session session, String address, int lport, String host, int rport) throws JSchException {
        if (PortWatcher.getPort(session, lport) != null) {
            throw new JSchException("PortForwardingL: local port " + lport + " is already registered.");
        }
        PortWatcher pw = new PortWatcher(session, address, lport, host, rport);
        pool.addElement(pw);
        return pw;
    }

    static void delPort(Session session, int lport) throws JSchException {
        PortWatcher pw = PortWatcher.getPort(session, lport);
        if (pw == null) {
            throw new JSchException("PortForwardingL: local port " + lport + " is not registered.");
        }
        pw.delete();
        pool.removeElement(pw);
    }

    static void delPort(Session session) {
        int i = 0;
        while (i < pool.size()) {
            PortWatcher p = (PortWatcher)pool.elementAt(i);
            if (p.session == session) {
                p.delete();
                pool.removeElement(p);
                --i;
            }
            ++i;
        }
    }

    PortWatcher(Session session, String boundaddress, int lport, String host, int rport) throws JSchException {
        this.session = session;
        this.boundaddress = boundaddress;
        this.lport = lport;
        this.host = host;
        this.rport = rport;
        try {
            this.ss = new ServerSocket(lport, 0, InetAddress.getByName(this.boundaddress));
        }
        catch (Exception e) {
            System.out.println(e);
            throw new JSchException("PortForwardingL: local port " + lport + " cannot be bound.");
        }
    }

    public void run() {
        Buffer buf = new Buffer(300);
        Packet packet = new Packet(buf);
        this.thread = this;
        try {
            while (this.thread != null) {
                Socket socket = this.ss.accept();
                socket.setTcpNoDelay(true);
                InputStream in = socket.getInputStream();
                OutputStream out = socket.getOutputStream();
                ChannelDirectTCPIP channel = new ChannelDirectTCPIP();
                channel.init();
                channel.setInputStream(in);
                channel.setOutputStream(out);
                this.session.addChannel(channel);
                channel.setHost(this.host);
                channel.setPort(this.rport);
                channel.setOrgIPAddress(socket.getInetAddress().getHostAddress());
                channel.setOrgPort(socket.getPort());
                channel.connect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void delete() {
        this.thread = null;
        try {
            this.ss.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

