/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Util;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

class KnownHosts {
    private static final String _known_hosts = "known_hosts";
    static final int OK = 0;
    static final int NOT_INCLUDED = 1;
    static final int CHANGED = 2;
    static final int SSHDSS = 0;
    static final int SSHRSA = 1;
    private String known_hosts = null;
    private Vector pool = new Vector();
    static final byte[] space;
    static final byte[] sshdss;
    static final byte[] sshrsa;
    static final byte[] cr;

    KnownHosts() {
    }

    void setKnownHosts(String foo) {
        this.known_hosts = foo;
        StringBuffer sb = new StringBuffer();
        try {
            FileInputStream fis = new FileInputStream(this.known_hosts);
            block2: while (true) {
                int i;
                sb.setLength(0);
                while ((i = fis.read()) != -1) {
                    if (i != 32) {
                        sb.append((char)i);
                        continue;
                    }
                    String host = sb.toString();
                    sb.setLength(0);
                    while ((i = fis.read()) != -1) {
                        int type;
                        if (i == 32) {
                            type = sb.toString().equals("ssh-dss") ? 0 : 1;
                        } else {
                            sb.append((char)i);
                            continue;
                        }
                        sb.setLength(0);
                        while ((i = fis.read()) != -1) {
                            if (i == 13) continue;
                            if (i != 10) {
                                sb.append((char)i);
                                continue;
                            }
                            String key = sb.toString();
                            HostKey hk = new HostKey(host, type, Util.fromBase64(key.getBytes(), 0, key.length()));
                            this.pool.addElement(hk);
                            continue block2;
                            break;
                        }
                        break block2;
                        break;
                    }
                    break block2;
                    continue block2;
                }
                break;
            }
            fis.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    String getKnownHostsFile() {
        return this.known_hosts;
    }

    int check(String host, byte[] key) {
        int type = this.getType(key);
        int i = 0;
        while (i < this.pool.size()) {
            HostKey hk = (HostKey)this.pool.elementAt(i);
            if (this.isIncluded(hk.host, host) && hk.type == type) {
                if (KnownHosts.equals(hk.key, key)) {
                    return 0;
                }
                return 2;
            }
            ++i;
        }
        return 1;
    }

    void insert(String host, byte[] key) {
        HostKey hk;
        int type = this.getType(key);
        int i = 0;
        while (i < this.pool.size()) {
            hk = (HostKey)this.pool.elementAt(i);
            if (!this.isIncluded(hk.host, host) || hk.type == type) {
                // empty if block
            }
            ++i;
        }
        hk = new HostKey(host, type, key);
        this.pool.addElement(hk);
    }

    void sync() throws IOException {
        this.sync(this.known_hosts);
    }

    void sync(String foo) throws IOException {
        if (foo == null) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(foo);
        this.dump(fos);
        fos.close();
    }

    void dump(OutputStream out) throws IOException {
        try {
            int i = 0;
            while (i < this.pool.size()) {
                HostKey hk = (HostKey)this.pool.elementAt(i);
                hk.dump(out);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private int getType(byte[] key) {
        if (key[8] == 100) {
            return 0;
        }
        return 1;
    }

    private String deleteSubString(String hosts, String host) {
        int i = 0;
        int hostlen = host.length();
        int hostslen = hosts.length();
        while (i < hostslen) {
            int j = hosts.indexOf(44, i);
            if (j == -1) break;
            if (!host.equals(hosts.substring(i, j))) {
                i = j + 1;
                continue;
            }
            return hosts.substring(0, i) + hosts.substring(j + 1);
        }
        if (hosts.endsWith(host) && hostslen - i == hostlen) {
            return hosts.substring(0, hostlen == hostslen ? 0 : hostslen - hostlen - 1);
        }
        return hosts;
    }

    private boolean isIncluded(String hosts, String host) {
        int i = 0;
        int hostlen = host.length();
        int hostslen = hosts.length();
        while (i < hostslen) {
            int j = hosts.indexOf(44, i);
            if (j == -1) {
                if (hostlen != hostslen - i) {
                    return false;
                }
                return hosts.regionMatches(true, i, host, 0, hostlen);
            }
            if (hostlen == j - i && hosts.regionMatches(true, i, host, 0, hostlen)) {
                return true;
            }
            i = j + 1;
        }
        return false;
    }

    private static boolean equals(byte[] foo, byte[] bar) {
        if (foo.length != bar.length) {
            return false;
        }
        int i = 0;
        while (i < foo.length) {
            if (foo[i] != bar[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static {
        _known_hosts = _known_hosts;
        OK = 0;
        NOT_INCLUDED = 1;
        CHANGED = 2;
        SSHDSS = 0;
        SSHRSA = 1;
        space = new byte[]{32};
        sshdss = "ssh-dss".getBytes();
        sshrsa = "ssh-rsa".getBytes();
        cr = "\n".getBytes();
    }

    class HostKey {
        String host;
        int type;
        byte[] key;

        HostKey(String host, int type, byte[] key) {
            this.host = host;
            this.type = type;
            this.key = key;
        }

        void dump(OutputStream out) throws IOException {
            out.write(this.host.getBytes());
            out.write(space);
            if (this.type == 0) {
                out.write(sshdss);
            } else {
                out.write(sshrsa);
            }
            out.write(space);
            out.write(Util.toBase64(this.key, 0, this.key.length));
            out.write(cr);
        }
    }
}

