/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.KeyPairGenRSA;

public class KeyPairRSA
extends KeyPair {
    private byte[] prv_array;
    private byte[] pub_array;
    private byte[] n_array;
    private byte[] p_array;
    private byte[] q_array;
    private byte[] ep_array;
    private byte[] eq_array;
    private byte[] c_array;
    private int key_size = 0;
    private static final byte[] begin = "-----BEGIN RSA PRIVATE KEY-----".getBytes();
    private static final byte[] end = "-----END RSA PRIVATE KEY-----".getBytes();
    private static final byte[] sshrsa = "ssh-rsa".getBytes();

    public KeyPairRSA(JSch jsch, int key_size) throws JSchException {
        super(jsch, key_size);
        this.key_size = key_size;
        try {
            Class<?> c = Class.forName(jsch.getConfig("keypairgen.rsa"));
            KeyPairGenRSA keypairgen = (KeyPairGenRSA)c.newInstance();
            keypairgen.init(key_size);
            this.pub_array = keypairgen.getE();
            this.prv_array = keypairgen.getD();
            this.n_array = keypairgen.getN();
            this.p_array = keypairgen.getP();
            this.q_array = keypairgen.getQ();
            this.ep_array = keypairgen.getEP();
            this.eq_array = keypairgen.getEQ();
            this.c_array = keypairgen.getC();
            keypairgen = null;
        }
        catch (Exception e) {
            System.err.println("KeyPairRSA: " + e);
            throw new JSchException(e.toString());
        }
    }

    byte[] getBegin() {
        return begin;
    }

    byte[] getEnd() {
        return end;
    }

    byte[] getPrivateKey() {
        int content = 1 + this.countLength(1) + 1 + 1 + this.countLength(this.n_array.length) + this.n_array.length + 1 + this.countLength(this.pub_array.length) + this.pub_array.length + 1 + this.countLength(this.prv_array.length) + this.prv_array.length + 1 + this.countLength(this.p_array.length) + this.p_array.length + 1 + this.countLength(this.q_array.length) + this.q_array.length + 1 + this.countLength(this.ep_array.length) + this.ep_array.length + 1 + this.countLength(this.eq_array.length) + this.eq_array.length + 1 + this.countLength(this.c_array.length) + this.c_array.length;
        int total = 1 + this.countLength(content) + content;
        byte[] plain = new byte[total];
        int index = 0;
        index = this.writeSEQUENCE(plain, index, content);
        index = this.writeINTEGER(plain, index, new byte[1]);
        index = this.writeINTEGER(plain, index, this.n_array);
        index = this.writeINTEGER(plain, index, this.pub_array);
        index = this.writeINTEGER(plain, index, this.prv_array);
        index = this.writeINTEGER(plain, index, this.p_array);
        index = this.writeINTEGER(plain, index, this.q_array);
        index = this.writeINTEGER(plain, index, this.ep_array);
        index = this.writeINTEGER(plain, index, this.eq_array);
        index = this.writeINTEGER(plain, index, this.c_array);
        return plain;
    }

    byte[] getPublicKeyBlob() {
        Buffer buf = new Buffer(sshrsa.length + 4 + this.pub_array.length + 4 + this.n_array.length + 4);
        buf.putString(sshrsa);
        buf.putString(this.pub_array);
        buf.putString(this.n_array);
        return buf.buffer;
    }

    byte[] getKeyTypeName() {
        return sshrsa;
    }

    public int getKeyType() {
        return 1;
    }

    public int getKeySize() {
        return this.key_size;
    }

    public void dispose() {
        super.dispose();
        this.pub_array = null;
        this.prv_array = null;
        this.n_array = null;
        this.p_array = null;
        this.q_array = null;
        this.ep_array = null;
        this.eq_array = null;
        this.c_array = null;
    }
}

