/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.KeyPairGenDSA;

public class KeyPairDSA
extends KeyPair {
    private byte[] P_array;
    private byte[] Q_array;
    private byte[] G_array;
    private byte[] pub_array;
    private byte[] prv_array;
    private int key_size = 0;
    private static final byte[] begin = "-----BEGIN DSA PRIVATE KEY-----".getBytes();
    private static final byte[] end = "-----END DSA PRIVATE KEY-----".getBytes();
    private static final byte[] sshdss = "ssh-dss".getBytes();

    public KeyPairDSA(JSch jsch, int key_size) throws JSchException {
        super(jsch, key_size);
        this.key_size = key_size;
        try {
            Class<?> c = Class.forName(jsch.getConfig("keypairgen.dsa"));
            KeyPairGenDSA keypairgen = (KeyPairGenDSA)c.newInstance();
            keypairgen.init(key_size);
            this.P_array = keypairgen.getP();
            this.Q_array = keypairgen.getQ();
            this.G_array = keypairgen.getG();
            this.pub_array = keypairgen.getY();
            this.prv_array = keypairgen.getX();
            keypairgen = null;
        }
        catch (Exception e) {
            System.err.println("KeyPairDSA: " + e);
            throw new JSchException(e.toString());
        }
    }

    byte[] getBegin() {
        return begin;
    }

    byte[] getEnd() {
        return end;
    }

    byte[] getPrivateKey() {
        int content = 1 + this.countLength(1) + 1 + 1 + this.countLength(this.P_array.length) + this.P_array.length + 1 + this.countLength(this.Q_array.length) + this.Q_array.length + 1 + this.countLength(this.G_array.length) + this.G_array.length + 1 + this.countLength(this.pub_array.length) + this.pub_array.length + 1 + this.countLength(this.prv_array.length) + this.prv_array.length;
        int total = 1 + this.countLength(content) + content;
        byte[] plain = new byte[total];
        int index = 0;
        index = this.writeSEQUENCE(plain, index, content);
        index = this.writeINTEGER(plain, index, new byte[1]);
        index = this.writeINTEGER(plain, index, this.P_array);
        index = this.writeINTEGER(plain, index, this.Q_array);
        index = this.writeINTEGER(plain, index, this.G_array);
        index = this.writeINTEGER(plain, index, this.pub_array);
        index = this.writeINTEGER(plain, index, this.prv_array);
        return plain;
    }

    byte[] getPublicKeyBlob() {
        Buffer buf = new Buffer(sshdss.length + 4 + this.P_array.length + 4 + this.Q_array.length + 4 + this.G_array.length + 4 + this.pub_array.length + 4);
        buf.putString(sshdss);
        buf.putString(this.P_array);
        buf.putString(this.Q_array);
        buf.putString(this.G_array);
        buf.putString(this.pub_array);
        return buf.buffer;
    }

    byte[] getKeyTypeName() {
        return sshdss;
    }

    public int getKeyType() {
        return 0;
    }

    public int getKeySize() {
        return this.key_size;
    }

    public void dispose() {
        super.dispose();
        this.P_array = null;
        this.Q_array = null;
        this.G_array = null;
        this.pub_array = null;
        this.prv_array = null;
    }
}

