/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPairDSA;
import com.jcraft.jsch.KeyPairRSA;
import com.jcraft.jsch.Random;
import com.jcraft.jsch.Util;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class KeyPair {
    public static final int DSA = 0;
    public static final int RSA = 1;
    private static final byte[] cr;
    private JSch jsch = null;
    private Cipher cipher;
    private HASH hash;
    private Random random;
    private byte[] passphrase;
    private byte[] iv;
    static byte[][] header;
    private static byte[] space;

    public static KeyPair genKeyPair(JSch jsch, int type) throws JSchException {
        return KeyPair.genKeyPair(jsch, type, 1024);
    }

    public static KeyPair genKeyPair(JSch jsch, int type, int key_size) throws JSchException {
        if (type == 0) {
            return new KeyPairDSA(jsch, key_size);
        }
        if (type == 1) {
            return new KeyPairRSA(jsch, key_size);
        }
        return null;
    }

    abstract byte[] getBegin();

    abstract byte[] getEnd();

    abstract int getKeySize();

    abstract byte[] getPrivateKey();

    public KeyPair(JSch jsch, int key_size) {
        this.jsch = jsch;
        this.cipher = this.genCipher();
        this.hash = this.genHash();
    }

    public void writePrivateKey(OutputStream out) {
        byte[] plain = this.getPrivateKey();
        byte[] encoded = this.encrypt(plain);
        byte[] prv = Util.toBase64(encoded, 0, encoded.length);
        try {
            int i;
            out.write(this.getBegin());
            out.write(cr);
            if (this.passphrase != null) {
                out.write(header[0]);
                out.write(cr);
                out.write(header[1]);
                i = 0;
                while (i < this.iv.length) {
                    out.write(this.b2a((byte)(this.iv[i] >>> 4 & 0xF)));
                    out.write(this.b2a((byte)(this.iv[i] & 0xF)));
                    ++i;
                }
                out.write(cr);
                out.write(cr);
            }
            for (i = 0; i < prv.length; i += 64) {
                if (i + 64 < prv.length) {
                    out.write(prv, i, 64);
                    out.write(cr);
                    continue;
                }
                out.write(prv, i, prv.length - i);
                out.write(cr);
                break;
            }
            out.write(this.getEnd());
            out.write(cr);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    abstract byte[] getPublicKeyBlob();

    abstract byte[] getKeyTypeName();

    public abstract int getKeyType();

    public void writePublicKey(OutputStream out, String comment) {
        byte[] pubblob = this.getPublicKeyBlob();
        byte[] pub = Util.toBase64(pubblob, 0, pubblob.length);
        try {
            out.write(this.getKeyTypeName());
            out.write(space);
            out.write(pub, 0, pub.length);
            out.write(space);
            out.write(comment.getBytes());
            out.write(cr);
            out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void writePublicKey(String name, String comment) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(name);
        this.writePublicKey(fos, comment);
        fos.close();
    }

    public void writePrivateKey(String name) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(name);
        this.writePrivateKey(fos);
        fos.close();
    }

    public String getFingerPrint() {
        HASH hash = null;
        try {
            Class<?> c = Class.forName(this.jsch.getConfig("md5"));
            hash = (HASH)c.newInstance();
        }
        catch (Exception e) {
            System.err.println("getFingerPrint: " + e);
        }
        return this.getKeySize() + " " + Util.getFingerPrint(hash, this.getPublicKeyBlob());
    }

    private byte[] encrypt(byte[] plain) {
        if (this.passphrase == null) {
            return plain;
        }
        this.iv = new byte[this.cipher.getIVSize()];
        this.random = this.genRandom();
        this.random.fill(this.iv, 0, this.iv.length);
        byte[] key = this.genKey(this.passphrase, this.iv);
        byte[] encoded = plain;
        int bsize = this.cipher.getBlockSize();
        if (encoded.length % bsize != 0) {
            byte[] foo = new byte[(encoded.length / bsize + 1) * bsize];
            System.arraycopy(encoded, 0, foo, 0, encoded.length);
            encoded = foo;
        }
        try {
            this.cipher.init(0, key, this.iv);
            this.cipher.update(encoded, 0, encoded.length, encoded, 0);
        }
        catch (Exception e) {
            // empty catch block
        }
        return encoded;
    }

    int writeSEQUENCE(byte[] buf, int index, int len) {
        buf[index++] = 48;
        index = this.writeLength(buf, index, len);
        return index;
    }

    int writeINTEGER(byte[] buf, int index, byte[] data) {
        buf[index++] = 2;
        index = this.writeLength(buf, index, data.length);
        System.arraycopy(data, 0, buf, index, data.length);
        return index += data.length;
    }

    /*
     * Unable to fully structure code
     */
    int countLength(int len) {
        i = 1;
        if (len > 127) ** GOTO lbl6
        return i;
lbl-1000:
        // 1 sources

        {
            len >>>= 8;
            ++i;
lbl6:
            // 2 sources

            ** while (len > 0)
        }
lbl7:
        // 1 sources

        return i;
    }

    int writeLength(byte[] data, int index, int len) {
        int i = this.countLength(len) - 1;
        if (i == 0) {
            data[index++] = (byte)len;
            return index;
        }
        data[index++] = (byte)(0x80 | i);
        int j = index + i;
        while (i > 0) {
            data[index + i - 1] = (byte)(len & 0xFF);
            len >>>= 8;
            --i;
        }
        return j;
    }

    private Random genRandom() {
        if (this.random == null) {
            try {
                Class<?> c = Class.forName(this.jsch.getConfig("random"));
                this.random = (Random)c.newInstance();
            }
            catch (Exception e) {
                System.err.println("connect: random " + e);
            }
        }
        return this.random;
    }

    private HASH genHash() {
        try {
            Class<?> c = Class.forName(this.jsch.getConfig("md5"));
            this.hash = (HASH)c.newInstance();
            this.hash.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.hash;
    }

    private Cipher genCipher() {
        try {
            Class<?> c = Class.forName(this.jsch.getConfig("3des-cbc"));
            this.cipher = (Cipher)c.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.cipher;
    }

    synchronized byte[] genKey(byte[] passphrase, byte[] iv) {
        byte[] key = new byte[this.cipher.getBlockSize()];
        int hsize = this.hash.getBlockSize();
        byte[] hn = new byte[key.length / hsize * hsize + (key.length % hsize == 0 ? 0 : hsize)];
        try {
            byte[] tmp = null;
            int index = 0;
            while (index + hsize <= hn.length) {
                if (tmp != null) {
                    this.hash.update(tmp, 0, tmp.length);
                }
                this.hash.update(passphrase, 0, passphrase.length);
                this.hash.update(iv, 0, iv.length);
                tmp = this.hash.digest();
                System.arraycopy(tmp, 0, hn, index, tmp.length);
                index += tmp.length;
            }
            System.arraycopy(hn, 0, key, 0, key.length);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return key;
    }

    public void setPassphrase(String passphrase) {
        if (passphrase == null || passphrase.length() == 0) {
            this.setPassphrase((byte[])null);
        } else {
            this.setPassphrase(passphrase.getBytes());
        }
    }

    public void setPassphrase(byte[] passphrase) {
        this.passphrase = passphrase;
        this.iv = null;
    }

    private byte a2b(byte c) {
        if (48 <= c && c <= 57) {
            return (byte)(c - 48);
        }
        return (byte)(c - 97 + 10);
    }

    private byte b2a(byte c) {
        if (0 <= c && c <= 9) {
            return (byte)(c + 48);
        }
        return (byte)(c - 10 + 65);
    }

    public void dispose() {
        this.passphrase = null;
        this.iv = null;
    }

    static {
        DSA = 0;
        RSA = 1;
        cr = "\n".getBytes();
        header = new byte[][]{"Proc-Type: 4,ENCRYPTED".getBytes(), "DEK-Info: DES-EDE3-CBC,".getBytes()};
        space = " ".getBytes();
    }
}

