/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KnownHosts;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Util;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JSch {
    static Hashtable config = new Hashtable();
    Vector pool = new Vector();
    Vector identities = new Vector();
    private KnownHosts known_hosts = new KnownHosts();
    private Vector proxies;

    public Session getSession(String username, String host) throws JSchException {
        return this.getSession(username, host, 22);
    }

    public Session getSession(String username, String host, int port) throws JSchException {
        Session s = new Session(this);
        s.setUserName(username);
        s.setHost(host);
        s.setPort(port);
        this.pool.addElement(s);
        return s;
    }

    public void setKnownHosts(String foo) {
        this.known_hosts.setKnownHosts(foo);
    }

    public KnownHosts getKnownHosts() {
        return this.known_hosts;
    }

    public void addIdentity(String foo) throws JSchException {
        this.addIdentity(foo, null);
    }

    public void addIdentity(String foo, String bar) throws JSchException {
        Identity identity = new Identity(foo, this);
        if (bar != null) {
            identity.setPassphrase(bar);
        }
        this.identities.addElement(identity);
    }

    String getConfig(String foo) {
        return (String)config.get(foo);
    }

    void setProxy(String hosts, Proxy proxy) {
        String[] patterns = Util.split(hosts, ",");
        if (this.proxies == null) {
            this.proxies = new Vector();
        }
        int i = 0;
        while (i < patterns.length) {
            if (proxy == null) {
                this.proxies.insertElementAt(null, 0);
                this.proxies.insertElementAt(patterns[i].getBytes(), 0);
            } else {
                this.proxies.addElement(patterns[i].getBytes());
                this.proxies.addElement(proxy);
            }
            ++i;
        }
    }

    Proxy getProxy(String host) {
        if (this.proxies == null) {
            return null;
        }
        byte[] _host = host.getBytes();
        int i = 0;
        while (i < this.proxies.size()) {
            if (Util.glob((byte[])this.proxies.elementAt(i), _host)) {
                return (Proxy)this.proxies.elementAt(i + 1);
            }
            i += 2;
        }
        return null;
    }

    void removeProxy() {
        this.proxies = null;
    }

    public static void setConfig(Hashtable foo) {
        Enumeration e = foo.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            config.put(key, (String)foo.get(key));
        }
    }

    static {
        config.put("kex", "diffie-hellman-group1-sha1,diffie-hellman-group-exchange-sha1");
        config.put("server_host_key", "ssh-rsa,ssh-dss");
        config.put("cipher.s2c", "3des-cbc,blowfish-cbc");
        config.put("cipher.c2s", "3des-cbc,blowfish-cbc");
        config.put("mac.s2c", "hmac-md5,hmac-sha1,hmac-sha1-96,hmac-md5-96");
        config.put("mac.c2s", "hmac-md5,hmac-sha1,hmac-sha1-96,hmac-md5-96");
        config.put("compression.s2c", "none");
        config.put("compression.c2s", "none");
        config.put("lang.s2c", "");
        config.put("lang.c2s", "");
        config.put("diffie-hellman-group-exchange-sha1", "com.jcraft.jsch.jce.DHGEX");
        config.put("diffie-hellman-group1-sha1", "com.jcraft.jsch.jce.DHG1");
        config.put("dh", "com.jcraft.jsch.jce.DH");
        config.put("3des-cbc", "com.jcraft.jsch.jce.TripleDESCBC");
        config.put("blowfish-cbc", "com.jcraft.jsch.jce.BlowfishCBC");
        config.put("hmac-sha1", "com.jcraft.jsch.jce.HMACSHA1");
        config.put("hmac-sha1-96", "com.jcraft.jsch.jce.HMACSHA196");
        config.put("hmac-md5", "com.jcraft.jsch.jce.HMACMD5");
        config.put("hmac-md5-96", "com.jcraft.jsch.jce.HMACMD596");
        config.put("sha-1", "com.jcraft.jsch.jce.SHA1");
        config.put("md5", "com.jcraft.jsch.jce.MD5");
        config.put("signature.dss", "com.jcraft.jsch.jce.SignatureDSA");
        config.put("signature.rsa", "com.jcraft.jsch.jce.SignatureRSA");
        config.put("keypairgen.dsa", "com.jcraft.jsch.jce.KeyPairGenDSA");
        config.put("keypairgen.rsa", "com.jcraft.jsch.jce.KeyPairGenRSA");
        config.put("random", "com.jcraft.jsch.jce.Random");
        config.put("zlib", "com.jcraft.jsch.jcraft.Compression");
        config.put("StrictHostKeyChecking", "ask");
    }
}

