/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SignatureDSA;
import com.jcraft.jsch.SignatureRSA;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileInputStream;

class Identity {
    String identity;
    byte[] key;
    byte[] iv;
    private JSch jsch;
    private HASH hash;
    private byte[] encoded_data;
    private Cipher cipher;
    private byte[] P_array;
    private byte[] Q_array;
    private byte[] G_array;
    private byte[] pub_array;
    private byte[] prv_array;
    private byte[] n_array;
    private byte[] e_array;
    private byte[] d_array;
    private String algname = "ssh-rsa";
    private static final int ERROR = 0;
    private static final int RSA = 1;
    private static final int DSS = 2;
    private static final int UNKNOWN = 3;
    private static final int OPENSSH = 0;
    private static final int FSECURE = 1;
    private static final int PUTTY = 2;
    private int type = 0;
    private int keytype = 0;
    private byte[] publickeyblob = null;
    private boolean encrypted = true;

    Identity(String identity, JSch jsch) throws JSchException {
        this.identity = identity;
        this.jsch = jsch;
        try {
            Class<?> c = Class.forName(jsch.getConfig("3des-cbc"));
            this.cipher = (Cipher)c.newInstance();
            this.key = new byte[this.cipher.getBlockSize()];
            this.iv = new byte[this.cipher.getIVSize()];
            c = Class.forName(jsch.getConfig("md5"));
            this.hash = (HASH)c.newInstance();
            this.hash.init();
            File file = new File(identity);
            FileInputStream fis = new FileInputStream(identity);
            byte[] buf = new byte[(int)file.length()];
            int len = fis.read(buf, 0, buf.length);
            fis.close();
            int i = 0;
            while (i < len) {
                if (buf[i] == 66 && buf[i + 1] == 69 && buf[i + 2] == 71 && buf[i + 3] == 73) {
                    if (buf[i += 6] == 68 && buf[i + 1] == 83 && buf[i + 2] == 65) {
                        this.type = 2;
                    } else if (buf[i] == 82 && buf[i + 1] == 83 && buf[i + 2] == 65) {
                        this.type = 1;
                    } else if (buf[i] == 83 && buf[i + 1] == 83 && buf[i + 2] == 72) {
                        this.type = 3;
                        this.keytype = 1;
                    } else {
                        throw new JSchException("invaid privatekey: " + identity);
                    }
                    i += 3;
                    continue;
                }
                if (buf[i] == 67 && buf[i + 1] == 66 && buf[i + 2] == 67 && buf[i + 3] == 44) {
                    i += 4;
                    int ii = 0;
                    while (ii < this.iv.length) {
                        this.iv[ii] = (byte)((this.a2b(buf[i++]) << 4 & 0xF0) + (this.a2b(buf[i++]) & 0xF));
                        ++ii;
                    }
                    continue;
                }
                if (buf[i] == 13 && i + 1 < buf.length && buf[i + 1] == 10) {
                    ++i;
                    continue;
                }
                if (buf[i] == 10 && i + 1 < buf.length) {
                    if (buf[i + 1] == 10) {
                        i += 2;
                        break;
                    }
                    if (buf[i + 1] == 13 && i + 2 < buf.length && buf[i + 2] == 10) {
                        i += 3;
                        break;
                    }
                    boolean inheader = false;
                    int j = i + 1;
                    while (j < buf.length) {
                        if (buf[j] == 10) break;
                        if (buf[j] == 58) {
                            inheader = true;
                            break;
                        }
                        ++j;
                    }
                    if (!inheader) {
                        ++i;
                        this.encrypted = false;
                        break;
                    }
                }
                ++i;
            }
            if (this.type == 0) {
                throw new JSchException("invaid privatekey: " + identity);
            }
            int start = i;
            while (i < len) {
                if (buf[i] == 10) {
                    boolean xd = buf[i - 1] == 13;
                    System.arraycopy(buf, i + 1, buf, i - (xd ? 1 : 0), len - i - 1 - (xd ? 1 : 0));
                    if (xd) {
                        --len;
                    }
                    --len;
                    continue;
                }
                if (buf[i] == 45) break;
                ++i;
            }
            this.encoded_data = Util.fromBase64(buf, start, i - start);
            if (this.encoded_data.length > 4 && this.encoded_data[0] == 63 && this.encoded_data[1] == 111 && this.encoded_data[2] == -7 && this.encoded_data[3] == -21) {
                Buffer _buf = new Buffer(this.encoded_data);
                _buf.getInt();
                _buf.getInt();
                byte[] _type = _buf.getString();
                byte[] _cipher = _buf.getString();
                String cipher = new String(_cipher);
                if (cipher.equals("3des-cbc")) {
                    _buf.getInt();
                    byte[] foo = new byte[this.encoded_data.length - _buf.getOffSet()];
                    _buf.getByte(foo);
                    this.encoded_data = foo;
                    this.encrypted = true;
                    throw new JSchException("unknown privatekey format: " + identity);
                }
                if (cipher.equals("none")) {
                    _buf.getInt();
                    _buf.getInt();
                    this.encrypted = false;
                    byte[] foo = new byte[this.encoded_data.length - _buf.getOffSet()];
                    _buf.getByte(foo);
                    this.encoded_data = foo;
                }
            }
            try {
                file = new File(identity + ".pub");
                fis = new FileInputStream(identity + ".pub");
                buf = new byte[(int)file.length()];
                len = fis.read(buf, 0, buf.length);
                fis.close();
            }
            catch (Exception ee) {
                return;
            }
            if (buf.length > 4 && buf[0] == 45 && buf[1] == 45 && buf[2] == 45 && buf[3] == 45) {
                i = 0;
                while (buf.length > ++i && buf[i] != 10) {
                }
                if (buf.length <= i) {
                    return;
                }
                while (true) {
                    if (buf[i] == 10) {
                        boolean inheader = false;
                        int j = i + 1;
                        while (j < buf.length) {
                            if (buf[j] == 10) break;
                            if (buf[j] == 58) {
                                inheader = true;
                                break;
                            }
                            ++j;
                        }
                        if (!inheader) break;
                    }
                    ++i;
                }
                if (buf.length <= ++i) {
                    return;
                }
                start = i;
                while (i < len) {
                    if (buf[i] == 10) {
                        System.arraycopy(buf, i + 1, buf, i, len - i - 1);
                        --len;
                        continue;
                    }
                    if (buf[i] == 45) break;
                    ++i;
                }
                this.publickeyblob = Util.fromBase64(buf, start, i - start);
                if (this.type == 3) {
                    if (this.publickeyblob[8] == 100) {
                        this.type = 2;
                    } else if (this.publickeyblob[8] == 114) {
                        this.type = 1;
                    }
                }
            } else {
                if (buf[0] != 115 || buf[1] != 115 || buf[2] != 104 || buf[3] != 45) {
                    return;
                }
                i = 0;
                while (i < len) {
                    if (buf[i] == 32) break;
                    ++i;
                }
                if (++i >= len) {
                    return;
                }
                start = i;
                while (i < len) {
                    if (buf[i] == 32) break;
                    ++i;
                }
                this.publickeyblob = Util.fromBase64(buf, start, i - start);
            }
        }
        catch (Exception e) {
            System.out.println("Identity: " + e);
            if (e instanceof JSchException) {
                throw (JSchException)e;
            }
            throw new JSchException(e.toString());
        }
    }

    String getAlgName() {
        if (this.type == 1) {
            return "ssh-rsa";
        }
        return "ssh-dss";
    }

    boolean setPassphrase(String _passphrase) throws JSchException {
        try {
            if (this.encrypted) {
                if (_passphrase == null) {
                    return false;
                }
                byte[] passphrase = _passphrase.getBytes();
                int hsize = this.hash.getBlockSize();
                byte[] hn = new byte[this.key.length / hsize * hsize + (this.key.length % hsize == 0 ? 0 : hsize)];
                byte[] tmp = null;
                if (this.keytype == 0) {
                    int index = 0;
                    while (index + hsize <= hn.length) {
                        if (tmp != null) {
                            this.hash.update(tmp, 0, tmp.length);
                        }
                        this.hash.update(passphrase, 0, passphrase.length);
                        this.hash.update(this.iv, 0, this.iv.length);
                        tmp = this.hash.digest();
                        System.arraycopy(tmp, 0, hn, index, tmp.length);
                        index += tmp.length;
                    }
                    System.arraycopy(hn, 0, this.key, 0, this.key.length);
                } else if (this.keytype == 1) {
                    int index = 0;
                    while (index + hsize <= hn.length) {
                        if (tmp != null) {
                            this.hash.update(tmp, 0, tmp.length);
                        }
                        this.hash.update(passphrase, 0, passphrase.length);
                        tmp = this.hash.digest();
                        System.arraycopy(tmp, 0, hn, index, tmp.length);
                        index += tmp.length;
                    }
                    System.arraycopy(hn, 0, this.key, 0, this.key.length);
                }
            }
            if (this.decrypt()) {
                this.encrypted = false;
                return true;
            }
            this.prv_array = null;
            this.pub_array = null;
            this.G_array = null;
            this.Q_array = null;
            this.P_array = null;
            return false;
        }
        catch (Exception e) {
            if (e instanceof JSchException) {
                throw (JSchException)e;
            }
            throw new JSchException(e.toString());
        }
    }

    byte[] getPublicKeyBlob() {
        if (this.publickeyblob != null) {
            return this.publickeyblob;
        }
        if (this.type == 1) {
            return this.getPublicKeyBlob_rsa();
        }
        return this.getPublicKeyBlob_dss();
    }

    byte[] getPublicKeyBlob_rsa() {
        if (this.e_array == null) {
            return null;
        }
        Buffer buf = new Buffer("ssh-rsa".length() + 4 + this.e_array.length + 4 + this.n_array.length + 4);
        buf.putString("ssh-rsa".getBytes());
        buf.putString(this.e_array);
        buf.putString(this.n_array);
        return buf.buffer;
    }

    byte[] getPublicKeyBlob_dss() {
        if (this.P_array == null) {
            return null;
        }
        Buffer buf = new Buffer("ssh-dss".length() + 4 + this.P_array.length + 4 + this.Q_array.length + 4 + this.G_array.length + 4 + this.pub_array.length + 4);
        buf.putString("ssh-dss".getBytes());
        buf.putString(this.P_array);
        buf.putString(this.Q_array);
        buf.putString(this.G_array);
        buf.putString(this.pub_array);
        return buf.buffer;
    }

    byte[] getSignature(Session session, byte[] data) {
        if (this.type == 1) {
            return this.getSignature_rsa(session, data);
        }
        return this.getSignature_dss(session, data);
    }

    byte[] getSignature_rsa(Session session, byte[] data) {
        try {
            Class<?> c = Class.forName(this.jsch.getConfig("signature.rsa"));
            SignatureRSA rsa = (SignatureRSA)c.newInstance();
            rsa.init();
            rsa.setPrvKey(this.d_array, this.n_array);
            byte[] goo = new byte[]{(byte)(session.getSessionId().length >>> 24), (byte)(session.getSessionId().length >>> 16), (byte)(session.getSessionId().length >>> 8), (byte)session.getSessionId().length};
            rsa.update(goo);
            rsa.update(session.getSessionId());
            rsa.update(data);
            byte[] sig = rsa.sign();
            Buffer buf = new Buffer("ssh-rsa".length() + 4 + sig.length + 4);
            buf.putString("ssh-rsa".getBytes());
            buf.putString(sig);
            return buf.buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    byte[] getSignature_dss(Session session, byte[] data) {
        try {
            Class<?> c = Class.forName(this.jsch.getConfig("signature.dss"));
            SignatureDSA dsa = (SignatureDSA)c.newInstance();
            dsa.init();
            dsa.setPrvKey(this.prv_array, this.P_array, this.Q_array, this.G_array);
            byte[] goo = new byte[]{(byte)(session.getSessionId().length >>> 24), (byte)(session.getSessionId().length >>> 16), (byte)(session.getSessionId().length >>> 8), (byte)session.getSessionId().length};
            dsa.update(goo);
            dsa.update(session.getSessionId());
            dsa.update(data);
            byte[] sig = dsa.sign();
            Buffer buf = new Buffer("ssh-dss".length() + 4 + sig.length + 4);
            buf.putString("ssh-dss".getBytes());
            buf.putString(sig);
            return buf.buffer;
        }
        catch (Exception e) {
            System.out.println("e " + e);
            return null;
        }
    }

    boolean decrypt() {
        if (this.type == 1) {
            return this.decrypt_rsa();
        }
        return this.decrypt_dss();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean decrypt_rsa() {
        try {
            int foo;
            byte[] plain;
            if (this.encrypted) {
                if (this.keytype == 0) {
                    this.cipher.init(1, this.key, this.iv);
                    plain = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, plain, 0);
                } else {
                    if (this.keytype != 1) return false;
                    int i = 0;
                    while (i < this.iv.length) {
                        this.iv[i] = 0;
                        ++i;
                    }
                    this.cipher.init(1, this.key, this.iv);
                    plain = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, plain, 0);
                }
            } else {
                if (this.n_array != null) {
                    return true;
                }
                plain = this.encoded_data;
            }
            int index = 0;
            int length = 0;
            if (plain[index] != 48) {
                Buffer buf = new Buffer(plain);
                this.e_array = buf.getMPIntBits();
                this.d_array = buf.getMPIntBits();
                this.n_array = buf.getMPIntBits();
                byte[] u_array = buf.getMPIntBits();
                byte[] p_array = buf.getMPIntBits();
                byte[] q_array = buf.getMPIntBits();
                return true;
            }
            int n = ++index;
            ++index;
            length = plain[n] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            if (plain[index] != 2) {
                return false;
            }
            int n2 = ++index;
            ++index;
            length = plain[n2] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            index += length;
            int n3 = ++index;
            ++index;
            length = plain[n3] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.n_array = new byte[length];
            System.arraycopy(plain, index, this.n_array, 0, length);
            index += length;
            int n4 = ++index;
            ++index;
            length = plain[n4] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.e_array = new byte[length];
            System.arraycopy(plain, index, this.e_array, 0, length);
            index += length;
            int n5 = ++index;
            ++index;
            length = plain[n5] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.d_array = new byte[length];
            System.arraycopy(plain, index, this.d_array, 0, length);
            index += length;
            int n6 = ++index;
            ++index;
            length = plain[n6] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            byte[] p_array = new byte[length];
            System.arraycopy(plain, index, p_array, 0, length);
            index += length;
            int n7 = ++index;
            ++index;
            length = plain[n7] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            byte[] q_array = new byte[length];
            System.arraycopy(plain, index, q_array, 0, length);
            index += length;
            int n8 = ++index;
            ++index;
            length = plain[n8] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            byte[] dmp1_array = new byte[length];
            System.arraycopy(plain, index, dmp1_array, 0, length);
            index += length;
            int n9 = ++index;
            ++index;
            length = plain[n9] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            byte[] dmq1_array = new byte[length];
            System.arraycopy(plain, index, dmq1_array, 0, length);
            index += length;
            int n10 = ++index;
            ++index;
            length = plain[n10] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            byte[] iqmp_array = new byte[length];
            System.arraycopy(plain, index, iqmp_array, 0, length);
            index += length;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean decrypt_dss() {
        try {
            int foo;
            byte[] plain;
            if (this.encrypted) {
                if (this.keytype == 0) {
                    this.cipher.init(1, this.key, this.iv);
                    plain = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, plain, 0);
                } else {
                    if (this.keytype != 1) return false;
                    int i = 0;
                    while (i < this.iv.length) {
                        this.iv[i] = 0;
                        ++i;
                    }
                    this.cipher.init(1, this.key, this.iv);
                    plain = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, plain, 0);
                }
            } else {
                if (this.P_array != null) {
                    return true;
                }
                plain = this.encoded_data;
            }
            if (plain[0] != 48) {
                Buffer buf = new Buffer(plain);
                buf.getInt();
                this.P_array = buf.getMPIntBits();
                this.G_array = buf.getMPIntBits();
                this.Q_array = buf.getMPIntBits();
                this.pub_array = buf.getMPIntBits();
                this.prv_array = buf.getMPIntBits();
                return true;
            }
            int index = 0;
            int length = 0;
            if (plain[index] != 48) {
                return false;
            }
            int n = ++index;
            ++index;
            length = plain[n] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            if (plain[index] != 2) {
                return false;
            }
            int n2 = ++index;
            ++index;
            length = plain[n2] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            index += length;
            int n3 = ++index;
            ++index;
            length = plain[n3] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.P_array = new byte[length];
            System.arraycopy(plain, index, this.P_array, 0, length);
            index += length;
            int n4 = ++index;
            ++index;
            length = plain[n4] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.Q_array = new byte[length];
            System.arraycopy(plain, index, this.Q_array, 0, length);
            index += length;
            int n5 = ++index;
            ++index;
            length = plain[n5] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.G_array = new byte[length];
            System.arraycopy(plain, index, this.G_array, 0, length);
            index += length;
            int n6 = ++index;
            ++index;
            length = plain[n6] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.pub_array = new byte[length];
            System.arraycopy(plain, index, this.pub_array, 0, length);
            index += length;
            int n7 = ++index;
            ++index;
            length = plain[n7] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.prv_array = new byte[length];
            System.arraycopy(plain, index, this.prv_array, 0, length);
            int n8 = index + length;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private int writeSEQUENCE(byte[] buf, int index, int len) {
        buf[index++] = 48;
        index = this.writeLength(buf, index, len);
        return index;
    }

    private int writeINTEGER(byte[] buf, int index, byte[] data) {
        buf[index++] = 2;
        index = this.writeLength(buf, index, data.length);
        System.arraycopy(data, 0, buf, index, data.length);
        return index += data.length;
    }

    /*
     * Unable to fully structure code
     */
    private int countLength(int len) {
        i = 1;
        if (len > 127) ** GOTO lbl6
        return i;
lbl-1000:
        // 1 sources

        {
            len >>>= 8;
            ++i;
lbl6:
            // 2 sources

            ** while (len > 0)
        }
lbl7:
        // 1 sources

        return i;
    }

    private int writeLength(byte[] data, int index, int len) {
        int i = this.countLength(len) - 1;
        if (i == 0) {
            data[index++] = (byte)len;
            return index;
        }
        data[index++] = (byte)(0x80 | i);
        int j = index + i;
        while (i > 0) {
            data[index + i - 1] = (byte)(len & 0xFF);
            len >>>= 8;
            --i;
        }
        return j;
    }

    private byte a2b(byte c) {
        if (48 <= c && c <= 57) {
            return (byte)(c - 48);
        }
        if (97 <= c && c <= 122) {
            return (byte)(c - 97 + 10);
        }
        return (byte)(c - 65 + 10);
    }

    private byte b2a(byte c) {
        if (0 <= c && c <= 9) {
            return (byte)(c + 48);
        }
        return (byte)(c - 10 + 65);
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    static {
        ERROR = 0;
        RSA = 1;
        DSS = 2;
        UNKNOWN = 3;
        OPENSSH = 0;
        FSECURE = 1;
        PUTTY = 2;
    }
}

