/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import java.net.Socket;
import java.util.Vector;

class ChannelForwardedTCPIP
extends Channel {
    static Vector pool = new Vector();
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    String host;
    int lport;
    int rport;

    ChannelForwardedTCPIP() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
    }

    void init() {
        try {
            Socket socket = new Socket(this.host, this.lport);
            socket.setTcpNoDelay(true);
            this.io = new IO();
            this.io.setInputStream(socket.getInputStream());
            this.io.setOutputStream(socket.getOutputStream());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void run() {
        this.thread = this;
        Buffer buf = new Buffer(this.rmpsize);
        Packet packet = new Packet(buf);
        int i = 0;
        try {
            while (this.thread != null && this.io != null && this.io.in != null) {
                i = this.io.in.read(buf.buffer, 14, buf.buffer.length - 14 - 16 - 20);
                if (i > 0) {
                    packet.reset();
                    if (!this.close) {
                        buf.putByte((byte)94);
                        buf.putInt(this.recipient);
                        buf.putInt(i);
                        buf.skip(i);
                        this.session.write(packet, this, i);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.disconnect();
    }

    public void disconnect() {
        this.close();
        this.thread = null;
        try {
            if (this.io != null) {
                if (this.io.in != null) {
                    this.io.in.close();
                }
                if (this.io.out != null) {
                    this.io.out.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.io = null;
        Channel.del(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getData(Buffer buf) {
        this.setRecipient(buf.getInt());
        this.setRemoteWindowSize(buf.getInt());
        this.setRemotePacketSize(buf.getInt());
        byte[] addr = buf.getString();
        int port = buf.getInt();
        byte[] orgaddr = buf.getString();
        int orgport = buf.getInt();
        Vector vector = pool;
        synchronized (vector) {
            int i = 0;
            while (i < pool.size()) {
                Object[] foo = (Object[])pool.elementAt(i);
                if (foo[0] == this.session && (Integer)foo[1] == port) {
                    this.rport = port;
                    this.host = (String)foo[2];
                    this.lport = (Integer)foo[3];
                    break;
                }
                ++i;
            }
            if (this.host == null) {
                System.out.println("??");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object[] getPort(Session session, int rport) {
        Vector vector = pool;
        synchronized (vector) {
            Object foo = null;
            int i = 0;
            while (i < pool.size()) {
                Object[] bar = (Object[])pool.elementAt(i);
                if (bar[0] == session && (Integer)bar[1] == rport) {
                    return bar;
                }
                ++i;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getPortForwarding(Session session) {
        Vector<String> foo = new Vector<String>();
        Vector vector = pool;
        synchronized (vector) {
            int i = 0;
            while (i < pool.size()) {
                Object[] bar = (Object[])pool.elementAt(i);
                if (bar[0] == session) {
                    foo.addElement(bar[1] + ":" + bar[2] + ":" + bar[3]);
                }
                ++i;
            }
        }
        String[] bar = new String[foo.size()];
        int i = 0;
        while (i < foo.size()) {
            bar[i] = (String)foo.elementAt(i);
            ++i;
        }
        return bar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPort(Session session, int port, String host, int lport) throws JSchException {
        Vector vector = pool;
        synchronized (vector) {
            if (ChannelForwardedTCPIP.getPort(session, port) != null) {
                throw new JSchException("PortForwardingR: remote port " + port + " is already registered.");
            }
            Object[] foo = new Object[]{session, new Integer(port), host, new Integer(lport)};
            pool.addElement(foo);
        }
    }

    static void delPort(ChannelForwardedTCPIP c) {
        ChannelForwardedTCPIP.delPort(c.session, c.rport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session, int rport) {
        Vector vector = pool;
        synchronized (vector) {
            Object[] foo = null;
            int i = 0;
            while (i < pool.size()) {
                Object[] bar = (Object[])pool.elementAt(i);
                if (bar[0] == session && (Integer)bar[1] == rport) {
                    foo = bar;
                    break;
                }
                ++i;
            }
            if (foo == null) {
                return;
            }
            pool.removeElement(foo);
        }
        Buffer buf = new Buffer(100);
        Packet packet = new Packet(buf);
        try {
            packet.reset();
            buf.putByte((byte)80);
            buf.putString("cancel-tcpip-forward".getBytes());
            buf.putByte((byte)0);
            buf.putString("0.0.0.0".getBytes());
            buf.putInt(rport);
            session.write(packet);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    static void delPort(Session session) {
        int i = 0;
        while (i < pool.size()) {
            Object[] bar = (Object[])pool.elementAt(i);
            if (bar[0] == session) {
                pool.removeElement(bar);
                --i;
            }
            ++i;
        }
    }

    static {
        LOCAL_WINDOW_SIZE_MAX = 131072;
        LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    }
}

