/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelForwardedTCPIP;
import com.jcraft.jsch.ChannelSession;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.ChannelSubsystem;
import com.jcraft.jsch.ChannelX11;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.RequestSignal;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Vector;

public abstract class Channel
implements Runnable {
    static int index = 0;
    private static Vector pool = new Vector();
    int id;
    int recipient = -1;
    byte[] type = "foo".getBytes();
    int lwsize_max;
    int lwsize = this.lwsize_max = 0x100000;
    int lmpsize = 16384;
    int rwsize = 0;
    int rmpsize = 0;
    IO io = null;
    Runnable thread = null;
    boolean eof = false;
    boolean close = false;
    int exitstatus = -1;
    Session session;

    static Channel getChannel(String type) {
        if (type.equals("session")) {
            return new ChannelSession();
        }
        if (type.equals("shell")) {
            return new ChannelShell();
        }
        if (type.equals("exec")) {
            return new ChannelExec();
        }
        if (type.equals("x11")) {
            return new ChannelX11();
        }
        if (type.equals("direct-tcpip")) {
            return new ChannelDirectTCPIP();
        }
        if (type.equals("forwarded-tcpip")) {
            return new ChannelForwardedTCPIP();
        }
        if (type.equals("sftp")) {
            return new ChannelSftp();
        }
        if (type.equals("subsystem")) {
            return new ChannelSubsystem();
        }
        return null;
    }

    static Channel getChannel(int id, Session session) {
        int i = 0;
        while (i < pool.size()) {
            Channel c = (Channel)pool.elementAt(i);
            if (c.id == id && c.session == session) {
                return c;
            }
            ++i;
        }
        return null;
    }

    static void del(Channel c) {
        pool.removeElement(c);
    }

    Channel() {
        this.id = index++;
        pool.addElement(this);
    }

    void setRecipient(int foo) {
        this.recipient = foo;
    }

    int getRecipient() {
        return this.recipient;
    }

    void init() {
    }

    public void connect() throws JSchException {
        block8: {
            if (!this.session.isConnected()) {
                throw new JSchException("session is down");
            }
            try {
                Buffer buf = new Buffer(100);
                Packet packet = new Packet(buf);
                packet.reset();
                buf.putByte((byte)90);
                buf.putString(this.type);
                buf.putInt(this.id);
                buf.putInt(this.lwsize);
                buf.putInt(this.lmpsize);
                this.session.write(packet);
                int retry = 1000;
                while (this.getRecipient() == -1 && this.session.isConnected() && retry > 0) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                    --retry;
                }
                if (!this.session.isConnected()) {
                    throw new JSchException("session is down");
                }
                if (retry == 0) {
                    throw new JSchException("channel is not opened.");
                }
                this.start();
            }
            catch (Exception e) {
                if (!(e instanceof JSchException)) break block8;
                throw (JSchException)e;
            }
        }
    }

    public void setXForwarding(boolean foo) {
    }

    void start() {
    }

    public boolean isEOF() {
        return this.eof;
    }

    void getData(Buffer buf) {
        this.setRecipient(buf.getInt());
        this.setRemoteWindowSize(buf.getInt());
        this.setRemotePacketSize(buf.getInt());
    }

    public void setInputStream(InputStream in) {
        this.io.setInputStream(in);
    }

    public void setOutputStream(OutputStream out) {
        this.io.setOutputStream(out);
    }

    public void setExtOutputStream(OutputStream out) {
        this.io.setExtOutputStream(out);
    }

    public InputStream getInputStream() throws IOException {
        PipedInputStream in = new PipedInputStream();
        this.io.setOutputStream(new PassiveOutputStream(in));
        return in;
    }

    public InputStream getExtInputStream() throws IOException {
        PipedInputStream in = new PipedInputStream();
        this.io.setExtOutputStream(new PassiveOutputStream(in));
        return in;
    }

    public OutputStream getOutputStream() throws IOException {
        PipedOutputStream out = new PipedOutputStream();
        this.io.setInputStream(new PassiveInputStream(out));
        return out;
    }

    void setLocalWindowSizeMax(int foo) {
        this.lwsize_max = foo;
    }

    void setLocalWindowSize(int foo) {
        this.lwsize = foo;
    }

    void setLocalPacketSize(int foo) {
        this.lmpsize = foo;
    }

    void setRemoteWindowSize(int foo) {
        this.rwsize = foo;
    }

    void addRemoteWindowSize(int foo) {
        this.rwsize += foo;
    }

    void setRemotePacketSize(int foo) {
        this.rmpsize = foo;
    }

    public void run() {
    }

    void write(byte[] foo) throws IOException {
        this.write(foo, 0, foo.length);
    }

    void write(byte[] foo, int s, int l) throws IOException {
        if (this.eof) {
            return;
        }
        if (this.io.out != null) {
            this.io.put(foo, s, l);
        }
    }

    void write_ext(byte[] foo, int s, int l) throws IOException {
        if (this.eof) {
            return;
        }
        if (this.io.out_ext != null) {
            this.io.put_ext(foo, s, l);
        }
    }

    void eof() {
        if (this.eof) {
            return;
        }
        this.eof = true;
        try {
            Buffer buf = new Buffer(100);
            Packet packet = new Packet(buf);
            packet.reset();
            buf.putByte((byte)96);
            buf.putInt(this.getRecipient());
            this.session.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void close() {
        if (this.close) {
            return;
        }
        this.close = true;
        try {
            Buffer buf = new Buffer(100);
            Packet packet = new Packet(buf);
            packet.reset();
            buf.putByte((byte)97);
            buf.putInt(this.getRecipient());
            this.session.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void eof(Session session) {
        int i = 0;
        while (i < pool.size()) {
            try {
                Channel c = (Channel)pool.elementAt(i);
                if (c.session == session) {
                    c.eof();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public void disconnect() {
        block8: {
            this.close();
            this.thread = null;
            try {
                if (this.io == null) break block8;
                try {
                    if (this.io.in != null && this.io.in instanceof PassiveInputStream) {
                        this.io.in.close();
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
                try {
                    if (this.io.out != null && this.io.out instanceof PassiveOutputStream) {
                        this.io.out.close();
                    }
                }
                catch (Exception ee) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.io = null;
        Channel.del(this);
    }

    public void sendSignal(String foo) throws Exception {
        RequestSignal request = new RequestSignal();
        request.setSignal(foo);
        request.request(this.session, this);
    }

    void setExitStatus(int foo) {
        this.exitstatus = foo;
    }

    public int getExitStatus() {
        return this.exitstatus;
    }

    void setSession(Session session) {
        this.session = session;
    }

    class PassiveOutputStream
    extends PipedOutputStream {
        PassiveOutputStream(PipedInputStream in) throws IOException {
            super(in);
        }
    }

    class PassiveInputStream
    extends PipedInputStream {
        PipedOutputStream out;

        PassiveInputStream(PipedOutputStream out) throws IOException {
            super(out);
            this.out = out;
        }

        public void close() throws IOException {
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
    }
}

