/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.events.EventStats;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.events.ResourceChangeEvent;
import org.eclipse.core.internal.events.ResourceChangeListenerList;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.internal.events.ResourceDeltaFactory;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.MarkerDelta;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class NotificationManager
implements IManager,
ILifecycleListener {
    private static final long NOTIFICATION_DELAY = 1500L;
    private Set avoidNotify = new HashSet();
    private long buildMarkerChangeId;
    private Map buildMarkerDeltas;
    protected boolean isNotifying;
    private ResourceDelta lastDelta;
    private long lastDeltaId;
    private ElementTree lastDeltaState;
    protected long lastNotifyDuration = 0L;
    private long lastPostBuildId = 0L;
    private ElementTree lastPostBuildTree;
    private long lastPostChangeId = 0L;
    private ElementTree lastPostChangeTree;
    private ResourceChangeListenerList listeners;
    protected boolean notificationRequested = false;
    private Job notifyJob;
    Workspace workspace;

    public NotificationManager(Workspace workspace) {
        this.workspace = workspace;
        this.listeners = new ResourceChangeListenerList();
        this.notifyJob = new NotifyJob();
    }

    public void addListener(IResourceChangeListener listener, int eventMask) {
        ResourceChangeListenerList resourceChangeListenerList = this.listeners;
        synchronized (resourceChangeListenerList) {
            this.listeners.add(listener, eventMask);
        }
        EventStats.listenerAdded(listener);
    }

    public boolean beginAvoidNotify() {
        return this.avoidNotify.add(Thread.currentThread());
    }

    public void beginNotify() {
        this.notifyJob.cancel();
        this.notificationRequested = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void broadcastChanges(ElementTree lastState, int type, boolean lockTree) throws CoreException {
        boolean postChange2;
        block15: {
            boolean bl;
            block14: {
                ResourceDelta delta = null;
                try {
                    block17: {
                        block16: {
                            this.isNotifying = true;
                            if (this.listeners.hasListenerFor(type)) {
                                delta = this.getDelta(lastState, type);
                            }
                            if (delta == null) break block16;
                            if (delta.getKind() != 0) break block17;
                        }
                        Object var7_5 = null;
                        this.isNotifying = false;
                        bl = type == 1;
                        break block14;
                    }
                    long start = System.currentTimeMillis();
                    this.notify(this.getListeners(), new ResourceChangeEvent((Object)this.workspace, type, delta), lockTree);
                    this.lastNotifyDuration = System.currentTimeMillis() - start;
                    break block15;
                }
                catch (Throwable throwable) {
                    boolean postChange2;
                    Object var7_6 = null;
                    this.isNotifying = false;
                    boolean bl2 = postChange2 = type == 1;
                    if (!postChange2) {
                        if (type != 16) throw throwable;
                    }
                    long id = this.workspace.getMarkerManager().getChangeId();
                    lastState.immutable();
                    if (postChange2) {
                        this.lastPostChangeTree = lastState;
                        this.lastPostChangeId = id;
                    } else {
                        this.lastPostBuildTree = lastState;
                        this.lastPostBuildId = id;
                    }
                    this.workspace.getMarkerManager().resetMarkerDeltas(Math.min(this.lastPostBuildId, this.lastPostChangeId));
                    this.lastDelta = null;
                    this.lastDeltaState = lastState;
                    throw throwable;
                }
            }
            boolean postChange2 = bl;
            if (!postChange2) {
                if (type != 16) return;
            }
            long id = this.workspace.getMarkerManager().getChangeId();
            lastState.immutable();
            if (postChange2) {
                this.lastPostChangeTree = lastState;
                this.lastPostChangeId = id;
            } else {
                this.lastPostBuildTree = lastState;
                this.lastPostBuildId = id;
            }
            this.workspace.getMarkerManager().resetMarkerDeltas(Math.min(this.lastPostBuildId, this.lastPostChangeId));
            this.lastDelta = null;
            this.lastDeltaState = lastState;
            return;
        }
        Object var7_7 = null;
        this.isNotifying = false;
        boolean bl = postChange2 = type == 1;
        if (!postChange2) {
            if (type != 16) return;
        }
        long id = this.workspace.getMarkerManager().getChangeId();
        lastState.immutable();
        if (postChange2) {
            this.lastPostChangeTree = lastState;
            this.lastPostChangeId = id;
        } else {
            this.lastPostBuildTree = lastState;
            this.lastPostBuildId = id;
        }
        this.workspace.getMarkerManager().resetMarkerDeltas(Math.min(this.lastPostBuildId, this.lastPostChangeId));
        this.lastDelta = null;
        this.lastDeltaState = lastState;
    }

    public void broadcastChanges(IResourceChangeListener listener, int type, IResourceDelta delta) {
        ResourceChangeListenerList.ListenerEntry[] entries = new ResourceChangeListenerList.ListenerEntry[]{new ResourceChangeListenerList.ListenerEntry(listener, type)};
        this.notify(entries, new ResourceChangeEvent((Object)this.workspace, type, delta), false);
    }

    public void endAvoidNotify() {
        this.avoidNotify.remove(Thread.currentThread());
    }

    public void endOperation() {
        if (this.avoidNotify.contains(Thread.currentThread())) {
            return;
        }
        long delay = Math.max(1500L, this.lastNotifyDuration * 10L);
        if (this.notifyJob.getState() == 0) {
            this.notifyJob.schedule(delay);
        }
    }

    protected ResourceDelta getDelta(ElementTree tree, int type) {
        boolean postChange;
        long id = this.workspace.getMarkerManager().getChangeId();
        boolean bl = postChange = type == 1;
        if (this.lastDelta != null && !ElementTree.hasChanges(tree, this.lastDeltaState, ResourceComparator.getComparator(true), true)) {
            if (id != this.lastDeltaId) {
                Map markerDeltas = this.workspace.getMarkerManager().getMarkerDeltas(this.lastPostBuildId);
                this.lastDelta.updateMarkers(markerDeltas);
            }
        } else {
            ElementTree oldTree = postChange ? this.lastPostChangeTree : this.lastPostBuildTree;
            long markerId = postChange ? this.lastPostChangeId : this.lastPostBuildId;
            this.lastDelta = ResourceDeltaFactory.computeDelta(this.workspace, oldTree, tree, (IPath)Path.ROOT, markerId + 1L);
        }
        this.lastDeltaState = tree;
        this.lastDeltaId = id;
        return this.lastDelta;
    }

    protected ResourceChangeListenerList.ListenerEntry[] getListeners() {
        ResourceChangeListenerList.ListenerEntry[] result;
        ResourceChangeListenerList resourceChangeListenerList = this.listeners;
        synchronized (resourceChangeListenerList) {
            result = this.listeners.getListeners();
        }
        return result;
    }

    public void handleEvent(LifecycleEvent event) {
        switch (event.kind) {
            case 1: {
                if (!this.listeners.hasListenerFor(2)) {
                    return;
                }
                IProject project = (IProject)event.resource;
                this.notify(this.getListeners(), new ResourceChangeEvent((Object)this.workspace, 2, project), true);
                break;
            }
            case 64: {
                if (event.resource.equals(event.newResource)) {
                    return;
                }
            }
            case 16: {
                if (!this.listeners.hasListenerFor(4)) {
                    return;
                }
                IProject project = (IProject)event.resource;
                this.notify(this.getListeners(), new ResourceChangeEvent((Object)this.workspace, 4, project), true);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void notify(ResourceChangeListenerList.ListenerEntry[] resourceListeners, IResourceChangeEvent event, boolean lockTree) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 129->133)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void removeListener(IResourceChangeListener listener) {
        ResourceChangeListenerList resourceChangeListenerList = this.listeners;
        synchronized (resourceChangeListenerList) {
            this.listeners.remove(listener);
        }
        EventStats.listenerRemoved(listener);
    }

    public boolean shouldNotify() {
        return !this.isNotifying && this.notificationRequested;
    }

    public void shutdown(IProgressMonitor monitor) {
        this.listeners = new ResourceChangeListenerList();
    }

    public void startup(IProgressMonitor monitor) {
        this.lastPostBuildTree = this.lastPostChangeTree = this.workspace.getElementTree();
        this.workspace.addLifecycleListener(this);
    }

    protected void updateMarkerDeltas(Map newDeltas, long changeId) {
        if (changeId == this.buildMarkerChangeId) {
            return;
        }
        this.buildMarkerChangeId = changeId;
        this.buildMarkerDeltas = MarkerDelta.merge(this.buildMarkerDeltas, this.lastDelta.getDeltaInfo().getMarkerDeltas());
    }

    class NotifyJob
    extends Job {
        private final IWorkspaceRunnable noop = new IWorkspaceRunnable(this){
            final /* synthetic */ NotifyJob this$1;
            {
                this.this$1 = notifyJob;
            }

            public void run(IProgressMonitor monitor) throws CoreException {
            }
        };

        public NotifyJob() {
            super(ICoreConstants.MSG_RESOURCES_UPDATING);
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            NotificationManager.this.notificationRequested = true;
            try {
                NotificationManager.this.workspace.run(this.noop, null, 0, null);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return Status.OK_STATUS;
        }
    }
}

