/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class AutoBuildJob
extends Job {
    private boolean avoidBuild = false;
    private boolean buildNeeded = false;
    private boolean forceBuild = false;
    private long lastBuild = 0L;
    private Workspace workspace;

    AutoBuildJob(Workspace workspace) {
        super(ICoreConstants.MSG_EVENTS_BUILDING_0);
        this.setRule(workspace.getRoot());
        this.setSystem(!workspace.isAutoBuilding());
        this.workspace = workspace;
    }

    public void autoBuildChanged(boolean wasAutoBuilding, boolean isAutoBuilding) {
        this.setSystem(!isAutoBuilding);
        if (!this.forceBuild && !wasAutoBuilding && isAutoBuilding) {
            this.forceBuild = true;
            this.endTopLevel(false);
        }
    }

    public synchronized void avoidBuild() {
        this.avoidBuild = true;
    }

    public boolean belongsTo(Object family) {
        return family == ResourcesPlugin.FAMILY_AUTO_BUILD;
    }

    private void broadcastChanges(int type) throws CoreException {
        this.workspace.getNotificationManager().broadcastChanges(this.workspace.getElementTree(), type, false);
    }

    synchronized boolean checkCancel() {
        int state = this.getState();
        if (state == 2) {
            this.cancel();
            return false;
        }
        return state == 4 && InternalPlatform.getDefault().getJobManager().currentJob() != this;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doBuild(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(null, Policy.opWork);
            try {
                this.workspace.prepareOperation(this.workspace.getRoot(), monitor);
                this.workspace.beginOperation(true);
                this.broadcastChanges(8);
                if (this.shouldBuild()) {
                    this.workspace.getBuildManager().build(9, Policy.subMonitorFor(monitor, Policy.opWork));
                }
                this.broadcastChanges(16);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                if (this.workspace.getElementTree().isImmutable()) {
                    this.workspace.newWorkingTree();
                }
                this.workspace.endOperation(this.workspace.getRoot(), false, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            {
                Object var2_4 = null;
                if (this.workspace.getElementTree().isImmutable()) {
                    this.workspace.newWorkingTree();
                }
                this.workspace.endOperation(this.workspace.getRoot(), false, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        monitor.done();
    }

    public synchronized void endTopLevel(boolean needsBuild) {
        this.buildNeeded |= needsBuild;
        long delay = Math.max(100L, 1000L + this.lastBuild - System.currentTimeMillis());
        this.schedule(delay);
    }

    public IStatus run(IProgressMonitor monitor) {
        AutoBuildJob autoBuildJob = this;
        synchronized (autoBuildJob) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
        }
        try {
            this.doBuild(monitor);
            this.lastBuild = System.currentTimeMillis();
            return Status.OK_STATUS;
        }
        catch (OperationCanceledException operationCanceledException) {
            this.buildNeeded = true;
            return Status.CANCEL_STATUS;
        }
        catch (CoreException sig) {
            return sig.getStatus();
        }
    }

    public synchronized boolean shouldBuild() {
        block7: {
            block6: {
                block5: {
                    try {
                        if (this.workspace.isAutoBuilding()) break block5;
                        Object var1_1 = null;
                        this.avoidBuild = false;
                        this.forceBuild = false;
                        return false;
                    }
                    catch (Throwable throwable) {
                        Object var1_5 = null;
                        this.avoidBuild = false;
                        this.forceBuild = false;
                        throw throwable;
                    }
                }
                if (!this.forceBuild) break block6;
                Object var1_2 = null;
                this.avoidBuild = false;
                this.forceBuild = false;
                return true;
            }
            if (!this.avoidBuild) break block7;
            Object var1_3 = null;
            this.avoidBuild = false;
            this.forceBuild = false;
            return false;
        }
        boolean bl = this.buildNeeded;
        Object var1_4 = null;
        this.avoidBuild = false;
        this.forceBuild = false;
        return bl;
    }
}

