/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.JUnitStatus;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.internal.junit.util.LayoutUtil;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.internal.junit.wizards.MethodStubsSelectionButtonGroup;
import org.eclipse.jdt.internal.junit.wizards.NewTestCaseCreationWizardPage2;
import org.eclipse.jdt.internal.junit.wizards.WizardMessages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewTestCaseCreationWizardPage
extends NewTypeWizardPage {
    private static final String PAGE_NAME = "NewTestCaseCreationWizardPage";
    private static final String CLASS_TO_TEST = "NewTestCaseCreationWizardPage.classtotest";
    private static final String TEST_SUFFIX = "Test";
    private static final String SETUP = "setUp";
    private static final String TEARDOWN = "tearDown";
    private static final String STORE_GENERATE_MAIN = "NewTestCaseCreationWizardPage.GENERATE_MAIN";
    private static final String STORE_USE_TESTRUNNER = "NewTestCaseCreationWizardPage.USE_TESTRUNNER";
    private static final String STORE_TESTRUNNER_TYPE = "NewTestCaseCreationWizardPage.TESTRUNNER_TYPE";
    private String fDefaultClassToTest;
    private NewTestCaseCreationWizardPage2 fPage2;
    private MethodStubsSelectionButtonGroup fMethodStubsButtons;
    private IType fClassToTest;
    private IStatus fClassToTestStatus;
    private IStatus fTestClassStatus;
    private int fIndexOfFirstTestMethod;
    private Label fClassToTestLabel;
    private Text fClassToTestText;
    private Button fClassToTestButton;
    private boolean fFirstTime = true;

    public NewTestCaseCreationWizardPage() {
        super(true, PAGE_NAME);
        this.setTitle(WizardMessages.getString("NewTestClassWizPage.title"));
        this.setDescription(WizardMessages.getString("NewTestClassWizPage.description"));
        String[] buttonNames = new String[]{"public static void main(Strin&g[] args)", WizardMessages.getString("NewTestClassWizPage.methodStub.testRunner"), WizardMessages.getString("NewTestClassWizPage.methodStub.setUp"), WizardMessages.getString("NewTestClassWizPage.methodStub.tearDown"), WizardMessages.getString("NewTestClassWizPage.methodStub.constructor")};
        this.fMethodStubsButtons = new MethodStubsSelectionButtonGroup(32, buttonNames, 1);
        this.fMethodStubsButtons.setLabelText(WizardMessages.getString("NewTestClassWizPage.method.Stub.label"));
        this.fClassToTestStatus = new JUnitStatus();
        this.fTestClassStatus = new JUnitStatus();
        this.fDefaultClassToTest = "";
    }

    public void init(IStructuredSelection selection, NewTestCaseCreationWizardPage2 page2) {
        this.fPage2 = page2;
        IJavaElement element = this.getInitialJavaElement(selection);
        this.initContainerPage(element);
        this.initTypePage(element);
        this.doStatusUpdate();
        if (element != null) {
            IType classToTest = null;
            IType typeInCompUnit = (IType)element.getAncestor(7);
            if (typeInCompUnit != null) {
                if (typeInCompUnit.getCompilationUnit() != null) {
                    classToTest = typeInCompUnit;
                }
            } else {
                ICompilationUnit cu = (ICompilationUnit)element.getAncestor(5);
                if (cu != null) {
                    classToTest = cu.findPrimaryType();
                } else if (element instanceof IClassFile) {
                    try {
                        IClassFile cf = (IClassFile)element;
                        if (cf.isStructureKnown()) {
                            classToTest = cf.getType();
                        }
                    }
                    catch (JavaModelException e) {
                        JUnitPlugin.log(e);
                    }
                }
            }
            if (classToTest != null) {
                try {
                    if (!TestSearchEngine.isTestImplementor(classToTest)) {
                        this.fDefaultClassToTest = classToTest.getFullyQualifiedName();
                    }
                }
                catch (JavaModelException e) {
                    JUnitPlugin.log(e);
                }
            }
        }
        this.fMethodStubsButtons.setSelection(0, false);
        this.fMethodStubsButtons.setSelection(1, false);
        this.fMethodStubsButtons.setEnabled(1, false);
        this.fMethodStubsButtons.setSelection(2, false);
        this.fMethodStubsButtons.setSelection(3, false);
        this.fMethodStubsButtons.setSelection(4, false);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName.equals(CLASS_TO_TEST)) {
            this.fClassToTestStatus = this.classToTestClassChanged();
        } else if (fieldName.equals("NewTypeWizardPage.superclass")) {
            this.validateSuperClass();
            if (!this.fFirstTime) {
                this.fTestClassStatus = this.typeNameChanged();
            }
        } else if (fieldName.equals("NewTypeWizardPage.typename")) {
            this.fTestClassStatus = this.typeNameChanged();
        } else if (fieldName.equals("NewTypeWizardPage.package") || fieldName.equals("NewContainerWizardPage.container") || fieldName.equals("NewTypeWizardPage.superclass")) {
            if (fieldName.equals("NewTypeWizardPage.package")) {
                this.fPackageStatus = this.packageChanged();
            }
            if (!this.fFirstTime) {
                this.validateSuperClass();
                this.fClassToTestStatus = this.classToTestClassChanged();
                this.fTestClassStatus = this.typeNameChanged();
            }
            if (fieldName.equals("NewContainerWizardPage.container")) {
                this.validateJUnitOnBuildPath();
            }
        }
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTestClassStatus, this.fClassToTestStatus, this.fModifierStatus, this.fSuperClassStatus};
        this.updateStatus(status);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createClassToTestControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.setSuperClass("junit.framework.TestCase", true);
        this.setControl((Control)composite);
        if (this.fDefaultClassToTest.length() > 0) {
            this.fClassToTestText.setText(this.fDefaultClassToTest);
            this.setTypeName(String.valueOf(Signature.getSimpleName((String)this.fDefaultClassToTest)) + TEST_SUFFIX, true);
        }
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.junit.new_testcase_wizard_page_context");
    }

    private void createMethodStubSelectionControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getLabelControl(composite), nColumns);
        LayoutUtil.createEmptySpace(composite, 1);
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getSelectionButtonsGroup(composite), nColumns - 1);
    }

    private void createClassToTestControls(Composite composite, int nColumns) {
        this.fClassToTestLabel = new Label(composite, 16448);
        this.fClassToTestLabel.setFont(composite.getFont());
        this.fClassToTestLabel.setText(WizardMessages.getString("NewTestClassWizPage.class_to_test.label"));
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.fClassToTestLabel.setLayoutData((Object)gd);
        this.fClassToTestText = new Text(composite, 2052);
        this.fClassToTestText.setEnabled(true);
        this.fClassToTestText.setFont(composite.getFont());
        this.fClassToTestText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTestCaseCreationWizardPage.this.handleFieldChanged(NewTestCaseCreationWizardPage.CLASS_TO_TEST);
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = nColumns - 2;
        this.fClassToTestText.setLayoutData((Object)gd);
        this.fClassToTestButton = new Button(composite, 8);
        this.fClassToTestButton.setText(WizardMessages.getString("NewTestClassWizPage.class_to_test.browse"));
        this.fClassToTestButton.setEnabled(true);
        this.fClassToTestButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                NewTestCaseCreationWizardPage.this.classToTestButtonPressed();
            }

            public void widgetSelected(SelectionEvent e) {
                NewTestCaseCreationWizardPage.this.classToTestButtonPressed();
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = 1;
        gd.heightHint = SWTUtil.getButtonHeightHint((Button)this.fClassToTestButton);
        gd.widthHint = SWTUtil.getButtonWidthHint((Button)this.fClassToTestButton);
        this.fClassToTestButton.setLayoutData((Object)gd);
    }

    private void classToTestButtonPressed() {
        IType type = this.chooseClassToTestType();
        if (type != null) {
            this.fClassToTestText.setText(JavaModelUtil.getFullyQualifiedName((IType)type));
            this.handleFieldChanged(CLASS_TO_TEST);
        }
    }

    private IType chooseClassToTestType() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IType type = null;
        try {
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)this.getWizard().getContainer(), (IJavaSearchScope)scope, (int)2, (boolean)false, (String)this.getClassToTestText());
            dialog.setTitle(WizardMessages.getString("NewTestClassWizPage.class_to_test.dialog.title"));
            dialog.setMessage(WizardMessages.getString("NewTestClassWizPage.class_to_test.dialog.message"));
            dialog.open();
            if (dialog.getReturnCode() != 0) {
                return type;
            }
            Object[] resultArray = dialog.getResult();
            if (resultArray != null && resultArray.length > 0) {
                type = (IType)resultArray[0];
            }
        }
        catch (JavaModelException e) {
            JUnitPlugin.log(e);
        }
        return type;
    }

    private IStatus classToTestClassChanged() {
        this.fClassToTestButton.setEnabled(this.getPackageFragmentRoot() != null);
        JUnitStatus status = this.validateClassToTest();
        return status;
    }

    public String getClassToTestText() {
        return this.fClassToTestText.getText();
    }

    public IType getClassToTest() {
        return this.fClassToTest;
    }

    public void setClassToTest(String name) {
        this.fClassToTestText.setText(name);
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.fIndexOfFirstTestMethod = 0;
        if (this.fMethodStubsButtons.isSelected(0)) {
            this.createMain(type);
        }
        if (this.fMethodStubsButtons.isSelected(2)) {
            this.createSetUp(type, imports);
        }
        if (this.fMethodStubsButtons.isSelected(3)) {
            this.createTearDown(type, imports);
        }
        if (this.fMethodStubsButtons.isSelected(4)) {
            this.createConstructor(type, imports);
        }
        if (this.isNextPageValid()) {
            this.createTestMethodStubs(type);
        }
    }

    private void createConstructor(IType type, NewTypeWizardPage.ImportsManager imports) throws JavaModelException {
        ITypeHierarchy typeHierarchy = null;
        IType[] superTypes = null;
        String constr = "";
        IMethod methodTemplate = null;
        if (type.exists()) {
            typeHierarchy = type.newSupertypeHierarchy(null);
            superTypes = typeHierarchy.getAllSuperclasses(type);
            int i = 0;
            while (i < superTypes.length) {
                IMethod constrMethod;
                if (superTypes[i].exists() && (constrMethod = superTypes[i].getMethod(superTypes[i].getElementName(), new String[]{"Ljava.lang.String;"})).exists() && constrMethod.isConstructor()) {
                    methodTemplate = constrMethod;
                    break;
                }
                ++i;
            }
        }
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        if (methodTemplate != null) {
            JUnitStubUtility.GenStubSettings genStubSettings = new JUnitStubUtility.GenStubSettings(settings);
            genStubSettings.fCallSuper = true;
            genStubSettings.fMethodOverwrites = true;
            constr = JUnitStubUtility.genStub(this.getTypeName(), methodTemplate, genStubSettings, imports);
        } else {
            constr = String.valueOf(constr) + "public " + this.getTypeName() + "(String name) {" + this.getLineDelimiter() + "super(name);" + this.getLineDelimiter() + "}" + this.getLineDelimiter() + this.getLineDelimiter();
        }
        type.createMethod(constr, null, true, null);
        ++this.fIndexOfFirstTestMethod;
    }

    private void createMain(IType type) throws JavaModelException {
        type.createMethod(this.fMethodStubsButtons.getMainMethod(this.getTypeName()), null, false, null);
        ++this.fIndexOfFirstTestMethod;
    }

    private void createSetUp(IType type, NewTypeWizardPage.ImportsManager imports) throws JavaModelException {
        ITypeHierarchy typeHierarchy = null;
        IType[] superTypes = null;
        String setUp = "";
        IMethod methodTemplate = null;
        if (type.exists()) {
            typeHierarchy = type.newSupertypeHierarchy(null);
            superTypes = typeHierarchy.getAllSuperclasses(type);
            int i = 0;
            while (i < superTypes.length) {
                IMethod testMethod;
                if (superTypes[i].exists() && (testMethod = superTypes[i].getMethod(SETUP, new String[0])).exists()) {
                    methodTemplate = testMethod;
                    break;
                }
                ++i;
            }
        }
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        if (methodTemplate != null) {
            JUnitStubUtility.GenStubSettings genStubSettings = new JUnitStubUtility.GenStubSettings(settings);
            genStubSettings.fCallSuper = true;
            genStubSettings.fMethodOverwrites = true;
            setUp = JUnitStubUtility.genStub(this.getTypeName(), methodTemplate, genStubSettings, imports);
        } else {
            if (settings.createComments) {
                setUp = "/**" + this.getLineDelimiter() + " * Sets up the fixture, for example, open a network connection." + this.getLineDelimiter() + " * This method is called before a test is executed." + this.getLineDelimiter() + " * @throws Exception" + this.getLineDelimiter() + " */" + this.getLineDelimiter();
            }
            setUp = String.valueOf(setUp) + "protected void setUp() throws Exception {}" + this.getLineDelimiter() + this.getLineDelimiter();
        }
        type.createMethod(setUp, null, false, null);
        ++this.fIndexOfFirstTestMethod;
    }

    private void createTearDown(IType type, NewTypeWizardPage.ImportsManager imports) throws JavaModelException {
        ITypeHierarchy typeHierarchy = null;
        IType[] superTypes = null;
        String tearDown = "";
        IMethod methodTemplate = null;
        if (type.exists()) {
            if (typeHierarchy == null) {
                typeHierarchy = type.newSupertypeHierarchy(null);
                superTypes = typeHierarchy.getAllSuperclasses(type);
            }
            int i = 0;
            while (i < superTypes.length) {
                IMethod testM;
                if (superTypes[i].exists() && (testM = superTypes[i].getMethod(TEARDOWN, new String[0])).exists()) {
                    methodTemplate = testM;
                    break;
                }
                ++i;
            }
        }
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        if (methodTemplate != null) {
            JUnitStubUtility.GenStubSettings genStubSettings = new JUnitStubUtility.GenStubSettings(settings);
            genStubSettings.fCallSuper = true;
            genStubSettings.fMethodOverwrites = true;
            tearDown = JUnitStubUtility.genStub(this.getTypeName(), methodTemplate, genStubSettings, imports);
            type.createMethod(tearDown, null, false, null);
            ++this.fIndexOfFirstTestMethod;
        }
    }

    private void createTestMethodStubs(IType type) throws JavaModelException {
        IMethod[] methods = this.fPage2.getCheckedMethods();
        if (methods.length == 0) {
            return;
        }
        IMethod[] allMethodsArray = this.fPage2.getAllMethods();
        ArrayList<IMethod> allMethods = new ArrayList<IMethod>();
        allMethods.addAll(Arrays.asList(allMethodsArray));
        List overloadedMethods = this.getOveloadedMethods(allMethods);
        ArrayList<String> newMethodsNames = new ArrayList<String>();
        int i = 0;
        while (i < methods.length) {
            IMethod testedMethod = methods[i];
            String elementName = testedMethod.getElementName();
            StringBuffer methodName = new StringBuffer("test" + Character.toUpperCase(elementName.charAt(0)) + elementName.substring(1));
            StringBuffer newMethod = new StringBuffer();
            if (overloadedMethods.contains(testedMethod)) {
                this.appendMethodComment(newMethod, testedMethod);
                String[] params = testedMethod.getParameterTypes();
                this.appendParameterNamesToMethodName(methodName, params);
            }
            if (newMethodsNames.contains(methodName.toString())) {
                int suffix = 1;
                while (newMethodsNames.contains(String.valueOf(methodName.toString()) + Integer.toString(suffix))) {
                    ++suffix;
                }
                methodName.append(Integer.toString(suffix));
            }
            newMethodsNames.add(methodName.toString());
            newMethod.append("public ");
            if (this.fPage2.getCreateFinalMethodStubsButtonSelection()) {
                newMethod.append("final ");
            }
            newMethod.append("void ");
            newMethod.append(methodName.toString());
            newMethod.append("()");
            this.appendTestMethodBody(newMethod, testedMethod);
            type.createMethod(newMethod.toString(), null, false, null);
            ++i;
        }
    }

    private String getLineDelimiter() {
        IType classToTest = this.getClassToTest();
        if (classToTest != null && classToTest.exists()) {
            return JUnitStubUtility.getLineDelimiterUsed((IJavaElement)classToTest);
        }
        return JUnitStubUtility.getLineDelimiterUsed((IJavaElement)this.getPackageFragment());
    }

    private void appendTestMethodBody(StringBuffer newMethod, IMethod testedMethod) {
        newMethod.append("{");
        if (this.createTasks()) {
            newMethod.append(this.getLineDelimiter());
            newMethod.append("//");
            newMethod.append(JUnitStubUtility.getTodoTaskTag(this.getPackageFragment().getJavaProject()));
            newMethod.append(WizardMessages.getFormattedString("NewTestClassWizPage.marker.message", testedMethod.getElementName()));
            newMethod.append(this.getLineDelimiter());
        }
        newMethod.append("}").append(this.getLineDelimiter()).append(this.getLineDelimiter());
    }

    public void appendParameterNamesToMethodName(StringBuffer methodName, String[] params) {
        int i = 0;
        while (i < params.length) {
            String param = params[i];
            methodName.append(Signature.getSimpleName((String)Signature.toString((String)Signature.getElementType((String)param))));
            int j = 0;
            int arrayCount = Signature.getArrayCount((String)param);
            while (j < arrayCount) {
                methodName.append("Array");
                ++j;
            }
            ++i;
        }
    }

    private void appendMethodComment(StringBuffer newMethod, IMethod method) throws JavaModelException {
        String returnType = Signature.toString((String)method.getReturnType());
        String body = WizardMessages.getFormattedString("NewTestClassWizPage.comment.class_to_test", new String[]{returnType, method.getElementName()});
        newMethod.append("/*");
        newMethod.append(this.getLineDelimiter());
        newMethod.append(" * ");
        newMethod.append(body);
        newMethod.append("(");
        String[] paramTypes = method.getParameterTypes();
        if (paramTypes.length > 0) {
            if (paramTypes.length > 1) {
                int j = 0;
                while (j < paramTypes.length - 1) {
                    newMethod.append(String.valueOf(Signature.toString((String)paramTypes[j])) + ", ");
                    ++j;
                }
            }
            newMethod.append(Signature.toString((String)paramTypes[paramTypes.length - 1]));
        }
        newMethod.append(")");
        newMethod.append(this.getLineDelimiter());
        newMethod.append(" */");
        newMethod.append(this.getLineDelimiter());
    }

    private List getOveloadedMethods(List allMethods) {
        ArrayList<IMethod> overloadedMethods = new ArrayList<IMethod>();
        int i = 0;
        while (i < allMethods.size()) {
            IMethod current = (IMethod)allMethods.get(i);
            String currentName = current.getElementName();
            boolean currentAdded = false;
            ListIterator iter = allMethods.listIterator(i + 1);
            while (iter.hasNext()) {
                IMethod iterMethod = (IMethod)iter.next();
                if (!iterMethod.getElementName().equals(currentName)) continue;
                if (!currentAdded) {
                    overloadedMethods.add(current);
                    currentAdded = true;
                }
                overloadedMethods.add(iterMethod);
                iter.remove();
            }
            ++i;
        }
        return overloadedMethods;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.fFirstTime) {
            if (this.getClassToTestText().equals("")) {
                this.setPageComplete(false);
            } else {
                this.handleFieldChanged(CLASS_TO_TEST);
            }
            this.fFirstTime = false;
        }
        if (visible) {
            this.setFocus();
        }
    }

    private void validateJUnitOnBuildPath() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return;
        }
        IJavaProject jp = root.getJavaProject();
        try {
            if (jp.findType("junit.framework.TestCase") != null) {
                return;
            }
        }
        catch (JavaModelException javaModelException) {}
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)WizardMessages.getString("NewTestClassWizPage.not_on_buildpath.title"), (String)WizardMessages.getString("NewTestClassWizPage.not_on_buildpath.message"))) {
            try {
                NewTestCaseCreationWizardPage.addJUnitToBuildPath(jp);
                return;
            }
            catch (JavaModelException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)WizardMessages.getString("NewTestClassWizPage.cannot_add.title"), (String)WizardMessages.getString("NewTestClassWizPage.cannot_add.message"), (IStatus)e.getStatus());
            }
        }
        JUnitStatus status = new JUnitStatus();
        status.setWarning(WizardMessages.getString("NewTestClassWizPage.error.junitNotOnbuildpath"));
        this.fContainerStatus = status;
    }

    public static void addJUnitToBuildPath(IJavaProject project) throws JavaModelException {
        Path junitHome = new Path("JUNIT_HOME");
        IClasspathEntry entry = JavaCore.newVariableEntry((IPath)junitHome.append("junit.jar"), (IPath)junitHome.append("junitsrc.zip"), null);
        NewTestCaseCreationWizardPage.addToClasspath(project, entry);
    }

    private static void addToClasspath(IJavaProject project, IClasspathEntry entry) throws JavaModelException {
        IClasspathEntry[] oldEntries = project.getRawClasspath();
        int i = 0;
        while (i < oldEntries.length) {
            if (oldEntries[i].equals(entry)) {
                return;
            }
            ++i;
        }
        int nEntries = oldEntries.length;
        IClasspathEntry[] newEntries = new IClasspathEntry[nEntries + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, nEntries);
        newEntries[nEntries] = entry;
        project.setRawClasspath(newEntries, null);
    }

    public int getIndexOfFirstMethod() {
        return this.fIndexOfFirstTestMethod;
    }

    private boolean createTasks() {
        return this.fPage2.getCreateTasksButtonSelection();
    }

    private void validateSuperClass() {
        this.fMethodStubsButtons.setEnabled(2, true);
        this.fMethodStubsButtons.setEnabled(3, true);
        String superClassName = this.getSuperClass();
        if (superClassName == null || superClassName.trim().equals("")) {
            this.fSuperClassStatus = new JUnitStatus();
            ((JUnitStatus)this.fSuperClassStatus).setError(WizardMessages.getString("NewTestClassWizPage.error.superclass.empty"));
            return;
        }
        if (this.getPackageFragmentRoot() != null) {
            try {
                IType type = this.resolveClassNameToType(this.getPackageFragmentRoot().getJavaProject(), this.getPackageFragment(), superClassName);
                JUnitStatus status = new JUnitStatus();
                if (type == null) {
                    status.setWarning(WizardMessages.getString("NewTestClassWizPage.error.superclass.not_exist"));
                    this.fSuperClassStatus = status;
                } else {
                    if (type.isInterface()) {
                        status.setError(WizardMessages.getString("NewTestClassWizPage.error.superclass.is_interface"));
                        this.fSuperClassStatus = status;
                    }
                    if (!TestSearchEngine.isTestImplementor(type)) {
                        status.setError(WizardMessages.getFormattedString("NewTestClassWizPage.error.superclass.not_implementing_test_interface", "junit.framework.Test"));
                        this.fSuperClassStatus = status;
                    } else {
                        IMethod setupMethod = type.getMethod(SETUP, new String[0]);
                        IMethod teardownMethod = type.getMethod(TEARDOWN, new String[0]);
                        if (setupMethod.exists()) {
                            this.fMethodStubsButtons.setEnabled(2, !Flags.isFinal((int)setupMethod.getFlags()));
                        }
                        if (teardownMethod.exists()) {
                            this.fMethodStubsButtons.setEnabled(3, !Flags.isFinal((int)teardownMethod.getFlags()));
                        }
                    }
                }
            }
            catch (JavaModelException e) {
                JUnitPlugin.log(e);
            }
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getNextPage() != null && this.isNextPageValid();
    }

    protected boolean isNextPageValid() {
        return !this.getClassToTestText().equals("");
    }

    private JUnitStatus validateClassToTest() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        IPackageFragment pack = this.getPackageFragment();
        String classToTestName = this.getClassToTestText();
        JUnitStatus status = new JUnitStatus();
        this.fClassToTest = null;
        if (classToTestName.length() == 0) {
            return status;
        }
        IStatus val = JavaConventions.validateJavaTypeName((String)classToTestName);
        if (val.getSeverity() == 4) {
            status.setError(WizardMessages.getString("NewTestClassWizPage.error.class_to_test.not_valid"));
            return status;
        }
        if (root != null) {
            try {
                IType type = this.resolveClassNameToType(root.getJavaProject(), pack, classToTestName);
                if (type == null) {
                    status.setError(WizardMessages.getString("NewTestClassWizPage.error.class_to_test.not_exist"));
                    return status;
                }
                if (type.isInterface()) {
                    status.setWarning(WizardMessages.getFormattedString("NewTestClassWizPage.warning.class_to_test.is_interface", classToTestName));
                }
                if (pack != null && !JavaModelUtil.isVisible((IMember)type, (IPackageFragment)pack)) {
                    status.setWarning(WizardMessages.getFormattedString("NewTestClassWizPage.warning.class_to_test.not_visible", new String[]{type.isInterface() ? WizardMessages.getString("Interface") : WizardMessages.getString("Class"), classToTestName}));
                }
                this.fClassToTest = type;
            }
            catch (JavaModelException javaModelException) {
                status.setError(WizardMessages.getString("NewTestClassWizPage.error.class_to_test.not_valid"));
            }
        } else {
            status.setError("");
        }
        return status;
    }

    private IType resolveClassNameToType(IJavaProject jproject, IPackageFragment pack, String classToTestName) throws JavaModelException {
        IType type = null;
        if (type == null && pack != null) {
            String packName = pack.getElementName();
            if (!pack.isDefaultPackage()) {
                type = jproject.findType(packName, classToTestName);
            }
            if (type == null && !"java.lang".equals(packName)) {
                type = jproject.findType("java.lang", classToTestName);
            }
        }
        if (type == null) {
            type = jproject.findType(classToTestName);
        }
        return type;
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            boolean generateMain = settings.getBoolean(STORE_GENERATE_MAIN);
            this.fMethodStubsButtons.setSelection(0, generateMain);
            this.fMethodStubsButtons.setEnabled(1, generateMain);
            this.fMethodStubsButtons.setSelection(1, settings.getBoolean(STORE_USE_TESTRUNNER));
            try {
                this.fMethodStubsButtons.setComboSelection(settings.getInt(STORE_TESTRUNNER_TYPE));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_GENERATE_MAIN, this.fMethodStubsButtons.isSelected(0));
            settings.put(STORE_USE_TESTRUNNER, this.fMethodStubsButtons.isSelected(1));
            settings.put(STORE_TESTRUNNER_TYPE, this.fMethodStubsButtons.getComboSelection());
        }
    }
}

