/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class TestMethodSelectionDialog
extends ElementListSelectionDialog {
    private IRunnableContext fRunnableContext;
    private IJavaElement fElement;

    public TestMethodSelectionDialog(Shell shell, IRunnableContext context, IJavaElement element) {
        super(shell, (ILabelProvider)new JavaElementLabelProvider(2050));
        this.fRunnableContext = context;
        this.fElement = element;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.junit.test_selection_context");
    }

    public int open() {
        Object[] elements;
        IType testType = this.findTestType();
        if (testType == null) {
            return 1;
        }
        try {
            elements = this.searchTestMethods(this.fElement, testType, this.fRunnableContext);
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getParentShell(), (String)JUnitMessages.getString("TestMethodSelectionDialog.error.title"), (String)e.getTargetException().getMessage());
            return 1;
        }
        if (elements.length == 0) {
            String msg = JUnitMessages.getFormattedString("TestMethodSelectionDialog.notfound_message", this.fElement.getElementName());
            MessageDialog.openInformation((Shell)this.getParentShell(), (String)JUnitMessages.getString("TestMethodSelectionDialog.no_tests.title"), (String)msg);
            return 1;
        }
        this.setElements(elements);
        return super.open();
    }

    private IType findTestType() {
        String qualifiedName = "junit.framework.Test";
        HashSet<IType> result = new HashSet<IType>();
        try {
            IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
            int i = 0;
            while (i < projects.length) {
                IJavaProject project = projects[i];
                IType type = project.findType(qualifiedName);
                if (type != null) {
                    result.add(type);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            ErrorDialog.openError((Shell)this.getParentShell(), (String)JUnitMessages.getString("TestMethodSelectionDialog.error.notfound.title"), (String)JUnitMessages.getString("TestMethodSelectionDialog.error.notfound.message"), (IStatus)e.getStatus());
            return null;
        }
        if (result.size() == 0) {
            String msg = JUnitMessages.getFormattedString("TestMethodSelectionDialog.test_not_found", "junit.framework.Test");
            MessageDialog.openError((Shell)this.getParentShell(), (String)JUnitMessages.getString("TestMethodSelectionDialog.select_dialog.title"), (String)msg);
            return null;
        }
        if (result.size() == 1) {
            return (IType)result.toArray()[0];
        }
        return this.selectTestType(result);
    }

    private IType selectTestType(Set result) {
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(66);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getParentShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(JUnitMessages.getString("TestMethodSelectionDialog.dialog.title"));
        String msg = JUnitMessages.getFormattedString("TestMethodSelectionDialog.testproject", "junit.framework.Test");
        dialog.setMessage(msg);
        Object[] projects = new IJavaProject[result.size()];
        IType[] testTypes = result.toArray(new IType[result.size()]);
        int i = 0;
        while (i < projects.length) {
            projects[i] = testTypes[i].getJavaProject();
            ++i;
        }
        dialog.setElements(projects);
        if (dialog.open() == 1) {
            return null;
        }
        IJavaProject project = (IJavaProject)dialog.getFirstResult();
        int i2 = 0;
        while (i2 < testTypes.length) {
            if (testTypes[i2].getJavaProject().equals(project)) {
                return testTypes[i2];
            }
            ++i2;
        }
        return null;
    }

    public Object[] searchTestMethods(final IJavaElement element, final IType testType, IRunnableContext context) throws InvocationTargetException, InterruptedException {
        final TestReferenceCollector[] col = new TestReferenceCollector[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    col[0] = TestMethodSelectionDialog.this.doSearchTestMethods(element, testType, pm);
                }
                catch (JavaModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        context.run(true, true, runnable);
        return col[0].getResult();
    }

    private TestReferenceCollector doSearchTestMethods(IJavaElement element, IType testType, IProgressMonitor pm) throws JavaModelException {
        IJavaSearchScope scope = SearchEngine.createHierarchyScope((IType)testType);
        TestReferenceCollector collector = new TestReferenceCollector(pm);
        new SearchEngine().search(ResourcesPlugin.getWorkspace(), element, 2, scope, (IJavaSearchResultCollector)collector);
        return collector;
    }

    public static class TestReferenceCollector
    implements IJavaSearchResultCollector {
        IProgressMonitor fMonitor;
        Set fResult = new HashSet(200);

        public TestReferenceCollector(IProgressMonitor pm) {
            this.fMonitor = pm;
        }

        public void aboutToStart() {
        }

        public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) throws CoreException {
            if (enclosingElement.getElementName().startsWith("test")) {
                this.fResult.add(enclosingElement);
            }
        }

        public void done() {
        }

        public IProgressMonitor getProgressMonitor() {
            return this.fMonitor;
        }

        public Object[] getResult() {
            return this.fResult.toArray();
        }
    }
}

